/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmt.modisco.common.editor.MoDiscoEditorPlugin;
import org.eclipse.gmt.modisco.common.editor.adapters.AttributeItemProvider;
import org.eclipse.gmt.modisco.common.editor.adapters.BigListItemProvider;
import org.eclipse.gmt.modisco.common.editor.adapters.ContainmentLinkItemProvider;
import org.eclipse.gmt.modisco.common.editor.adapters.LinkItemProvider;
import org.eclipse.gmt.modisco.common.editor.adapters.ParentAdapter;
import org.eclipse.gmt.modisco.common.editor.adapters.ParentAdapterFactory;
import org.eclipse.gmt.modisco.common.editor.adapters.TransientItemProvider;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;
import org.eclipse.gmt.modisco.common.editor.extensions.icons.IconProvidersRegistry;
import org.eclipse.gmt.modisco.common.editor.extensions.naming.NameProvidersRegistry;
import org.eclipse.gmt.modisco.common.editor.util.EMFUtil;
import org.eclipse.gmt.modisco.common.editor.util.Util;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiaReflectiveItemProvider
extends ReflectiveItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IItemColorProvider {
    private URI EXTERNAL_COLOR = URI.createURI((String)"color://rgb/0/0/255");
    private URI NULL_RESOURCE_COLOR = URI.createURI((String)"color://rgb/192/0/0");
    private final EditorConfiguration editorConfiguration;
    private HashMap<EReference, LinkItemProvider> linkItemProviders = new HashMap();
    private HashMap<EAttribute, AttributeItemProvider> attributeItemProviders = new HashMap();
    private ContainmentLinkItemProvider containmentLinkItemProvider = null;
    private EObject oldContainer = null;

    public MiaReflectiveItemProvider(AdapterFactory adapterFactory, EditorConfiguration editorConfiguration) {
        super(adapterFactory);
        this.editorConfiguration = editorConfiguration;
    }

    public Collection<?> getChildren(Object object) {
        Assert.isTrue((object == this.target ? 1 : 0) != 0);
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            ArrayList<TransientItemProvider> children = new ArrayList<TransientItemProvider>();
            if (this.editorConfiguration.isShowContainer()) {
                this.addContainer(eObject, children);
            }
            if (this.editorConfiguration.isShowAttributes()) {
                ArrayList<AttributeItemProvider> attributes = this.createAttributes(eObject);
                if (this.editorConfiguration.isSortLinks()) {
                    this.sortAttributes(attributes);
                }
                children.addAll(attributes);
            }
            ArrayList<LinkItemProvider> links = this.createLinks(eObject);
            if (this.editorConfiguration.isSortLinks()) {
                this.sortLinks(links);
            }
            if (this.editorConfiguration.isSortLinksByType()) {
                this.sortLinksByType(links);
            }
            children.addAll(links);
            return children;
        }
        return super.getChildren(object);
    }

    private ArrayList<AttributeItemProvider> createAttributes(EObject eObject) {
        ArrayList<AttributeItemProvider> attributes = new ArrayList<AttributeItemProvider>();
        EList allAttributes = eObject.eClass().getEAllAttributes();
        for (EAttribute attribute : allAttributes) {
            boolean empty = false;
            if (!this.editorConfiguration.isShowEmptyAttributes()) {
                Object value = ((EObject)this.target).eGet((EStructuralFeature)attribute);
                if (attribute.isMany()) {
                    empty = ((List)value).size() == 0;
                } else {
                    boolean bl = empty = value == null;
                }
            }
            if (!this.editorConfiguration.isShowEmptyAttributes() && empty) continue;
            AttributeItemProvider attributeItemProvider = this.attributeItemProviders.get(attribute);
            if (attributeItemProvider == null) {
                attributeItemProvider = new AttributeItemProvider(this.adapterFactory, eObject, attribute, this.editorConfiguration);
                this.attributeItemProviders.put(attribute, attributeItemProvider);
            }
            attributes.add(attributeItemProvider);
        }
        return attributes;
    }

    private ArrayList<LinkItemProvider> createLinks(EObject eObject) {
        EList allReferences = eObject.eClass().getEAllReferences();
        ArrayList<LinkItemProvider> links = new ArrayList<LinkItemProvider>();
        for (EReference reference : allReferences) {
            EList refList;
            if (reference.isDerived() && !this.editorConfiguration.isShowDerivedLinks()) continue;
            Object ref = eObject.eGet((EStructuralFeature)reference);
            if (!this.editorConfiguration.isShowEmptyLinks() && (ref == null || ref instanceof EList && (refList = (EList)ref).size() == 0)) continue;
            LinkItemProvider linkItemProvider = this.linkItemProviders.get(reference);
            if (linkItemProvider == null) {
                linkItemProvider = new LinkItemProvider(this.adapterFactory, eObject, reference, this.editorConfiguration);
                this.linkItemProviders.put(reference, linkItemProvider);
            }
            links.add(linkItemProvider);
        }
        return links;
    }

    private void addContainer(EObject eObject, ArrayList<TransientItemProvider> children) {
        if (eObject.eContainer() != null) {
            if (this.containmentLinkItemProvider == null || this.oldContainer != eObject.eContainer()) {
                this.containmentLinkItemProvider = new ContainmentLinkItemProvider(this.adapterFactory, eObject, eObject.eContainer(), this.editorConfiguration);
                this.oldContainer = eObject.eContainer();
            }
            ParentAdapter.associateParent(eObject.eContainer(), (Object)this.containmentLinkItemProvider, (AdapterFactory)this.editorConfiguration.getAdapterFactory());
            children.add(this.containmentLinkItemProvider);
        } else if (this.editorConfiguration.isShowEmptyLinks()) {
            this.containmentLinkItemProvider = new ContainmentLinkItemProvider(this.adapterFactory, eObject, null, this.editorConfiguration);
            this.oldContainer = null;
            children.add(this.containmentLinkItemProvider);
        }
    }

    private void sortLinks(List<LinkItemProvider> links) {
        Collections.sort(links, new Comparator<LinkItemProvider>(){

            @Override
            public int compare(LinkItemProvider o1, LinkItemProvider o2) {
                String name1 = o1.getReference().getName();
                String name2 = o2.getReference().getName();
                return name1.compareTo(name2);
            }
        });
    }

    private void sortLinksByType(List<LinkItemProvider> links) {
        Collections.sort(links, new Comparator<LinkItemProvider>(){

            @Override
            public int compare(LinkItemProvider o1, LinkItemProvider o2) {
                int r1 = this.rank(o1);
                int r2 = this.rank(o2);
                return r1 - r2;
            }

            private int rank(LinkItemProvider linkItemProvider) {
                EReference reference = linkItemProvider.getReference();
                EReference opposite = reference.getEOpposite();
                int rank = reference.isContainment() ? (opposite != null ? 0 : 10) : (opposite != null ? (opposite.isContainment() ? 20 : 30) : 40);
                if (reference.isDerived()) {
                    ++rank;
                }
                return rank;
            }
        });
    }

    private void sortAttributes(List<AttributeItemProvider> attributes) {
        Collections.sort(attributes, new Comparator<AttributeItemProvider>(){

            @Override
            public int compare(AttributeItemProvider o1, AttributeItemProvider o2) {
                String name1 = o1.getAttribute().getName();
                String name2 = o2.getAttribute().getName();
                return name1.compareTo(name2);
            }
        });
    }

    public String getText(Object object) {
        EObject eObject = (EObject)object;
        EClass eClass = eObject.eClass();
        String label = this.editorConfiguration.isShowFullQualifiedNames() ? EMFUtil.getMetaclassQualifiedName(eClass) : eClass.getName();
        return "[" + label + "] " + this.getName(eObject);
    }

    public String getName(EObject eObject) {
        String providedName = this.getProvidedName(eObject);
        if (providedName != null) {
            return providedName;
        }
        String nameFromRegistry = this.getNameFromRegistry(eObject);
        if (nameFromRegistry != null) {
            return nameFromRegistry;
        }
        return this.getDefaultName(eObject);
    }

    public String getNameFromRegistry(EObject eObject) {
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.editorConfiguration.getAdapterFactoryWithRegistry().adapt((Notifier)eObject, IItemLabelProvider.class);
        if (itemLabelProvider != null && itemLabelProvider != this) {
            return itemLabelProvider.getText((Object)eObject);
        }
        return null;
    }

    public String getProvidedName(EObject eObject) {
        NameProvidersRegistry nameProvidersRegistry = NameProvidersRegistry.getInstance();
        String name = nameProvidersRegistry.getName(eObject);
        if (name != null) {
            return Util.truncateBeforeNewline(name);
        }
        return null;
    }

    public String getDefaultName(EObject eObject) {
        Object value;
        EStructuralFeature feature = this.getLabelFeature(eObject.eClass());
        if (feature != null && (value = eObject.eGet(feature)) != null) {
            return Util.truncateBeforeNewline(value.toString());
        }
        return "";
    }

    public Object getParent(Object object) {
        Object adapter = ParentAdapterFactory.getInstance().adapt(object, ParentAdapter.class);
        if (adapter instanceof ParentAdapter) {
            ParentAdapter parentAdapter = (ParentAdapter)((Object)adapter);
            Object parent = parentAdapter.getParent();
            return parent;
        }
        MoDiscoEditorPlugin.INSTANCE.log("ParentAdapter not found");
        return null;
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
    }

    public Command createCommand(Object object, EditingDomain domain, Class<? extends Command> commandClass, CommandParameter commandParameter) {
        CommandParameter localCommandParameter = commandParameter;
        Collection oldCollection = localCommandParameter.getCollection();
        ArrayList<Object> newCollection = new ArrayList<Object>();
        if (oldCollection != null) {
            for (Object o : oldCollection) {
                if (o instanceof LinkItemProvider) {
                    LinkItemProvider linkItemProvider = (LinkItemProvider)((Object)o);
                    newCollection.add(linkItemProvider.getParent(null));
                    continue;
                }
                if (o instanceof AttributeItemProvider) {
                    AttributeItemProvider attributeItemProvider = (AttributeItemProvider)((Object)o);
                    newCollection.add(attributeItemProvider.getParent(null));
                    continue;
                }
                if (o instanceof ContainmentLinkItemProvider) {
                    ContainmentLinkItemProvider containmentLinkItemProvider = (ContainmentLinkItemProvider)((Object)o);
                    newCollection.add(containmentLinkItemProvider.getParent(null));
                    continue;
                }
                if (o instanceof BigListItemProvider) {
                    BigListItemProvider bigListItemProvider = (BigListItemProvider)((Object)o);
                    newCollection.add(bigListItemProvider.getModelParent());
                    continue;
                }
                if (!(o instanceof EObject)) continue;
                newCollection.add(o);
            }
            localCommandParameter = new CommandParameter(localCommandParameter.getOwner(), localCommandParameter.getFeature(), localCommandParameter.getValue(), newCollection, localCommandParameter.getIndex());
        }
        return super.createCommand(object, domain, commandClass, localCommandParameter);
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        return this.createWrappedCommand(super.createRemoveCommand(domain, owner, feature, collection), owner);
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        return this.createWrappedCommand(super.createAddCommand(domain, owner, feature, collection, index), owner);
    }

    protected Command createWrappedCommand(Command command, final EObject owner) {
        return new CommandWrapper(command){

            public Collection<?> getAffectedObjects() {
                Set<EObject> affected = super.getAffectedObjects();
                if (affected.contains(owner)) {
                    affected = Collections.singleton(owner.eContainer());
                }
                return affected;
            }
        };
    }

    public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        if (sibling instanceof LinkItemProvider) {
            return Collections.emptyList();
        }
        return super.getNewChildDescriptors(object, editingDomain, sibling);
    }

    public boolean hasChildren(Object object) {
        return true;
    }

    public Object getForeground(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (eObject.eResource() == null) {
                return this.NULL_RESOURCE_COLOR;
            }
            if (!EMFUtil.isInFirstResource(eObject)) {
                return this.EXTERNAL_COLOR;
            }
        }
        return super.getForeground(object);
    }

    public Object getImage(Object object) {
        IItemLabelProvider itemLabelProvider;
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            IconProvidersRegistry iconProvidersRegistry = IconProvidersRegistry.getInstance();
            Image icon = iconProvidersRegistry.getIcon(eObject);
            if (icon != null) {
                return icon;
            }
        }
        if ((itemLabelProvider = (IItemLabelProvider)this.editorConfiguration.getAdapterFactoryWithRegistry().adapt(object, IItemLabelProvider.class)) != null && itemLabelProvider != this) {
            Object image = itemLabelProvider.getImage(object);
            return ExtendedImageRegistry.getInstance().getImage(image);
        }
        return super.getImage(object);
    }
}

