/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.editors;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.gmt.modisco.common.editor.MoDiscoEditorPlugin;
import org.eclipse.gmt.modisco.common.editor.adapters.LinkItemProvider;
import org.eclipse.gmt.modisco.common.editor.editors.EcoreEditor;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;
import org.eclipse.gmt.modisco.common.editor.editors.table.TableEditor;
import org.eclipse.gmt.modisco.common.editor.util.EMFUtil;
import org.eclipse.gmt.modisco.common.editor.util.ImageProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    private static final String PROPERTY_SHEET_ID = "org.eclipse.ui.views.PropertySheet";
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(MoDiscoEditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                EcoreActionBarContributor.this.getPage().showView(EcoreActionBarContributor.PROPERTY_SHEET_ID);
            }
            catch (PartInitException exception) {
                MoDiscoEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction openTableEditorAction = new Action(MoDiscoEditorPlugin.INSTANCE.getString("_UI_OpenTableEditorOnSelection_menu_item")){

        public void run() {
            if (EcoreActionBarContributor.this.activeEditor instanceof EcoreEditor) {
                EcoreEditor editor = (EcoreEditor)EcoreActionBarContributor.this.activeEditor;
                EditorConfiguration editorConfiguration = editor.getEditorConfiguration();
                ISelection selection = EcoreActionBarContributor.this.lastSelectionChangedEvent.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    if (structuredSelection.size() == 1 && structuredSelection.getFirstElement() instanceof LinkItemProvider) {
                        LinkItemProvider linkItemProvider = (LinkItemProvider)((Object)structuredSelection.getFirstElement());
                        this.openOn(editorConfiguration, linkItemProvider);
                    } else {
                        this.openOn(editorConfiguration, structuredSelection);
                    }
                }
            }
        }

        private void openOn(EditorConfiguration editorConfiguration, LinkItemProvider linkItemProvider) {
            Collection<EObject> childrenElements = linkItemProvider.getChildrenElements();
            ArrayList<EObject> elementsList = new ArrayList<EObject>(childrenElements);
            String description = TableEditor.getEditorDescriptionFor((EObject)linkItemProvider.getParent(null), linkItemProvider.getReference(), editorConfiguration);
            TableEditor.openOn(editorConfiguration, elementsList, description);
        }

        private void openOn(EditorConfiguration editorConfiguration, IStructuredSelection structuredSelection) {
            ArrayList<EObject> elements = new ArrayList<EObject>();
            for (Object selectedElement : structuredSelection) {
                if (selectedElement instanceof EObject) {
                    EObject eObject = (EObject)selectedElement;
                    elements.add(eObject);
                    continue;
                }
                MoDiscoEditorPlugin.INSTANCE.log("Cannot open table editor: selected objects are not all model elements");
                return;
            }
            String metamodelName = editorConfiguration.getMetamodelName();
            String description = metamodelName != null ? String.valueOf(metamodelName) + " elements selection" : "elements selection (unknown metamodel)";
            TableEditor.openOn(editorConfiguration, elements, description);
        }
    };
    protected IAction refreshViewerAction = new Action(MoDiscoEditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return EcoreActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (EcoreActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)EcoreActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected Collection<IAction> createSiblingActions;
    protected SelectionChangedEvent lastSelectionChangedEvent;
    private Action browseAction = new Action("Browse"){

        public void run() {
            IEditorPart activeEditor = EcoreActionBarContributor.this.getActiveEditor();
            if (activeEditor instanceof EcoreEditor) {
                EcoreEditor editor = (EcoreEditor)activeEditor;
                editor.browse();
            }
        }
    };
    private Action increaseFontSizeAction = new Action("Increase Font Size", 1){

        public void run() {
            IEditorPart activeEditor = EcoreActionBarContributor.this.getActiveEditor();
            if (activeEditor instanceof EcoreEditor) {
                EcoreEditor editor = (EcoreEditor)activeEditor;
                editor.setFontSizeDelta(editor.getFontSizeDelta() + 1);
            }
        }
    };
    private Action decreaseFontSizeAction = new Action("Decrease Font Size", 1){

        public void run() {
            IEditorPart activeEditor = EcoreActionBarContributor.this.getActiveEditor();
            if (activeEditor instanceof EcoreEditor) {
                EcoreEditor editor = (EcoreEditor)activeEditor;
                editor.setFontSizeDelta(editor.getFontSizeDelta() - 1);
            }
        }
    };
    private Action restoreFontSizeAction = new Action("Restore Font Size", 1){

        public void run() {
            IEditorPart activeEditor = EcoreActionBarContributor.this.getActiveEditor();
            if (activeEditor instanceof EcoreEditor) {
                EcoreEditor editor = (EcoreEditor)activeEditor;
                editor.setFontSizeDelta(0);
            }
        }
    };

    public EcoreActionBarContributor() {
        super(1);
        this.validateAction = new ValidateAction();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("ecore-settings"));
        toolBarManager.add((IContributionItem)new Separator("ecore-additions"));
        this.increaseFontSizeAction.setImageDescriptor(ImageProvider.getInstance().getIncreaseFontSizeIcon());
        toolBarManager.add((IAction)this.increaseFontSizeAction);
        this.decreaseFontSizeAction.setImageDescriptor(ImageProvider.getInstance().getDecreaseFontSizeIcon());
        toolBarManager.add((IAction)this.decreaseFontSizeAction);
        this.restoreFontSizeAction.setImageDescriptor(ImageProvider.getInstance().getRestoreFontSizeIcon());
        toolBarManager.add((IAction)this.restoreFontSizeAction);
    }

    protected IMenuManager createSubmenuManager() {
        return new MenuManager(MoDiscoEditorPlugin.getPlugin().getString("_UI_EcoreEditor_menu"), "org.eclipse.emf.ecoreMenuID");
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
        this.updateActions(part);
    }

    private void updateActions(IEditorPart editorPart) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.lastSelectionChangedEvent = event;
    }

    private void updateActions(ISelection selection) {
        this.browseAction.setEnabled(this.enableBrowse(selection));
        this.openTableEditorAction.setEnabled(TableEditor.canBeOpenedOnSelection(selection));
    }

    private boolean enableBrowse(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() != 1) {
                return false;
            }
            Object element = structuredSelection.getFirstElement();
            if (element instanceof EObject) {
                return EMFUtil.isInFirstResource((EObject)element);
            }
        }
        return false;
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items;
            IContributionItem[] iContributionItemArray = items = manager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action;
                IContributionItem contributionItem = iContributionItemArray[n2];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++n2;
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        this.updateMenu();
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(MoDiscoEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(MoDiscoEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        menuManager.insertBefore("edit", (IAction)this.browseAction);
        menuManager.insertBefore("edit", this.openTableEditorAction);
    }

    private void updateMenu() {
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = this.lastSelectionChangedEvent.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        this.updateActions(selection);
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }
}

