/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.editors;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.gmt.modisco.common.editor.MoDiscoEditorPlugin;
import org.eclipse.gmt.modisco.common.editor.adapters.AttributeItemProvider;
import org.eclipse.gmt.modisco.common.editor.adapters.BigListItemProvider;
import org.eclipse.gmt.modisco.common.editor.adapters.LinkItemProvider;
import org.eclipse.gmt.modisco.common.editor.adapters.MetaclassInstancesItemProvider;
import org.eclipse.gmt.modisco.common.editor.adapters.MiaReflectiveItemProvider;
import org.eclipse.gmt.modisco.common.editor.adapters.MiaReflectiveItemProviderAdapterFactory;
import org.eclipse.gmt.modisco.common.editor.adapters.ParentAdapterFactory;
import org.eclipse.gmt.modisco.common.editor.adapters.SearchResultsItemProvider;
import org.eclipse.gmt.modisco.common.editor.core.InstancesForMetaclass;
import org.eclipse.gmt.modisco.common.editor.core.InstancesForMetaclasses;
import org.eclipse.gmt.modisco.common.editor.editors.CustomTreePainter;
import org.eclipse.gmt.modisco.common.editor.editors.EcoreEditorNavigationLocation;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;
import org.eclipse.gmt.modisco.common.editor.editors.LeftPane;
import org.eclipse.gmt.modisco.common.editor.editors.MetaclassViewer;
import org.eclipse.gmt.modisco.common.editor.editors.TreeToolBar;
import org.eclipse.gmt.modisco.common.editor.editors.WorkspaceChangeListener;
import org.eclipse.gmt.modisco.common.editor.util.EMFUtil;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreEditor
extends EditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker,
INavigationLocationProvider {
    public static final String EDITOR_ID = "org.eclipse.gmt.modisco.common.editor.editorID";
    private static final String PROPERTY_VIEW_ID = "org.eclipse.ui.views.PropertySheet";
    public static final String ECORE_FILE_EXTENSION = "ecore";
    public static final String EMOF_FILE_EXTENSION = "emof";
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected ComposedAdapterFactory adapterFactoryWithRegistry;
    protected PropertySheetPage propertySheetPage;
    protected TreeViewer treeViewer;
    private Tree tree;
    protected MetaclassViewer metaclassViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected WorkspaceChangeListener resourceChangeListener;
    private EditorConfiguration editorConfiguration = new EditorConfiguration(this);
    private Composite parentComposite;
    private Text searchBox;
    private Job searchJob = null;
    private Object savedInput;
    private Job refreshJob = null;
    private IPropertyChangeListener fontChangeListener;
    private boolean editingRegistryResource;
    private SashForm topSashForm;
    private CustomTreePainter orderedReferencePainter;

    public EcoreEditor() {
        this.editorConfiguration.load();
        this.resourceChangeListener = new WorkspaceChangeListener(this);
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory();
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)ParentAdapterFactory.getInstance());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new MiaReflectiveItemProviderAdapterFactory(this.editorConfiguration));
        this.editorConfiguration.setAdapterFactory(this.adapterFactory);
        ComposedAdapterFactory.Descriptor.Registry registry = ComposedAdapterFactory.Descriptor.Registry.INSTANCE;
        this.adapterFactoryWithRegistry = new ComposedAdapterFactory(registry);
        this.adapterFactoryWithRegistry.addAdapterFactory((AdapterFactory)this.adapterFactory);
        this.editorConfiguration.setAdapterFactoryWithRegistry(this.adapterFactoryWithRegistry);
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                EcoreEditor.this.parentComposite.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        EcoreEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            EcoreEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        if ((this).EcoreEditor.this.propertySheetPage != null && !(this).EcoreEditor.this.propertySheetPage.getControl().isDisposed()) {
                            (this).EcoreEditor.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public void setSelectionToViewer(Collection<?> selection) {
        if (selection != null && !selection.isEmpty() && this.treeViewer != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(selection.toArray()), true);
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public Viewer getViewer() {
        return this.treeViewer;
    }

    public MetaclassViewer getMetaclassViewer() {
        return this.metaclassViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
    }

    private void createDragAndDropSupport(TreeViewer viewer) {
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void createModel() {
        this.editingDomain.getResourceSet().getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        this.editingRegistryResource = false;
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        try {
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput instanceof FileEditorInput) {
                this.editingDomain.getResourceSet().getResource(resourceURI, true);
            } else {
                String resolveURI = resourceURI.toString();
                EPackage ePackage = this.editingDomain.getResourceSet().getPackageRegistry().getEPackage(resolveURI);
                Resource resource = ePackage.eResource();
                if (resource != null) {
                    this.editingDomain.getResourceSet().getResources().add((Object)resource);
                    this.editingRegistryResource = true;
                }
            }
        }
        catch (Exception e) {
            MoDiscoEditorPlugin.INSTANCE.log(e);
            MessageDialog.openError((Shell)this.parentComposite.getShell(), (String)"Error Loading Model", (String)e.toString());
            this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
    }

    public void createPartControl(Composite parent) {
        this.parentComposite = parent;
        parent.setLayout((Layout)new FillLayout());
        this.initializeEditingDomain();
        this.createModel();
        this.editorConfiguration.setResourceSet(this.editingDomain.getResourceSet());
        this.getSite().getPage().addPartListener((IPartListener)new SaveSettingsOnCloseListener());
        InstancesForMetaclasses instancesForMetaclasses = new InstancesForMetaclasses();
        this.editorConfiguration.setInstancesForMetaclasses(instancesForMetaclasses);
        instancesForMetaclasses.addMetaclasses(this.editorConfiguration.getAllClasses());
        instancesForMetaclasses.initModel(this.editingDomain.getResourceSet());
        instancesForMetaclasses.buildDerivationTree();
        this.topSashForm = new SashForm(parent, 256);
        this.createLeftPane((Composite)this.topSashForm);
        this.createTreePane((Composite)this.topSashForm);
        this.setupInitialTreeFont();
        this.topSashForm.setWeights(new int[]{30, 70});
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EcoreEditor.this.markNavigationLocation();
            }
        });
        this.metaclassViewer.selectRootElement();
        instancesForMetaclasses.addListener(new InstancesForMetaclasses.ModelChangeListener(){

            public void removedLastInstanceof(String metaclassQualifiedName) {
                String[] selectedMetaclasses = EcoreEditor.this.metaclassViewer.getSelectedMetaclassesQualifiedNames();
                if (selectedMetaclasses.length == 1 && metaclassQualifiedName.equals(selectedMetaclasses[0])) {
                    EcoreEditor.this.metaclassViewer.clearSelection();
                }
            }

            public void modelChanged() {
                EcoreEditor.this.modelChanged();
            }
        });
        this.createContextMenuFor((StructuredViewer)this.treeViewer);
        this.createDragAndDropSupport(this.treeViewer);
    }

    private void modelChanged() {
        if (this.refreshJob == null) {
            this.refreshJob = new Job("Refresh model viewers"){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            (this).EcoreEditor.this.metaclassViewer.refresh();
                            if (!(this).EcoreEditor.this.treeViewer.getControl().isDisposed()) {
                                (this).EcoreEditor.this.treeViewer.refresh();
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
        } else {
            this.refreshJob.cancel();
        }
        this.refreshJob.setPriority(50);
        this.refreshJob.schedule(100L);
    }

    protected void createLeftPane(Composite parent) {
        Composite listPaneComposite = new Composite(parent, 0);
        LeftPane leftPane = new LeftPane(listPaneComposite, this.editorConfiguration);
        this.metaclassViewer = leftPane.getMetaclassViewer();
        this.metaclassViewer.addSelectionChangedListener(new MetaclassListViewerSelectionChangedListener());
        this.fixClipboardCommands(leftPane.getMetaclassViewer().getViewer().getControl());
    }

    protected void createTreePane(Composite parent) {
        Composite treePane = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 2;
        treePane.setLayout((Layout)gridLayout);
        this.createTreeToolBar(treePane);
        this.tree = new Tree(treePane, 2050);
        GridData treeGridData = new GridData();
        treeGridData.grabExcessHorizontalSpace = true;
        treeGridData.grabExcessVerticalSpace = true;
        treeGridData.horizontalAlignment = 4;
        treeGridData.verticalAlignment = 4;
        this.tree.setLayoutData((Object)treeGridData);
        this.tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    EcoreEditor.this.searchBox.setText("");
                    EcoreEditor.this.search();
                } else if (e.keyCode == 13) {
                    EcoreEditor.this.handleEnter();
                }
            }
        });
        this.orderedReferencePainter = new CustomTreePainter(this.tree, this.editorConfiguration);
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setUseHashlookup(true);
        this.hookViewerToSelection((Viewer)this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider.FontAndColorProvider((AdapterFactory)this.adapterFactory, (Viewer)this.treeViewer));
        new AdapterFactoryTreeEditor(this.treeViewer.getTree(), (AdapterFactory)this.adapterFactory);
        this.registerShowPropertyViewOnDblClick(this.tree);
    }

    protected void handleEnter() {
        ISelection selection = this.getSelection();
        if (selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)selection;
            Object selectedElement = treeSelection.getFirstElement();
            if (selectedElement instanceof EObject) {
                this.browse();
            } else if (selectedElement instanceof AttributeItemProvider || selectedElement instanceof LinkItemProvider) {
                this.openPropertiesView();
            }
        }
    }

    private void setupInitialTreeFont() {
        this.setupPreferredFont();
        this.fontChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.jface.dialogfont")) {
                    EcoreEditor.this.setupPreferredFont();
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(this.fontChangeListener);
    }

    private void setupPreferredFont() {
        FontDescriptor descriptor = FontDescriptor.createFrom((Font)JFaceResources.getDialogFont());
        descriptor = descriptor.increaseHeight(this.editorConfiguration.getFontSizeDelta());
        Font customFont = descriptor.createFont((Device)Display.getDefault());
        descriptor = descriptor.setStyle(2);
        Font customItalicFont = descriptor.createFont((Device)Display.getDefault());
        this.editorConfiguration.setCustomFont(customFont);
        this.editorConfiguration.setCustomItalicFont(customItalicFont);
        this.tree.setFont(customFont);
        this.treeViewer.refresh();
        this.metaclassViewer.setFont(customFont);
        this.metaclassViewer.refresh();
    }

    private void createTreeToolBar(Composite parent) {
        Composite treeToolBarComposite = new Composite(parent, 2048);
        GridData treeToolBarGridData = new GridData();
        treeToolBarGridData.grabExcessHorizontalSpace = true;
        treeToolBarGridData.horizontalAlignment = 4;
        treeToolBarComposite.setLayoutData((Object)treeToolBarGridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 20;
        gridLayout.marginHeight = 2;
        treeToolBarComposite.setLayout((Layout)gridLayout);
        new TreeToolBar(treeToolBarComposite, this);
        this.createSearchPanel(treeToolBarComposite);
    }

    private void registerShowPropertyViewOnDblClick(Tree tree) {
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (event.button == 1) {
                    EcoreEditor.this.openPropertiesView();
                }
            }
        });
    }

    protected void createSearchPanel(Composite parent) {
        Composite searchPanel = new Composite(parent, 0);
        searchPanel.setLayout((Layout)new GridLayout(2, false));
        searchPanel.setLayout((Layout)new FillLayout());
        GridData searchPanelGridData = new GridData();
        searchPanelGridData.grabExcessHorizontalSpace = true;
        searchPanelGridData.horizontalAlignment = 4;
        searchPanel.setLayoutData((Object)searchPanelGridData);
        this.searchBox = new Text(searchPanel, 128);
        this.searchBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    EcoreEditor.this.search();
                } else if (e.keyCode == 27) {
                    EcoreEditor.this.searchBox.setText("");
                    EcoreEditor.this.search();
                }
            }
        });
        this.fixClipboardCommands((Control)this.searchBox);
        this.searchBox.setMessage("Search : Enter a string and press <Enter>");
    }

    private void fixClipboardCommands(Control control) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        final IContextService contextService = (IContextService)workbench.getService(IContextService.class);
        final IContextActivation[] contextActivationRef = new IContextActivation[1];
        control.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                IContextActivation contextActivation;
                contextActivationRef[0] = contextActivation = contextService.activateContext("org.eclipse.gmt.modisco.common.editor.dummyContext");
            }

            public void focusLost(FocusEvent event) {
                if (contextActivationRef[0] != null) {
                    contextService.deactivateContext(contextActivationRef[0]);
                }
            }
        });
    }

    protected void search() {
        final String searchText = this.searchBox.getText().toLowerCase();
        if (searchText.trim().length() == 0) {
            if (this.savedInput != null && this.savedInput != this.treeViewer.getInput()) {
                this.treeViewer.setInput(this.savedInput);
            }
            return;
        }
        final List<EClass> selectedMetaclasses = this.findSelectedEClasses();
        if (selectedMetaclasses.isEmpty()) {
            return;
        }
        this.searchJob = new Job("Search in Model Editor"){

            protected IStatus run(IProgressMonitor monitor) {
                ResourceSet resourceSet = EcoreEditor.this.editingDomain.getResourceSet();
                EList resources = resourceSet.getResources();
                if (resources.size() < 1) {
                    return Status.OK_STATUS;
                }
                final SearchResultsItemProvider searchResultsItemProvider = new SearchResultsItemProvider((AdapterFactory)EcoreEditor.this.adapterFactory, EcoreEditor.this.editorConfiguration);
                Resource resource = (Resource)resources.get(0);
                TreeIterator allContents = resource.getAllContents();
                while (allContents.hasNext()) {
                    MiaReflectiveItemProvider provider;
                    String objectText;
                    Adapter adapter;
                    EObject eObject = (EObject)allContents.next();
                    if (selectedMetaclasses.contains(eObject.eClass()) && (adapter = EcoreEditor.this.adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null && (objectText = (provider = (MiaReflectiveItemProvider)adapter).getName(eObject).toLowerCase()).contains(searchText)) {
                        searchResultsItemProvider.add(eObject);
                    }
                    if (!monitor.isCanceled()) continue;
                    return Status.CANCEL_STATUS;
                }
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        (this).EcoreEditor.this.treeViewer.setSelection(null);
                        (this).EcoreEditor.this.treeViewer.setInput((Object)searchResultsItemProvider);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.searchJob.setUser(true);
        this.searchJob.setPriority(30);
        this.searchJob.schedule();
    }

    private List<EClass> findSelectedEClasses() {
        ArrayList<EClass> selectedMetaclasses = new ArrayList<EClass>();
        ISelection selection = this.metaclassViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection) {
                if (!(element instanceof InstancesForMetaclass)) continue;
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)((Object)element);
                this.addMetaclassToSelection(instancesForMetaclass, selectedMetaclasses, this.editorConfiguration.isDisplayInstancesOfSubclasses());
            }
        }
        return selectedMetaclasses;
    }

    private void addMetaclassToSelection(InstancesForMetaclass instancesForMetaclass, ArrayList<EClass> selectedMetaclasses, boolean addSubclasses) {
        selectedMetaclasses.add(instancesForMetaclass.getEClass());
        if (addSubclasses) {
            InstancesForMetaclass[] subclasses;
            InstancesForMetaclass[] instancesForMetaclassArray = subclasses = instancesForMetaclass.getSubclasses();
            int n = subclasses.length;
            int n2 = 0;
            while (n2 < n) {
                InstancesForMetaclass subclass = instancesForMetaclassArray[n2];
                this.addMetaclassToSelection(subclass, selectedMetaclasses, addSubclasses);
                ++n2;
            }
        }
    }

    public void setShowEmptyLinks(boolean value) {
        this.editorConfiguration.setShowEmptyLinks(value);
        this.refreshTree();
    }

    public boolean isShowEmptyLinks() {
        return this.editorConfiguration.isShowEmptyLinks();
    }

    public void setSortInstances(boolean value) {
        this.editorConfiguration.setSortInstances(value);
        this.refreshTree();
    }

    public boolean isSortInstances() {
        return this.editorConfiguration.isSortInstances();
    }

    public void setShowDerivedLinks(boolean value) {
        this.editorConfiguration.setShowDerivedLinks(value);
        this.refreshTree();
    }

    public boolean isShowDerivedLinks() {
        return this.editorConfiguration.isShowDerivedLinks();
    }

    public void setShowFullQualifiedNames(boolean value) {
        this.editorConfiguration.setShowFullQualifiedNames(value);
        this.refreshTree();
        this.metaclassViewer.refresh();
    }

    public boolean isShowFullQualifiedNames() {
        return this.editorConfiguration.isShowFullQualifiedNames();
    }

    public void setShowMultiplicity(boolean value) {
        this.editorConfiguration.setShowMultiplicity(value);
        this.refreshTree();
    }

    public boolean isShowMultiplicity() {
        return this.editorConfiguration.isShowMultiplicity();
    }

    public void setShowOppositeLinks(boolean value) {
        this.editorConfiguration.setShowOppositeLinks(value);
        this.refreshTree();
    }

    public boolean isShowOppositeLinks() {
        return this.editorConfiguration.isShowOppositeLinks();
    }

    public void setShowContainer(boolean value) {
        this.editorConfiguration.setShowContainer(value);
        this.refreshTree();
    }

    public boolean isShowContainer() {
        return this.editorConfiguration.isShowContainer();
    }

    public void setSortLinks(boolean value) {
        this.editorConfiguration.setSortLinks(value);
        this.refreshTree();
    }

    public boolean isSortLinks() {
        return this.editorConfiguration.isSortLinks();
    }

    public void setSortLinksByType(boolean value) {
        this.editorConfiguration.setSortLinksByType(value);
        this.refreshTree();
    }

    public boolean isSortLinksByType() {
        return this.editorConfiguration.isSortLinksByType();
    }

    public void setShowAttributes(boolean value) {
        this.editorConfiguration.setShowAttributes(value);
        this.refreshTree();
    }

    public boolean isShowAttributes() {
        return this.editorConfiguration.isShowAttributes();
    }

    public void setShowEmptyAttributes(boolean value) {
        this.editorConfiguration.setShowEmptyAttributes(value);
        this.refreshTree();
    }

    public boolean isShowEmptyAttributes() {
        return this.editorConfiguration.isShowEmptyAttributes();
    }

    public void setFontSizeDelta(int value) {
        this.editorConfiguration.setFontSizeDelta(value);
        this.setupPreferredFont();
    }

    public int getFontSizeDelta() {
        return this.editorConfiguration.getFontSizeDelta();
    }

    public void setShowOrdering(boolean value) {
        this.editorConfiguration.setShowOrdering(value);
        this.refreshTree();
    }

    public boolean isShowOrdering() {
        return this.editorConfiguration.isShowOrdering();
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

                public void setSelectionToViewer(List<?> selection) {
                    EcoreEditor.this.setSelectionToViewer(selection);
                    EcoreEditor.this.setFocus();
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    EcoreEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    this.getControl().setRedraw(false);
                    try {
                        super.selectionChanged(part, selection);
                    }
                    finally {
                        this.getControl().setRedraw(true);
                    }
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
    }

    protected void handleChangedResources(Collection<Resource> changedResources) {
        if (this.isDirty()) {
            changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
        }
        this.editingDomain.getCommandStack().flush();
        for (Resource resource : changedResources) {
            if (!resource.isLoaded()) continue;
            resource.unload();
            try {
                resource.load(Collections.EMPTY_MAP);
            }
            catch (IOException exception) {
                MoDiscoEditorPlugin.INSTANCE.log(exception);
                MessageDialog.openError((Shell)this.parentComposite.getShell(), (String)"Error loading resource", (String)exception.toString());
            }
        }
        if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
            this.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : EcoreEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !EcoreEditor.this.isPersisted(resource) || EcoreEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() != timeStamp) {
                            EcoreEditor.this.resourceChangeListener.addSavedResource(resource);
                        }
                    }
                    catch (Exception exception) {
                        MessageDialog.openError((Shell)EcoreEditor.this.parentComposite.getShell(), (String)"Error saving resource", (String)exception.toString());
                        MoDiscoEditorPlugin.INSTANCE.log(exception);
                    }
                    first = false;
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
            this.treeViewer.refresh();
        }
        catch (Exception exception) {
            MoDiscoEditorPlugin.INSTANCE.log(exception);
        }
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.create();
        saveAsDialog.setMessage(MoDiscoEditorPlugin.INSTANCE.getString("_UI_SaveAs_message"));
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            Resource currentResource = (Resource)resourceSet.getResources().get(0);
            String currentExtension = currentResource.getURI().fileExtension();
            URI newURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            String newExtension = newURI.fileExtension();
            if (currentExtension.equals(ECORE_FILE_EXTENSION) && newExtension.equals(EMOF_FILE_EXTENSION) || currentExtension.equals(EMOF_FILE_EXTENSION) && newExtension.equals(ECORE_FILE_EXTENSION)) {
                Resource newResource = resourceSet.createResource(newURI);
                newResource.getContents().addAll((Collection)currentResource.getContents());
                resourceSet.getResources().remove(0);
                resourceSet.getResources().move(0, (Object)newResource);
            } else {
                currentResource.setURI(newURI);
            }
            FileEditorInput modelFile = new FileEditorInput(file);
            this.setInputWithNotify((IEditorInput)modelFile);
            this.setPartName(file.getName());
            this.doSave(this.getActionBars().getStatusLineManager().getProgressMonitor());
        }
    }

    public void gotoMarker(IMarker marker) {
        String uriAttribute = marker.getAttribute("uri", null);
        if (uriAttribute != null) {
            URI uri = URI.createURI((String)uriAttribute);
            EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
            if (eObject != null) {
                this.markNavigationLocation();
                String classQualifiedName = EMFUtil.getMetaclassQualifiedName(eObject.eClass());
                this.metaclassViewer.selectMetaclass(classQualifiedName);
                this.selectElement(eObject);
                this.markNavigationLocation();
            }
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        try {
            this.setSite((IWorkbenchPartSite)site);
            this.setInputWithNotify(editorInput);
            this.setPartName(editorInput.getName());
            site.setSelectionProvider((ISelectionProvider)this);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeListener, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            MoDiscoEditorPlugin.INSTANCE.log(e);
        }
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getTree().setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineMessage(selection);
    }

    private void hookViewerToSelection(Viewer viewer) {
        if (viewer == null) {
            return;
        }
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    EcoreEditor.this.setSelection(selectionChangedEvent.getSelection());
                }
            };
        }
        viewer.addSelectionChangedListener(this.selectionChangedListener);
        this.setSelection(viewer.getSelection());
    }

    public void setStatusLineMessage(ISelection selection) {
        IStatusLineManager statusLineManager = this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(EcoreEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(EcoreEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(EcoreEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return MoDiscoEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return MoDiscoEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
        this.adapterFactory.dispose();
        this.adapterFactoryWithRegistry.dispose();
        this.topSashForm.dispose();
        if (!this.editingRegistryResource) {
            final EList resources = this.editingDomain.getResourceSet().getResources();
            Job cleanupJob = new Job("Unload resources"){

                protected IStatus run(IProgressMonitor monitor) {
                    for (Resource resource : resources) {
                        resource.unload();
                    }
                    return Status.OK_STATUS;
                }
            };
            cleanupJob.setPriority(50);
            cleanupJob.setSystem(true);
            cleanupJob.schedule();
        }
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.treeViewer != null && this.selectionChangedListener != null) {
            this.treeViewer.removeSelectionChangedListener(this.selectionChangedListener);
            this.selectionChangedListener = null;
        }
        this.editorConfiguration.setCustomFont(null);
        this.editorConfiguration.setCustomItalicFont(null);
        this.editorConfiguration.clearEditor();
        JFaceResources.getFontRegistry().removeListener(this.fontChangeListener);
        this.orderedReferencePainter.dispose();
        super.dispose();
    }

    public void browse() {
        ITreeSelection treeSelection;
        Object selectedElement;
        ISelection selection = this.getSelection();
        if (selection instanceof ITreeSelection && (selectedElement = (treeSelection = (ITreeSelection)selection).getFirstElement()) instanceof EObject) {
            this.browseTo((EObject)selectedElement);
        }
    }

    public void browseTo(EObject element) {
        if (!EMFUtil.isInFirstResource(element)) {
            return;
        }
        this.markNavigationLocation();
        String classQualifiedName = EMFUtil.getMetaclassQualifiedName(element.eClass());
        this.metaclassViewer.selectMetaclass(classQualifiedName);
        this.selectElement(element);
        this.markNavigationLocation();
    }

    private void selectElement(Object selectedElement) {
        this.treeViewer.setSelection(null);
        Object input = this.treeViewer.getInput();
        if (input instanceof MetaclassInstancesItemProvider) {
            MetaclassInstancesItemProvider metaclassListItemProvider = (MetaclassInstancesItemProvider)((Object)input);
            Collection<?> elements = metaclassListItemProvider.getElements(null);
            for (Object element : elements) {
                if (element instanceof BigListItemProvider) {
                    BigListItemProvider bigListItemProvider = (BigListItemProvider)((Object)element);
                    Collection<?> subElements = bigListItemProvider.getChildren(null);
                    for (Object subElement : subElements) {
                        if (subElement != selectedElement) continue;
                        TreePath treePath = new TreePath(new Object[]{element, subElement});
                        this.treeViewer.setSelection((ISelection)new TreeSelection(treePath), true);
                        return;
                    }
                }
                if (element != selectedElement) continue;
                TreePath treePath = new TreePath(new Object[]{element});
                this.treeViewer.setSelection((ISelection)new TreeSelection(treePath), true);
                return;
            }
        }
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return new EcoreEditorNavigationLocation((IEditorPart)this);
    }

    public INavigationLocation createNavigationLocation() {
        String firstSelectedMetaclass = this.metaclassViewer.getFirstSelectedMetaclassQualifiedName();
        return new EcoreEditorNavigationLocation((IEditorPart)this, firstSelectedMetaclass, (ITreeSelection)this.treeViewer.getSelection());
    }

    protected void markNavigationLocation() {
        this.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)this);
    }

    public void restoreLocation(String metaclassQualifiedName, ITreeSelection selection) {
        this.metaclassViewer.selectMetaclass(metaclassQualifiedName);
        this.treeViewer.setSelection((ISelection)selection);
    }

    public void refreshTree() {
        if (!this.treeViewer.getTree().isDisposed()) {
            try {
                this.treeViewer.getTree().setRedraw(false);
                this.treeViewer.refresh();
            }
            finally {
                this.treeViewer.getTree().setRedraw(true);
            }
        }
    }

    public EditorConfiguration getEditorConfiguration() {
        return this.editorConfiguration;
    }

    private void openPropertiesView() {
        try {
            this.getEditorSite().getPage().showView(PROPERTY_VIEW_ID);
        }
        catch (PartInitException exception) {
            MoDiscoEditorPlugin.INSTANCE.log((Object)exception);
        }
    }

    private final class MetaclassListViewerSelectionChangedListener
    implements ISelectionChangedListener {
        private HashMap<String, ITreeSelection> selections = new HashMap();
        private String lastSelectedMetaclass = null;

        private MetaclassListViewerSelectionChangedListener() {
        }

        private InstancesForMetaclass[] getEntriesForSelection(ISelection selection) {
            ArrayList<InstancesForMetaclass> instancesForMetaclasses = new ArrayList<InstancesForMetaclass>();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                for (Object element : structuredSelection) {
                    if (!(element instanceof InstancesForMetaclass)) continue;
                    InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)((Object)element);
                    instancesForMetaclasses.add(instancesForMetaclass);
                }
            }
            return instancesForMetaclasses.toArray(new InstancesForMetaclass[instancesForMetaclasses.size()]);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (this.lastSelectedMetaclass != null) {
                this.selections.put(this.lastSelectedMetaclass, (ITreeSelection)EcoreEditor.this.treeViewer.getSelection());
            }
            ISelection metaclassSelection = event.getSelection();
            InstancesForMetaclass[] entries = this.getEntriesForSelection(metaclassSelection);
            ITreeSelection savedSelection = null;
            MetaclassInstancesItemProvider input = null;
            if (entries.length > 0) {
                savedSelection = this.selections.get(entries[0].getClassQualifiedName());
                String[] selectedMetaclassesNames = new String[entries.length];
                int i = 0;
                InstancesForMetaclass[] instancesForMetaclassArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    InstancesForMetaclass entry = instancesForMetaclassArray[n2];
                    selectedMetaclassesNames[i++] = entry.getClassQualifiedName();
                    ++n2;
                }
                if (EcoreEditor.this.savedInput instanceof MetaclassInstancesItemProvider) {
                    MetaclassInstancesItemProvider metaclassInstancesItemProvider = (MetaclassInstancesItemProvider)((Object)EcoreEditor.this.savedInput);
                    metaclassInstancesItemProvider.dispose();
                }
                input = new MetaclassInstancesItemProvider((AdapterFactory)EcoreEditor.this.adapterFactory, EcoreEditor.this.editorConfiguration, selectedMetaclassesNames);
                this.lastSelectedMetaclass = entries[0].getClassQualifiedName();
            } else {
                this.lastSelectedMetaclass = null;
            }
            try {
                EcoreEditor.this.treeViewer.getTree().setRedraw(false);
                EcoreEditor.this.searchBox.setText("");
                EcoreEditor.this.treeViewer.setSelection(null);
                EcoreEditor.this.treeViewer.setInput(input);
                EcoreEditor.this.savedInput = input;
                EcoreEditor.this.treeViewer.setSelection((ISelection)savedSelection, true);
            }
            finally {
                EcoreEditor.this.treeViewer.getTree().setRedraw(true);
            }
            EcoreEditor.this.markNavigationLocation();
        }
    }

    private class SaveSettingsOnCloseListener
    implements IPartListener {
        private SaveSettingsOnCloseListener() {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == EcoreEditor.this) {
                EcoreEditor.this.editorConfiguration.save();
                EcoreEditor.this.getSite().getPage().removePartListener((IPartListener)this);
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }
    }
}

