/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.gmt.modisco.common.editor.MoDiscoEditorPlugin;
import org.eclipse.gmt.modisco.common.editor.core.InstancesForMetaclasses;
import org.eclipse.gmt.modisco.common.editor.editors.EcoreEditor;
import org.eclipse.gmt.modisco.common.editor.util.EMFUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorConfiguration {
    public static final String FONT_SIZE_DELTA_PROP = "fontSizeDelta";
    private static final String SHOW_EMPTY_LINKS_SETTING = "showEmptyLinks";
    private static final String SHOW_DERIVED_LINKS_SETTING = "showDerivedLinks";
    private static final String SORT_INSTANCES_SETTING = "showInstances";
    private static final String SORT_LINKS_SETTING = "sortLinks";
    private static final String SORT_LINKS_BY_TYPE_SETTING = "sortLinksByType";
    private static final String SHOW_FULL_QUALIFIED_NAMES_SETTING = "showFullQualifiedNames";
    private static final String SHOW_MULTIPLICITY_SETTING = "showMultiplicity";
    private static final String SHOW_OPPOSITE_LINKS_SETTING = "showOppositeLinks";
    private static final String SHOW_CONTAINER_SETTING = "showContainer";
    private static final String METACLASSES_SORT_MODE = "metaclassesSortMode";
    private static final String SHOW_METACLASSES_FULL_QUALIFIED_NAMES_SETTING = "showMetaclassesFullQualifiedNames";
    private static final String SHOW_EMPTY_METACLASSES = "showEmptyMetaclasses";
    private static final String GROUP_BY_PACKAGE = "groupByPackage";
    private static final String DISPLAY_INSTANCES_OF_SUBCLASSES = "displayInstancesOfSubclasses";
    private static final String SHOW_DERIVATION_TREE = "showDerivationTree";
    private static final String SHOW_ATTRIBUTES = "showAttributes";
    private static final String SHOW_EMPTY_ATTRIBUTES = "showEmptyAttributes";
    private static final String SHOW_ORDERING = "showOrdering";
    private static final String FONT_SIZE_DELTA = "fontSizeDelta";
    private boolean showEmptyLinks = false;
    private boolean sortInstances = false;
    private boolean sortLinks = false;
    private boolean sortLinksByType = false;
    private boolean showDerivedLinks = false;
    private boolean showFullQualifiedNames = false;
    private boolean showMetaclassesFullQualifiedNames = false;
    private boolean showMultiplicity = false;
    private boolean showOppositeLinks = false;
    private boolean showContainer = false;
    private boolean showEmptyMetaclasses = false;
    private boolean groupByPackage = false;
    private boolean displayInstancesOfSubclasses;
    private boolean showDerivationTree;
    private MetaclassesSortMode metaclassesSortMode = MetaclassesSortMode.ByName;
    private boolean showAttributes;
    private boolean showEmptyAttributes;
    private boolean showOrdering;
    private int fontSizeDelta = 0;
    private Font customFont = null;
    private Font customItalicFont = null;
    private Collection<EClass> allClasses;
    private ResourceSet resourceSet;
    private ComposedAdapterFactory adapterFactory;
    private InstancesForMetaclasses instancesForMetaclasses;
    private ComposedAdapterFactory adapterFactoryWithRegistry;
    private EcoreEditor editor;
    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    public EditorConfiguration(EcoreEditor editor) {
        this.editor = editor;
    }

    public EcoreEditor getEditor() {
        return this.editor;
    }

    public boolean isShowEmptyLinks() {
        return this.showEmptyLinks;
    }

    public void setShowEmptyLinks(boolean showEmptyLinks) {
        this.showEmptyLinks = showEmptyLinks;
    }

    public boolean isSortInstances() {
        return this.sortInstances;
    }

    public void setSortInstances(boolean sortInstances) {
        this.sortInstances = sortInstances;
    }

    public boolean isShowDerivedLinks() {
        return this.showDerivedLinks;
    }

    public void setShowDerivedLinks(boolean showDerivedLinks) {
        this.showDerivedLinks = showDerivedLinks;
    }

    public boolean isShowFullQualifiedNames() {
        return this.showFullQualifiedNames;
    }

    public void setShowFullQualifiedNames(boolean showFullQualifiedNames) {
        this.showFullQualifiedNames = showFullQualifiedNames;
    }

    public boolean isShowMultiplicity() {
        return this.showMultiplicity;
    }

    public void setShowMultiplicity(boolean showMultiplicity) {
        this.showMultiplicity = showMultiplicity;
    }

    public boolean isShowOppositeLinks() {
        return this.showOppositeLinks;
    }

    public void setShowOppositeLinks(boolean showOppositeLinks) {
        this.showOppositeLinks = showOppositeLinks;
    }

    public boolean isShowContainer() {
        return this.showContainer;
    }

    public void setShowContainer(boolean showContainer) {
        this.showContainer = showContainer;
    }

    public MetaclassesSortMode getMetaclassesSortMode() {
        return this.metaclassesSortMode;
    }

    public void setMetaclassesSortMode(MetaclassesSortMode mode) {
        this.metaclassesSortMode = mode;
    }

    public boolean isShowMetaclassesFullQualifiedNames() {
        return this.showMetaclassesFullQualifiedNames;
    }

    public void setShowMetaclassesFullQualifiedNames(boolean value) {
        this.showMetaclassesFullQualifiedNames = value;
    }

    public void setSortLinks(boolean value) {
        this.sortLinks = value;
    }

    public boolean isSortLinks() {
        return this.sortLinks;
    }

    public void setSortLinksByType(boolean value) {
        this.sortLinksByType = value;
    }

    public boolean isSortLinksByType() {
        return this.sortLinksByType;
    }

    public void setShowEmptyMetaclasses(boolean value) {
        this.showEmptyMetaclasses = value;
    }

    public boolean isShowEmptyMetaclasses() {
        return this.showEmptyMetaclasses;
    }

    public void setGroupByPackage(boolean value) {
        this.groupByPackage = value;
    }

    public boolean isGroupByPackage() {
        return this.groupByPackage;
    }

    public void setDisplayInstancesOfSubclasses(boolean value) {
        this.displayInstancesOfSubclasses = value;
    }

    public boolean isDisplayInstancesOfSubclasses() {
        return this.displayInstancesOfSubclasses;
    }

    public void setShowDerivationTree(boolean value) {
        this.showDerivationTree = value;
    }

    public boolean isShowDerivationTree() {
        return this.showDerivationTree;
    }

    public void setShowAttributes(boolean value) {
        this.showAttributes = value;
    }

    public boolean isShowAttributes() {
        return this.showAttributes;
    }

    public void setShowEmptyAttributes(boolean value) {
        this.showEmptyAttributes = value;
    }

    public boolean isShowEmptyAttributes() {
        return this.showEmptyAttributes;
    }

    public void setShowOrdering(boolean value) {
        this.showOrdering = value;
    }

    public boolean isShowOrdering() {
        return this.showOrdering;
    }

    public void setFontSizeDelta(int value) {
        this.firePropertyChanged("fontSizeDelta", this.fontSizeDelta, value);
        this.fontSizeDelta = value;
    }

    public int getFontSizeDelta() {
        return this.fontSizeDelta;
    }

    public void setCustomFont(Font customFont) {
        if (this.customFont != null && this.customFont != JFaceResources.getDialogFont() && this.customFont != customFont) {
            this.customFont.dispose();
        }
        this.customFont = customFont;
    }

    public Font getCustomFont() {
        return this.customFont;
    }

    public void setCustomItalicFont(Font customItalicFont) {
        if (this.customItalicFont != null && this.customItalicFont != JFaceResources.getDialogFont() && this.customItalicFont != customItalicFont) {
            this.customItalicFont.dispose();
        }
        this.customItalicFont = customItalicFont;
    }

    public Font getCustomItalicFont() {
        return this.customItalicFont;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
        this.allClasses = EMFUtil.findAllClasses(resourceSet);
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public Collection<EClass> getAllClasses() {
        return this.allClasses;
    }

    public void setAdapterFactory(ComposedAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public void setInstancesForMetaclasses(InstancesForMetaclasses instancesForMetaclasses) {
        this.instancesForMetaclasses = instancesForMetaclasses;
    }

    public InstancesForMetaclasses getInstancesForMetaclasses() {
        return this.instancesForMetaclasses;
    }

    public ComposedAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setAdapterFactoryWithRegistry(ComposedAdapterFactory adapterFactoryWithRegistry) {
        this.adapterFactoryWithRegistry = adapterFactoryWithRegistry;
    }

    public ComposedAdapterFactory getAdapterFactoryWithRegistry() {
        return this.adapterFactoryWithRegistry;
    }

    public void load() {
        IDialogSettings dialogSettings = MoDiscoEditorPlugin.getPlugin().getDialogSettings();
        this.showEmptyLinks = this.getPreference(SHOW_EMPTY_LINKS_SETTING, true, dialogSettings);
        this.showDerivedLinks = this.getPreference(SHOW_DERIVED_LINKS_SETTING, true, dialogSettings);
        this.sortInstances = this.getPreference(SORT_INSTANCES_SETTING, false, dialogSettings);
        this.sortLinks = this.getPreference(SORT_LINKS_SETTING, false, dialogSettings);
        this.sortLinksByType = this.getPreference(SORT_LINKS_BY_TYPE_SETTING, false, dialogSettings);
        this.showFullQualifiedNames = this.getPreference(SHOW_FULL_QUALIFIED_NAMES_SETTING, false, dialogSettings);
        this.showMultiplicity = this.getPreference(SHOW_MULTIPLICITY_SETTING, false, dialogSettings);
        this.showOppositeLinks = this.getPreference(SHOW_OPPOSITE_LINKS_SETTING, false, dialogSettings);
        this.showContainer = this.getPreference(SHOW_CONTAINER_SETTING, true, dialogSettings);
        this.showMetaclassesFullQualifiedNames = this.getPreference(SHOW_METACLASSES_FULL_QUALIFIED_NAMES_SETTING, false, dialogSettings);
        this.showEmptyMetaclasses = this.getPreference(SHOW_EMPTY_METACLASSES, false, dialogSettings);
        this.groupByPackage = this.getPreference(GROUP_BY_PACKAGE, false, dialogSettings);
        this.displayInstancesOfSubclasses = this.getPreference(DISPLAY_INSTANCES_OF_SUBCLASSES, false, dialogSettings);
        this.showDerivationTree = this.getPreference(SHOW_DERIVATION_TREE, false, dialogSettings);
        this.showAttributes = this.getPreference(SHOW_ATTRIBUTES, true, dialogSettings);
        this.showEmptyAttributes = this.getPreference(SHOW_EMPTY_ATTRIBUTES, true, dialogSettings);
        this.showOrdering = this.getPreference(SHOW_ORDERING, false, dialogSettings);
        this.fontSizeDelta = this.getPreference("fontSizeDelta", 0, dialogSettings);
        String metaclassesSortMode = dialogSettings.get(METACLASSES_SORT_MODE);
        if (metaclassesSortMode != null) {
            this.metaclassesSortMode = MetaclassesSortMode.valueOf(metaclassesSortMode);
        }
    }

    private boolean getPreference(String settingKey, boolean defaultValue, IDialogSettings dialogSettings) {
        String value = dialogSettings.get(settingKey);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    private int getPreference(String settingKey, int defaultValue, IDialogSettings dialogSettings) {
        String value = dialogSettings.get(settingKey);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public void save() {
        IDialogSettings dialogSettings = MoDiscoEditorPlugin.getPlugin().getDialogSettings();
        dialogSettings.put(SHOW_EMPTY_LINKS_SETTING, this.showEmptyLinks);
        dialogSettings.put(SHOW_DERIVED_LINKS_SETTING, this.showDerivedLinks);
        dialogSettings.put(SORT_INSTANCES_SETTING, this.sortInstances);
        dialogSettings.put(SORT_LINKS_SETTING, this.sortLinks);
        dialogSettings.put(SORT_LINKS_BY_TYPE_SETTING, this.sortLinksByType);
        dialogSettings.put(SHOW_FULL_QUALIFIED_NAMES_SETTING, this.showFullQualifiedNames);
        dialogSettings.put(SHOW_MULTIPLICITY_SETTING, this.showMultiplicity);
        dialogSettings.put(SHOW_OPPOSITE_LINKS_SETTING, this.showOppositeLinks);
        dialogSettings.put(SHOW_CONTAINER_SETTING, this.showContainer);
        dialogSettings.put(METACLASSES_SORT_MODE, this.metaclassesSortMode.name());
        dialogSettings.put(SHOW_METACLASSES_FULL_QUALIFIED_NAMES_SETTING, this.showMetaclassesFullQualifiedNames);
        dialogSettings.put(SHOW_EMPTY_METACLASSES, this.showEmptyMetaclasses);
        dialogSettings.put(GROUP_BY_PACKAGE, this.groupByPackage);
        dialogSettings.put(DISPLAY_INSTANCES_OF_SUBCLASSES, this.displayInstancesOfSubclasses);
        dialogSettings.put(SHOW_DERIVATION_TREE, this.showDerivationTree);
        dialogSettings.put(SHOW_ATTRIBUTES, this.showAttributes);
        dialogSettings.put(SHOW_EMPTY_ATTRIBUTES, this.showEmptyAttributes);
        dialogSettings.put(SHOW_ORDERING, this.showOrdering);
        dialogSettings.put("fontSizeDelta", this.fontSizeDelta);
    }

    public void clearEditor() {
        this.editor = null;
    }

    public String getMetamodelName() {
        String[] parts;
        String nsURI = this.getMetamodelURI();
        if (nsURI != null && (parts = nsURI.split("/")).length > 0) {
            return parts[parts.length - 1];
        }
        return null;
    }

    public String getMetamodelURI() {
        EPackage ePackage;
        EObject firstElement;
        EClass eClass;
        Resource firstResource;
        EList contents;
        EList resources = this.resourceSet.getResources();
        if (resources.size() > 0 && (contents = (firstResource = (Resource)resources.get(0)).getContents()).size() > 0 && (eClass = (firstElement = (EObject)contents.get(0)).eClass()) != null && (ePackage = eClass.getEPackage()) != null) {
            return ePackage.getNsURI();
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void firePropertyChanged(String propertyName, int oldValue, int newValue) {
        for (PropertyChangeListener listener : this.listeners) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            listener.propertyChange(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetaclassesSortMode {
        ByName,
        ByCount;

    }
}

