/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.editors;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmt.modisco.common.editor.adapters.MetaclassListItemProvider;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;
import org.eclipse.gmt.modisco.common.editor.util.EMFUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class MetaclassListViewer
extends ListViewer
implements MetaclassListItemProvider.ChangeListener {
    private TreeMap<String, MetaclassListItemProvider> modelElements;
    private final ResourceSet resourceSet;
    private final AdapterFactory adapterFactory;
    private final EditorConfiguration editorConfiguration;
    private ModelChangeListener listener = null;
    private Job refreshJob = null;

    public MetaclassListViewer(Composite parent, int style, ResourceSet resourceSet, AdapterFactory adapterFactory, EditorConfiguration editorConfiguration) {
        super(parent, style);
        this.resourceSet = resourceSet;
        this.adapterFactory = adapterFactory;
        this.editorConfiguration = editorConfiguration;
        this.initViewer();
        this.initModel();
    }

    private void initModel() {
        this.modelElements = new TreeMap();
        EList resources = this.resourceSet.getResources();
        if (resources.size() == 0) {
            return;
        }
        Resource resource = (Resource)resources.get(0);
        TreeIterator allContents = resource.getAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            this.addModelElement(eObject, false);
        }
        this.setInput(this.modelElements);
    }

    public void selectRootElement() {
        EList contents;
        this.setSelection(null);
        EList resources = this.resourceSet.getResources();
        if (resources.size() > 0 && (contents = ((Resource)resources.get(0)).getContents()).size() > 0) {
            EObject object = (EObject)contents.get(0);
            String classFullQualifiedName = EMFUtil.getMetaclassQualifiedName(object.eClass());
            Set<Map.Entry<String, MetaclassListItemProvider>> entrySet = this.modelElements.entrySet();
            for (Map.Entry<String, MetaclassListItemProvider> entry : entrySet) {
                if (!entry.getKey().equals(classFullQualifiedName)) continue;
                this.setSelection((ISelection)new StructuredSelection(entry), true);
                break;
            }
        }
    }

    public void selectMetaclassName(String classFullQualifiedName) {
        Set<Map.Entry<String, MetaclassListItemProvider>> entrySet = this.modelElements.entrySet();
        for (Map.Entry<String, MetaclassListItemProvider> entry : entrySet) {
            if (!entry.getKey().equals(classFullQualifiedName)) continue;
            this.setSelection((ISelection)new StructuredSelection(entry), true);
            break;
        }
    }

    public String getSelectedMetaclassQualifiedName() {
        IStructuredSelection structuredSelection;
        Object selectedElement;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && (selectedElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)selectedElement;
            return (String)entry.getKey();
        }
        return "";
    }

    private void initViewer() {
        this.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                TreeMap modelElements = (TreeMap)inputElement;
                return modelElements.entrySet().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                int lastDot;
                Map.Entry entry = (Map.Entry)element;
                String name = (String)entry.getKey();
                if (!MetaclassListViewer.this.editorConfiguration.isShowFullQualifiedNames() && (lastDot = name.lastIndexOf(46)) != -1) {
                    name = name.substring(lastDot + 1);
                }
                return String.valueOf(name) + " (" + ((MetaclassListItemProvider)((Object)entry.getValue())).size() + ")";
            }
        });
    }

    public void setListener(ModelChangeListener listener) {
        this.listener = listener;
    }

    public void notifyChanged(Notification msg) {
        int eventType = msg.getEventType();
        switch (eventType) {
            case 3: {
                EReference feature;
                Object featureObj = msg.getFeature();
                if (featureObj instanceof EReference && !(feature = (EReference)featureObj).isContainment()) {
                    return;
                }
                Object newValue = msg.getNewValue();
                if (newValue instanceof EObject) {
                    this.addModelElement((EObject)newValue, true);
                }
                this.modelChanged();
                break;
            }
            case 4: {
                EReference feature;
                Object featureObj = msg.getFeature();
                if (featureObj instanceof EReference && !(feature = (EReference)featureObj).isContainment()) {
                    return;
                }
                Object oldValue = msg.getOldValue();
                if (oldValue instanceof EObject) {
                    this.removeModelElement((EObject)oldValue);
                }
                this.modelChanged();
                break;
            }
            case 5: {
                Object newValue = msg.getNewValue();
                if (newValue instanceof EList) {
                    EList eList = (EList)newValue;
                    for (Object object : eList) {
                        if (!(object instanceof EObject)) continue;
                        this.addModelElement((EObject)object, true);
                    }
                }
                this.modelChanged();
                break;
            }
            case 6: {
                Object newValue = msg.getNewValue();
                if (newValue instanceof EList) {
                    EList eList = (EList)newValue;
                    for (Object object : eList) {
                        if (!(object instanceof EObject)) continue;
                        this.removeModelElement((EObject)object);
                    }
                }
                this.modelChanged();
                break;
            }
            case 1: {
                EReference reference;
                Object newValue = msg.getNewValue();
                Object feature = msg.getFeature();
                if (!(feature instanceof EReference) || !(reference = (EReference)feature).isContainment()) break;
                if (newValue == null) {
                    Object oldValue = msg.getOldValue();
                    if (!(oldValue instanceof EObject)) break;
                    this.removeModelElement((EObject)oldValue);
                    this.modelChanged();
                    break;
                }
                if (!(newValue instanceof EObject)) break;
                this.addModelElement((EObject)newValue, true);
                this.modelChanged();
                break;
            }
            case 2: {
                EReference reference;
                Object oldValue = msg.getOldValue();
                Object feature = msg.getFeature();
                if (feature instanceof EReference && !(reference = (EReference)feature).isContainment()) break;
                if (oldValue instanceof EObject) {
                    this.removeModelElement((EObject)oldValue);
                }
                this.modelChanged();
            }
        }
    }

    private void modelChanged() {
        if (this.refreshJob == null) {
            this.refreshJob = new Job("Refresh model viewers"){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            MetaclassListViewer.this.refresh();
                            MetaclassListViewer.this.fireModelChanged();
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
        }
        this.refreshJob.cancel();
        this.refreshJob.schedule(100L);
    }

    private void addModelElement(EObject element, boolean recursively) {
        String classQualifiedName = EMFUtil.getMetaclassQualifiedName(element.eClass());
        MetaclassListItemProvider listItemProvider = this.modelElements.get(classQualifiedName);
        if (listItemProvider == null) {
            listItemProvider = new MetaclassListItemProvider(this.adapterFactory, this.editorConfiguration, element.eClass());
            listItemProvider.setListener(this);
            this.modelElements.put(classQualifiedName, listItemProvider);
        }
        listItemProvider.add(element);
        if (recursively) {
            EList contents = element.eContents();
            for (EObject contained : contents) {
                this.addModelElement(contained, true);
            }
        }
    }

    private void removeModelElement(EObject element) {
        String classQualifiedName = EMFUtil.getMetaclassQualifiedName(element.eClass());
        MetaclassListItemProvider list = this.modelElements.get(classQualifiedName);
        if (list != null) {
            list.remove(element);
            if (list.isEmpty()) {
                if (this.getSelectedMetaclassQualifiedName().equals(classQualifiedName)) {
                    this.setSelection(null);
                }
                this.modelElements.remove(classQualifiedName);
            }
        }
        EList contents = element.eContents();
        for (EObject contained : contents) {
            this.removeModelElement(contained);
        }
    }

    private void fireModelChanged() {
        if (this.listener != null) {
            this.listener.modelChanged();
        }
    }

    public static interface ModelChangeListener {
        public void modelChanged();
    }
}

