/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.editors;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmt.modisco.common.editor.core.InstancesForMetaclass;
import org.eclipse.gmt.modisco.common.editor.core.InstancesForMetaclasses;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;
import org.eclipse.gmt.modisco.common.editor.editors.MetaclassViewerMenuManager;
import org.eclipse.gmt.modisco.common.editor.util.EMFUtil;
import org.eclipse.gmt.modisco.common.editor.util.ImageProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaclassViewer {
    private TreeViewer treeViewer;
    private final ResourceSet resourceSet;
    private final EditorConfiguration editorConfiguration;

    public MetaclassViewer(Composite parent, EditorConfiguration editorConfiguration) {
        this.resourceSet = editorConfiguration.getResourceSet();
        this.editorConfiguration = editorConfiguration;
        this.treeViewer = new TreeViewer(parent, 2818);
        this.initViewer();
        InstancesForMetaclasses instancesForMetaclasses = this.editorConfiguration.getInstancesForMetaclasses();
        this.treeViewer.setInput((Object)instancesForMetaclasses);
        this.createContextMenu((Control)this.treeViewer.getTree());
    }

    private void createContextMenu(Control control) {
        MetaclassViewerMenuManager menuManager = new MetaclassViewerMenuManager(this, this.editorConfiguration);
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    public void selectRootElement() {
        EList contents;
        this.treeViewer.setSelection(null);
        EList resources = this.resourceSet.getResources();
        if (resources.size() > 0 && (contents = ((Resource)resources.get(0)).getContents()).size() > 0) {
            EObject object = (EObject)contents.get(0);
            String classFullQualifiedName = EMFUtil.getMetaclassQualifiedName(object.eClass());
            this.selectMetaclass(classFullQualifiedName);
        }
    }

    public void selectMetaclass(String classFullQualifiedName) {
        InstancesForMetaclasses instancesForMetaclasses = (InstancesForMetaclasses)this.treeViewer.getInput();
        InstancesForMetaclass instancesForMetaclass = instancesForMetaclasses.getInstancesForMetaclass(classFullQualifiedName);
        if (instancesForMetaclass != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)instancesForMetaclass), true);
        }
    }

    public String[] getSelectedMetaclassesQualifiedNames() {
        ArrayList<String> selectedMetaclasses = new ArrayList<String>();
        ISelection selection = this.treeViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof InstancesForMetaclass)) continue;
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)((Object)selectedElement);
                selectedMetaclasses.add(instancesForMetaclass.getClassQualifiedName());
            }
        }
        return selectedMetaclasses.toArray(new String[selectedMetaclasses.size()]);
    }

    public EClass[] getSelectedMetaclasses() {
        ArrayList<EClass> selectedMetaclasses = new ArrayList<EClass>();
        ISelection selection = this.treeViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof InstancesForMetaclass)) continue;
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)((Object)selectedElement);
                selectedMetaclasses.add(instancesForMetaclass.getEClass());
            }
        }
        return selectedMetaclasses.toArray(new EClass[selectedMetaclasses.size()]);
    }

    public String getFirstSelectedMetaclassQualifiedName() {
        String[] selectedMetaclassesQualifiedNames = this.getSelectedMetaclassesQualifiedNames();
        String firstSelectedMetaclass = null;
        if (selectedMetaclassesQualifiedNames.length > 0) {
            firstSelectedMetaclass = selectedMetaclassesQualifiedNames[0];
        }
        return firstSelectedMetaclass;
    }

    private void initViewer() {
        this.treeViewer.setContentProvider((IContentProvider)new MetaclassContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new MetaclassLabelProvider());
        this.treeViewer.addFilter((ViewerFilter)new EmptyMetaclassesFilter());
        this.setSortMode(this.editorConfiguration.getMetaclassesSortMode());
    }

    public Object[] groupByPackage(InstancesForMetaclass[] instancesByMetaclass) {
        ArrayList<Object> toplevelItems = new ArrayList<Object>();
        InstancesForMetaclass[] instancesForMetaclassArray = instancesByMetaclass;
        int n = instancesByMetaclass.length;
        int n2 = 0;
        while (n2 < n) {
            InstancesForMetaclass instancesForMetaclass = instancesForMetaclassArray[n2];
            EClass eClass = instancesForMetaclass.getEClass();
            ArrayList<String> pathSegments = new ArrayList<String>();
            pathSegments.add(eClass.getName());
            EPackage ePackage = eClass.getEPackage();
            while (ePackage != null) {
                pathSegments.add(ePackage.getName());
                ePackage = ePackage.getESuperPackage();
            }
            String[] path = new String[pathSegments.size()];
            int i = pathSegments.size() - 1;
            for (String segment : pathSegments) {
                path[i--] = segment;
            }
            this.addToPackage(instancesForMetaclass, path, 0, toplevelItems, null);
            ++n2;
        }
        return toplevelItems.toArray(new Object[toplevelItems.size()]);
    }

    private void addToPackage(InstancesForMetaclass instancesForMetaclass, String[] path, int index, ArrayList<Object> items, Object parent) {
        if (path.length - index == 1) {
            instancesForMetaclass.setParent(parent);
            items.add((Object)instancesForMetaclass);
        } else if (path.length - index > 1) {
            for (Object item : items) {
                PackageGroup packageGroup;
                if (!(item instanceof PackageGroup) || !(packageGroup = (PackageGroup)item).getName().equals(path[index])) continue;
                this.addToPackage(instancesForMetaclass, path, index + 1, packageGroup, packageGroup);
                return;
            }
            PackageGroup packageGroup = new PackageGroup(parent, path[index]);
            items.add(packageGroup);
            this.addToPackage(instancesForMetaclass, path, index + 1, packageGroup, packageGroup);
        }
    }

    public void refresh() {
        if (!this.treeViewer.getTree().isDisposed()) {
            try {
                this.treeViewer.getTree().setRedraw(false);
                this.treeViewer.refresh();
            }
            finally {
                this.treeViewer.getTree().setRedraw(true);
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener selectionChangedListener) {
        this.treeViewer.addSelectionChangedListener(selectionChangedListener);
    }

    public void clearSelection() {
        this.treeViewer.setSelection(null);
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public void setSortMode(EditorConfiguration.MetaclassesSortMode mode) {
        this.editorConfiguration.setMetaclassesSortMode(mode);
        if (mode == EditorConfiguration.MetaclassesSortMode.ByName) {
            this.treeViewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    String first = MetaclassViewer.this.getDisplayedName(e1);
                    String second = MetaclassViewer.this.getDisplayedName(e2);
                    return first.compareToIgnoreCase(second);
                }
            });
        } else if (mode == EditorConfiguration.MetaclassesSortMode.ByCount) {
            this.treeViewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    int first = MetaclassViewer.this.getCount(e1);
                    int second = MetaclassViewer.this.getCount(e2);
                    return first - second;
                }
            });
        }
    }

    public void setShowMetaclassesFullQualifiedNames(boolean value) {
        this.editorConfiguration.setShowMetaclassesFullQualifiedNames(value);
        this.treeViewer.refresh();
    }

    public void setShowEmptyMetaclasses(boolean value) {
        this.editorConfiguration.setShowEmptyMetaclasses(value);
        this.refresh();
    }

    public void setGroupByPackage(boolean value) {
        this.editorConfiguration.setGroupByPackage(value);
        this.refresh();
    }

    public void setDisplayInstancesOfSubclasses(boolean value) {
        this.editorConfiguration.setDisplayInstancesOfSubclasses(value);
        this.refresh();
        if (!this.treeViewer.getSelection().isEmpty()) {
            this.treeViewer.setSelection(this.treeViewer.getSelection());
        }
    }

    public void setShowDerivationTree(boolean value) {
        this.editorConfiguration.setShowDerivationTree(value);
        this.refresh();
    }

    private String getDisplayedName(Object object) {
        String name = "";
        if (object instanceof InstancesForMetaclass) {
            InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)((Object)object);
            name = this.editorConfiguration.isShowMetaclassesFullQualifiedNames() ? instancesForMetaclass.getClassQualifiedName() : instancesForMetaclass.getEClass().getName();
        }
        return name;
    }

    private int getCount(Object object) {
        int count = 0;
        if (object instanceof InstancesForMetaclass) {
            InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)((Object)object);
            count = this.editorConfiguration.isDisplayInstancesOfSubclasses() ? instancesForMetaclass.totalSize() : instancesForMetaclass.size();
        }
        return count;
    }

    public void setFont(Font font) {
        this.treeViewer.getTree().setFont(font);
    }

    public Viewer getViewer() {
        return this.treeViewer;
    }

    protected class EmptyMetaclassesFilter
    extends ViewerFilter {
        protected EmptyMetaclassesFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!MetaclassViewer.this.editorConfiguration.isShowEmptyMetaclasses()) {
                if (element instanceof InstancesForMetaclass) {
                    InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)((Object)element);
                    int count = this.getInstanceCountFor(instancesForMetaclass);
                    if (count == 0) {
                        if (MetaclassViewer.this.editorConfiguration.isShowDerivationTree()) {
                            return this.isOneSubclassNonEmpty(instancesForMetaclass);
                        }
                        return false;
                    }
                } else if (element instanceof PackageGroup) {
                    return !this.isEmpty((PackageGroup)element);
                }
            }
            return true;
        }

        private boolean isEmpty(PackageGroup packageGroup) {
            for (Object element : packageGroup) {
                InstancesForMetaclass instancesForMetaclass;
                PackageGroup p;
                if (!(element instanceof PackageGroup ? !this.isEmpty(p = (PackageGroup)element) : element instanceof InstancesForMetaclass && this.getInstanceCountFor(instancesForMetaclass = (InstancesForMetaclass)((Object)element)) != 0)) continue;
                return false;
            }
            return true;
        }

        private boolean isOneSubclassNonEmpty(InstancesForMetaclass instancesForMetaclass) {
            InstancesForMetaclass[] subclasses;
            InstancesForMetaclass[] instancesForMetaclassArray = subclasses = instancesForMetaclass.getSubclasses();
            int n = subclasses.length;
            int n2 = 0;
            while (n2 < n) {
                InstancesForMetaclass subclass = instancesForMetaclassArray[n2];
                if (this.getInstanceCountFor(subclass) > 0 || this.isOneSubclassNonEmpty(subclass)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private int getInstanceCountFor(InstancesForMetaclass instancesForMetaclass) {
            int count = 0;
            count = MetaclassViewer.this.editorConfiguration.isDisplayInstancesOfSubclasses() ? instancesForMetaclass.totalSize() : instancesForMetaclass.size();
            return count;
        }
    }

    protected class MetaclassContentProvider
    implements ITreeContentProvider {
        protected MetaclassContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            InstancesForMetaclasses instancesForMetaclasses = (InstancesForMetaclasses)inputElement;
            InstancesForMetaclass[] instancesByMetaclass = instancesForMetaclasses.getInstancesForMetaclasses();
            if (MetaclassViewer.this.editorConfiguration.isShowDerivationTree()) {
                instancesByMetaclass = instancesForMetaclasses.getRootMetaclasses();
            }
            if (MetaclassViewer.this.editorConfiguration.isGroupByPackage() && !MetaclassViewer.this.editorConfiguration.isShowDerivationTree()) {
                return MetaclassViewer.this.groupByPackage(instancesByMetaclass);
            }
            return instancesByMetaclass;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PackageGroup) {
                PackageGroup packageGroup = (PackageGroup)parentElement;
                return packageGroup.toArray(new Object[packageGroup.size()]);
            }
            if (MetaclassViewer.this.editorConfiguration.isShowDerivationTree() && parentElement instanceof InstancesForMetaclass) {
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)((Object)parentElement);
                return instancesForMetaclass.getSubclasses();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof PackageGroup) {
                PackageGroup packageGroup = (PackageGroup)element;
                return packageGroup.getParent();
            }
            if (element instanceof InstancesForMetaclass) {
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)((Object)element);
                if (MetaclassViewer.this.editorConfiguration.isShowDerivationTree()) {
                    EList superTypes = instancesForMetaclass.getEClass().getESuperTypes();
                    if (superTypes.size() > 0) {
                        String superclassQualifiedName = EMFUtil.getMetaclassQualifiedName((EClass)superTypes.get(0));
                        InstancesForMetaclass superclass = MetaclassViewer.this.editorConfiguration.getInstancesForMetaclasses().getInstancesForMetaclass(superclassQualifiedName);
                        return superclass;
                    }
                } else if (MetaclassViewer.this.editorConfiguration.isGroupByPackage()) {
                    return instancesForMetaclass.getParent();
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof PackageGroup) {
                PackageGroup packageGroup = (PackageGroup)element;
                return packageGroup.size() > 0;
            }
            if (MetaclassViewer.this.editorConfiguration.isShowDerivationTree() && element instanceof InstancesForMetaclass) {
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)((Object)element);
                return instancesForMetaclass.getSubclasses().length > 0;
            }
            return false;
        }
    }

    protected class MetaclassLabelProvider
    extends LabelProvider
    implements ILabelProvider,
    IColorProvider,
    IFontProvider {
        private final Color colorGrayedOut = new Color((Device)Display.getDefault(), 128, 128, 128);

        public String getText(Object element) {
            if (element instanceof InstancesForMetaclass) {
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)((Object)element);
                int count = 0;
                count = MetaclassViewer.this.editorConfiguration.isDisplayInstancesOfSubclasses() ? instancesForMetaclass.totalSize() : instancesForMetaclass.size();
                String name = MetaclassViewer.this.editorConfiguration.isShowMetaclassesFullQualifiedNames() ? instancesForMetaclass.getClassQualifiedName() : instancesForMetaclass.getEClass().getName();
                return String.valueOf(name) + " (" + count + ")";
            }
            if (element instanceof PackageGroup) {
                PackageGroup packageGroup = (PackageGroup)element;
                return packageGroup.getName();
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof InstancesForMetaclass) {
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)((Object)element);
                ArrayList<EObject> instances = instancesForMetaclass.getElements();
                if (instances.size() > 0) {
                    EObject anInstance = instances.get(0);
                    IItemLabelProvider itemLabelProvider = (IItemLabelProvider)MetaclassViewer.this.editorConfiguration.getAdapterFactoryWithRegistry().adapt((Notifier)anInstance, IItemLabelProvider.class);
                    if (itemLabelProvider != null) {
                        return ExtendedImageRegistry.getInstance().getImage(itemLabelProvider.getImage((Object)anInstance));
                    }
                }
                String className = instancesForMetaclass.getEClass().getName();
                URI imageURI = URI.createURI((String)(String.valueOf(EMFEditPlugin.INSTANCE.getImage("full/obj16/Item").toString()) + "#" + className));
                return ExtendedImageRegistry.getInstance().getImage((Object)imageURI);
            }
            if (element instanceof PackageGroup) {
                return ImageProvider.getInstance().getPackageIcon();
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof InstancesForMetaclass) {
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)((Object)element);
                int count = 0;
                count = MetaclassViewer.this.editorConfiguration.isDisplayInstancesOfSubclasses() ? instancesForMetaclass.totalSize() : instancesForMetaclass.size();
                if (count == 0) {
                    return this.colorGrayedOut;
                }
            }
            return null;
        }

        public Font getFont(Object element) {
            InstancesForMetaclass instancesForMetaclass;
            if (element instanceof InstancesForMetaclass && (instancesForMetaclass = (InstancesForMetaclass)((Object)element)).getEClass().isAbstract()) {
                return MetaclassViewer.this.editorConfiguration.getCustomItalicFont();
            }
            return MetaclassViewer.this.editorConfiguration.getCustomFont();
        }

        public void dispose() {
            this.colorGrayedOut.dispose();
            super.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PackageGroup
    extends ArrayList<Object> {
        private final String name;
        private final Object parent;

        public PackageGroup(Object parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public Object getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }
    }
}

