/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.editors;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.common.editor.MoDiscoEditorPlugin;
import org.eclipse.gmt.modisco.common.editor.core.InstancesForMetaclass;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;
import org.eclipse.gmt.modisco.common.editor.editors.MetaclassViewer;
import org.eclipse.gmt.modisco.common.editor.editors.table.TableEditorInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class MetaclassViewerMenuManager
extends MenuManager
implements IMenuListener {
    private final EditorConfiguration editorConfiguration;
    private final MetaclassViewer metaclassViewer;
    protected IAction openTableEditorAction = new Action(MoDiscoEditorPlugin.INSTANCE.getString("_UI_OpenTableEditorOnSelection_menu_item")){

        public void run() {
            String[] selectedMetaclasses = MetaclassViewerMenuManager.this.metaclassViewer.getSelectedMetaclassesQualifiedNames();
            ArrayList<EObject> elements = new ArrayList<EObject>();
            String[] stringArray = selectedMetaclasses;
            int n = selectedMetaclasses.length;
            int n2 = 0;
            while (n2 < n) {
                String selectedMetaclass = stringArray[n2];
                InstancesForMetaclass instancesForMetaclass = MetaclassViewerMenuManager.this.editorConfiguration.getInstancesForMetaclasses().getInstancesForMetaclass(selectedMetaclass);
                if (instancesForMetaclass != null) {
                    elements.addAll(instancesForMetaclass.getElements());
                    if (MetaclassViewerMenuManager.this.editorConfiguration.isDisplayInstancesOfSubclasses()) {
                        elements.addAll(instancesForMetaclass.getDerivedElements());
                    }
                }
                ++n2;
            }
            TableEditorInput tableEditorInput = new TableEditorInput(MetaclassViewerMenuManager.this.editorConfiguration, elements, this.getDescriptionFor(selectedMetaclasses));
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)tableEditorInput, (String)"org.eclipse.gmt.modisco.common.editor.table.editorID", (boolean)true);
            }
            catch (PartInitException e) {
                MoDiscoEditorPlugin.INSTANCE.log((Object)e);
            }
        }

        private String getDescriptionFor(String[] selectedMetaclasses) {
            if (selectedMetaclasses.length < 1) {
                throw new IllegalArgumentException();
            }
            StringBuilder description = new StringBuilder();
            description.append("Instances of ");
            description.append(selectedMetaclasses[0]);
            int i = 1;
            while (i < selectedMetaclasses.length) {
                description.append(", " + selectedMetaclasses[i]);
                ++i;
            }
            return description.toString();
        }
    };

    public MetaclassViewerMenuManager(MetaclassViewer metaclassViewer, EditorConfiguration editorConfiguration) {
        this.metaclassViewer = metaclassViewer;
        this.editorConfiguration = editorConfiguration;
        this.addMenuActions();
        this.addMenuListener(this);
    }

    private void addMenuActions() {
        this.add(this.openTableEditorAction);
    }

    public void menuAboutToShow(IMenuManager manager) {
        EClass[] selectedMetaclasses = this.metaclassViewer.getSelectedMetaclasses();
        this.openTableEditorAction.setEnabled(selectedMetaclasses.length > 0);
    }
}

