/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.editors;

import org.eclipse.gmt.modisco.common.editor.editors.EcoreEditor;
import org.eclipse.gmt.modisco.common.editor.util.ImageProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TreeToolBar {
    private final ToolBar toolBar;
    private final EcoreEditor editor;
    private ToolItem btnShowEmptyLinks;
    private ToolItem btnSortInstances;
    private ToolItem btnSortLinks;
    private ToolItem btnSortLinksByType;
    private ToolItem btnShowDerivedLinks;
    private ToolItem btnShowFullQualifiedNames;
    private ToolItem btnShowMultiplicity;
    private ToolItem btnShowOppositeLinks;
    private ToolItem btnShowContainer;
    private ToolItem btnShowAttributes;
    private ToolItem btnShowEmptyAttributes;
    private ToolItem btnShowOrdering;

    public TreeToolBar(Composite parent, EcoreEditor editor) {
        this.editor = editor;
        this.toolBar = new ToolBar(parent, 0);
        GridData toolBarGridData = new GridData();
        toolBarGridData.grabExcessHorizontalSpace = false;
        toolBarGridData.horizontalAlignment = 4;
        this.toolBar.setLayoutData((Object)toolBarGridData);
        this.createToolButtons();
        this.initialize();
    }

    private void createToolButtons() {
        this.createShowEmptyLinksButton();
        this.createShowDerivedLinksButton();
        this.createSortInstancesButton();
        this.createSortLinksButton();
        this.createSortLinksByTypeButton();
        this.createShowFullQualifiedNamesButton();
        this.createShowMultiplicityButton();
        this.createShowOrderingButton();
        this.createShowOppositeLinksButton();
        this.createShowContainerButton();
        this.createShowAttributesButton();
        this.createShowEmptyAttributesButton();
    }

    private void createShowEmptyLinksButton() {
        this.btnShowEmptyLinks = new ToolItem(this.toolBar, 32);
        this.btnShowEmptyLinks.setToolTipText("Show Empty Links");
        this.btnShowEmptyLinks.setImage(ImageProvider.getInstance().getEmptyLinksIcon());
        this.btnShowEmptyLinks.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeToolBar.this.editor.setShowEmptyLinks(TreeToolBar.this.btnShowEmptyLinks.getSelection());
            }
        });
    }

    private void createShowDerivedLinksButton() {
        this.btnShowDerivedLinks = new ToolItem(this.toolBar, 32);
        this.btnShowDerivedLinks.setToolTipText("Show Derived Links");
        this.btnShowDerivedLinks.setImage(ImageProvider.getInstance().getShowDerivedLinksIcon());
        this.btnShowDerivedLinks.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeToolBar.this.editor.setShowDerivedLinks(TreeToolBar.this.btnShowDerivedLinks.getSelection());
            }
        });
    }

    private void createSortInstancesButton() {
        this.btnSortInstances = new ToolItem(this.toolBar, 32);
        this.btnSortInstances.setToolTipText("Sort Instances");
        this.btnSortInstances.setImage(ImageProvider.getInstance().getSortInstancesIcon());
        this.btnSortInstances.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeToolBar.this.editor.setSortInstances(TreeToolBar.this.btnSortInstances.getSelection());
            }
        });
    }

    private void createSortLinksButton() {
        this.btnSortLinks = new ToolItem(this.toolBar, 32);
        this.btnSortLinks.setToolTipText("Sort Links");
        this.btnSortLinks.setImage(ImageProvider.getInstance().getSortLinksIcon());
        this.btnSortLinks.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeToolBar.this.editor.setSortLinks(TreeToolBar.this.btnSortLinks.getSelection());
            }
        });
    }

    private void createSortLinksByTypeButton() {
        this.btnSortLinksByType = new ToolItem(this.toolBar, 32);
        this.btnSortLinksByType.setToolTipText("Sort Links by Type");
        this.btnSortLinksByType.setImage(ImageProvider.getInstance().getSortLinksByTypeIcon());
        this.btnSortLinksByType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeToolBar.this.editor.setSortLinksByType(TreeToolBar.this.btnSortLinksByType.getSelection());
            }
        });
    }

    private void createShowFullQualifiedNamesButton() {
        this.btnShowFullQualifiedNames = new ToolItem(this.toolBar, 32);
        this.btnShowFullQualifiedNames.setToolTipText("Show Full Qualified Names");
        this.btnShowFullQualifiedNames.setImage(ImageProvider.getInstance().getShowFullQualifiedNamesIcon());
        this.btnShowFullQualifiedNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeToolBar.this.editor.setShowFullQualifiedNames(TreeToolBar.this.btnShowFullQualifiedNames.getSelection());
            }
        });
    }

    private void createShowMultiplicityButton() {
        this.btnShowMultiplicity = new ToolItem(this.toolBar, 32);
        this.btnShowMultiplicity.setToolTipText("Show Multiplicity");
        this.btnShowMultiplicity.setImage(ImageProvider.getInstance().getShowMultiplicityIcon());
        this.btnShowMultiplicity.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeToolBar.this.editor.setShowMultiplicity(TreeToolBar.this.btnShowMultiplicity.getSelection());
            }
        });
    }

    private void createShowOppositeLinksButton() {
        this.btnShowOppositeLinks = new ToolItem(this.toolBar, 32);
        this.btnShowOppositeLinks.setToolTipText("Show Opposite Links");
        this.btnShowOppositeLinks.setImage(ImageProvider.getInstance().getShowOppositeLinksIcon());
        this.btnShowOppositeLinks.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeToolBar.this.editor.setShowOppositeLinks(TreeToolBar.this.btnShowOppositeLinks.getSelection());
            }
        });
    }

    private void createShowContainerButton() {
        this.btnShowContainer = new ToolItem(this.toolBar, 32);
        this.btnShowContainer.setToolTipText("Show Container");
        this.btnShowContainer.setImage(ImageProvider.getInstance().getContainerIcon());
        this.btnShowContainer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeToolBar.this.editor.setShowContainer(TreeToolBar.this.btnShowContainer.getSelection());
            }
        });
    }

    private void createShowAttributesButton() {
        this.btnShowAttributes = new ToolItem(this.toolBar, 32);
        this.btnShowAttributes.setToolTipText("Show Attributes");
        this.btnShowAttributes.setImage(ImageProvider.getInstance().getAttributeIcon());
        this.btnShowAttributes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeToolBar.this.editor.setShowAttributes(TreeToolBar.this.btnShowAttributes.getSelection());
                TreeToolBar.this.btnShowEmptyAttributes.setEnabled(TreeToolBar.this.btnShowAttributes.getSelection());
            }
        });
    }

    private void createShowEmptyAttributesButton() {
        this.btnShowEmptyAttributes = new ToolItem(this.toolBar, 32);
        this.btnShowEmptyAttributes.setToolTipText("Show Empty Attributes");
        this.btnShowEmptyAttributes.setImage(ImageProvider.getInstance().getEmptyAttributeIcon());
        this.btnShowEmptyAttributes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeToolBar.this.editor.setShowEmptyAttributes(TreeToolBar.this.btnShowEmptyAttributes.getSelection());
            }
        });
    }

    private void createShowOrderingButton() {
        this.btnShowOrdering = new ToolItem(this.toolBar, 32);
        this.btnShowOrdering.setToolTipText("Show Ordering");
        this.btnShowOrdering.setImage(ImageProvider.getInstance().getOrderingIcon());
        this.btnShowOrdering.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeToolBar.this.editor.setShowOrdering(TreeToolBar.this.btnShowOrdering.getSelection());
            }
        });
    }

    private void initialize() {
        this.btnShowEmptyLinks.setSelection(this.editor.isShowEmptyLinks());
        this.btnSortInstances.setSelection(this.editor.isSortInstances());
        this.btnSortLinks.setSelection(this.editor.isSortLinks());
        this.btnSortLinksByType.setSelection(this.editor.isSortLinksByType());
        this.btnShowDerivedLinks.setSelection(this.editor.isShowDerivedLinks());
        this.btnShowFullQualifiedNames.setSelection(this.editor.isShowFullQualifiedNames());
        this.btnShowMultiplicity.setSelection(this.editor.isShowMultiplicity());
        this.btnShowOppositeLinks.setSelection(this.editor.isShowOppositeLinks());
        this.btnShowContainer.setSelection(this.editor.isShowContainer());
        this.btnShowAttributes.setSelection(this.editor.isShowAttributes());
        this.btnShowEmptyAttributes.setSelection(this.editor.isShowEmptyAttributes());
        this.btnShowOrdering.setSelection(this.editor.isShowOrdering());
        this.btnShowEmptyAttributes.setEnabled(this.editor.isShowAttributes());
    }
}

