/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.editors;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmt.modisco.common.editor.MoDiscoEditorPlugin;
import org.eclipse.gmt.modisco.common.editor.editors.EcoreEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class WorkspaceChangeListener
implements IResourceChangeListener {
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    private final EcoreEditor editor;

    public WorkspaceChangeListener(EcoreEditor editor) {
        this.editor = editor;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ResourceDeltaVisitor
            implements IResourceDeltaVisitor {
                protected ResourceSet resourceSet;
                protected Collection<Resource> innerChangedResources;
                protected Collection<Resource> innerRemovedResources;

                ResourceDeltaVisitor() {
                    this.resourceSet = WorkspaceChangeListener.this.editor.getEditingDomain().getResourceSet();
                    this.innerChangedResources = new ArrayList<Resource>();
                    this.innerRemovedResources = new ArrayList<Resource>();
                }

                public boolean visit(IResourceDelta delta) {
                    Resource resource;
                    if (delta.getResource().getType() == 1 && (delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(URI.createURI((String)delta.getFullPath().toString()), false)) != null) {
                        if (delta.getKind() == 2) {
                            this.innerRemovedResources.add(resource);
                        } else if (!WorkspaceChangeListener.this.savedResources.remove(resource)) {
                            this.innerChangedResources.add(resource);
                        }
                    }
                    return true;
                }

                public Collection<Resource> getChangedResources() {
                    return this.innerChangedResources;
                }

                public Collection<Resource> getRemovedResources() {
                    return this.innerRemovedResources;
                }
            }
            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
            delta.accept((IResourceDeltaVisitor)visitor);
            if (!visitor.getRemovedResources().isEmpty()) {
                this.removedResources.addAll(visitor.getRemovedResources());
                if (!this.editor.isDirty()) {
                    this.editor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            WorkspaceChangeListener.this.editor.getSite().getPage().closeEditor((IEditorPart)WorkspaceChangeListener.this.editor, false);
                        }
                    });
                }
            }
            if (!visitor.getChangedResources().isEmpty()) {
                this.changedResources.addAll(visitor.getChangedResources());
                if (this.editor.getSite().getPage().getActiveEditor() == this.editor) {
                    this.editor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            WorkspaceChangeListener.this.handleActivate();
                        }
                    });
                }
            }
        }
        catch (CoreException exception) {
            MoDiscoEditorPlugin.INSTANCE.log((Object)exception);
        }
    }

    protected void handleActivate() {
        this.editor.handleActivate();
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.editor.getSite().getPage().closeEditor((IEditorPart)this.editor, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.editor.isDirty() && !this.handleDirtyConflict())) {
            this.editor.handleChangedResources(this.changedResources);
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.editor.getSite().getShell(), (String)WorkspaceChangeListener.getString("_UI_FileConflict_label"), (String)WorkspaceChangeListener.getString("_WARN_FileConflict"));
    }

    private static String getString(String key) {
        return MoDiscoEditorPlugin.INSTANCE.getString(key);
    }

    public void addSavedResource(Resource resource) {
        this.savedResources.add(resource);
    }
}

