/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.editors.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gmt.modisco.common.editor.MoDiscoEditorPlugin;
import org.eclipse.gmt.modisco.common.editor.adapters.LinkItemProvider;
import org.eclipse.gmt.modisco.common.editor.editors.EcoreEditor;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;
import org.eclipse.gmt.modisco.common.editor.editors.table.ColumnDescription;
import org.eclipse.gmt.modisco.common.editor.editors.table.TableEditorContentProvider;
import org.eclipse.gmt.modisco.common.editor.editors.table.TableEditorInput;
import org.eclipse.gmt.modisco.common.editor.editors.table.TableEditorLabelProvider;
import org.eclipse.gmt.modisco.common.editor.editors.table.TableEditorToolBar;
import org.eclipse.gmt.modisco.common.editor.editors.table.TableSorter;
import org.eclipse.gmt.modisco.common.editor.util.ImageProvider;
import org.eclipse.gmt.modisco.common.editor.util.Util;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableEditor
extends EditorPart {
    private static final int MAX_INITIAL_COLUMN_WIDTH = 300;
    public static final String EDITOR_ID = "org.eclipse.gmt.modisco.common.editor.table.editorID";
    private static final int USE_VIRTUAL_THRESHOLD = 1000;
    private static final String KEY_EMPTY_HIDDEN = "emptyHidden";
    private static final String KEY_NOT_COMMON_HIDDEN = "notCommonHidden";
    protected TableViewer tableViewer;
    private TableEditorInput tableEditorInput;
    private TableEditorLabelProvider tableEditorLabelProvider;
    private List<ColumnDescription> columnsConfiguration;
    private TableEditorToolBar toolBar;
    private TableEditorContentProvider tableEditorContentProvider;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof TableEditorInput)) {
            throw new PartInitException("Input should be of type TableEditorInput");
        }
        this.tableEditorInput = (TableEditorInput)input;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(this.tableEditorInput);
        this.setPartName("Table Viewer");
    }

    public void createPartControl(Composite parent) {
        Composite editorComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 2;
        editorComposite.setLayout((Layout)gridLayout);
        this.createToolBar(editorComposite);
        this.toolBar.setLabelText(this.tableEditorInput.getDescription());
        GridData tableGridData = new GridData();
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.grabExcessVerticalSpace = true;
        tableGridData.horizontalAlignment = 4;
        tableGridData.verticalAlignment = 4;
        int virtualFlag = 0;
        if (this.tableEditorInput.getElements().size() > 1000) {
            virtualFlag = 0x10000000;
        }
        this.tableViewer = new TableViewer(editorComposite, 0x10304 | virtualFlag);
        this.tableViewer.getTable().setLayoutData((Object)tableGridData);
        this.tableViewer.getTable().setFont(this.tableEditorInput.getEditorConfiguration().getCustomFont());
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableEditorContentProvider = new TableEditorContentProvider();
        this.columnsConfiguration = this.createColumnConfiguration(false);
        this.tableEditorLabelProvider = new TableEditorLabelProvider(this.columnsConfiguration, this.tableEditorInput.getEditorConfiguration());
        this.createColumns(this.columnsConfiguration);
        this.tableViewer.setContentProvider((IContentProvider)this.tableEditorContentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.tableEditorLabelProvider);
        this.tableViewer.setInput((Object)this.tableEditorInput);
        this.createContextMenu();
        this.registerOpenListeners();
        this.registerCloseWhenMainEditorClosed();
        this.packColumns();
    }

    private void createToolBar(Composite parent) {
        Composite toolBarComposite = new Composite(parent, 0);
        this.toolBar = new TableEditorToolBar(toolBarComposite, this);
    }

    private void registerCloseWhenMainEditorClosed() {
        EcoreEditor editor = this.tableEditorInput.getEditorConfiguration().getEditor();
        if (editor == null) {
            return;
        }
        editor.getEditorSite().getPage().addPartListener(new IPartListener(){

            public void partClosed(IWorkbenchPart part) {
                EcoreEditor editor = TableEditor.this.tableEditorInput.getEditorConfiguration().getEditor();
                if (editor != null && part == editor) {
                    TableEditor.this.getSite().getPage().closeEditor((IEditorPart)TableEditor.this, false);
                }
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        });
    }

    private void createContextMenu() {
        final Menu menu = new Menu((Control)this.tableViewer.getTable());
        this.tableViewer.getTable().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                MenuItem[] menuItems;
                Point clickedPoint = new Point(e.x, e.y);
                Point widgetRelativeClickedPoint = Display.getDefault().map(null, (Control)TableEditor.this.tableViewer.getTable(), clickedPoint);
                ViewerCell cell = TableEditor.this.tableViewer.getCell(widgetRelativeClickedPoint);
                int column = cell == null ? 0 : cell.getColumnIndex();
                MenuItem[] menuItemArray = menuItems = menu.getItems();
                int n = menuItems.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem menuItem = menuItemArray[n2];
                    menuItem.dispose();
                    ++n2;
                }
                ColumnDescription columnDescription = (ColumnDescription)TableEditor.this.columnsConfiguration.get(column);
                EObject element = null;
                EObject mainElement = TableEditor.this.getSelectedElement();
                if (mainElement == null) {
                    return;
                }
                if (columnDescription.getType() == ColumnDescription.Type.REFERENCE) {
                    boolean oneElement = true;
                    if (columnDescription.getReference().isMany()) {
                        EList list = (EList)mainElement.eGet((EStructuralFeature)columnDescription.getReference());
                        boolean bl = oneElement = list.size() == 1;
                    }
                    if (oneElement) {
                        element = TableEditor.this.findElementToOpenInMainEditor(column);
                        if (element != null) {
                            this.createBrowseMenuItemFor(element);
                        }
                    } else {
                        this.createViewInTableMenuItemFor(mainElement, columnDescription.getReference());
                    }
                } else if (columnDescription.getType() == ColumnDescription.Type.ECONTAINER && (element = mainElement.eContainer()) != null) {
                    this.createBrowseMenuItemFor(element);
                }
                if (element != mainElement) {
                    this.createBrowseMenuItemFor(mainElement);
                }
                menu.setLocation(clickedPoint);
                menu.setVisible(true);
            }

            private void createBrowseMenuItemFor(final EObject element) {
                if (element == null) {
                    return;
                }
                String text = TableEditor.this.tableEditorLabelProvider.getTextFor(element);
                MenuItem browseMenuItem = new MenuItem(menu, 8);
                browseMenuItem.setText("Browse " + Util.truncateBeforeNewline(text));
                browseMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TableEditor.this.openElementInMainEditor(element);
                    }
                });
            }

            private void createViewInTableMenuItemFor(final EObject parentElement, final EReference reference) {
                final EList elements = (EList)parentElement.eGet((EStructuralFeature)reference);
                MenuItem menuItem = new MenuItem(menu, 8);
                menuItem.setText(MoDiscoEditorPlugin.INSTANCE.getString("_UI_OpenTableEditorOnSelection_menu_item"));
                if (elements.size() == 0) {
                    menuItem.setEnabled(false);
                }
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        EditorConfiguration editorConfiguration = TableEditor.this.tableEditorInput.getEditorConfiguration();
                        String description = TableEditor.getEditorDescriptionFor(parentElement, reference, editorConfiguration);
                        TableEditor.openOn(TableEditor.this.tableEditorInput.getEditorConfiguration(), (List<EObject>)elements, description);
                    }
                });
            }
        });
    }

    private void registerOpenListeners() {
        this.tableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ViewerCell cell = TableEditor.this.tableViewer.getCell(new Point(e.x, e.y));
                int column = cell == null ? 0 : cell.getColumnIndex();
                TableEditor.this.openSelectionInMainEditor(column);
            }
        });
        this.tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    TableEditor.this.openSelectionInMainEditor(0);
                }
            }
        });
    }

    private void packColumns() {
        TableColumn[] tableColumns;
        TableColumn[] tableColumnArray = tableColumns = this.tableViewer.getTable().getColumns();
        int n = tableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            tableColumn.pack();
            if (tableColumn.getWidth() > 300) {
                tableColumn.setWidth(300);
            }
            ++n2;
        }
    }

    private List<ColumnDescription> createColumnConfiguration(boolean hideEmptyColumns) {
        ArrayList<ColumnDescription> columns = new ArrayList<ColumnDescription>();
        columns.add(new ColumnDescription(ColumnDescription.Type.DEFAULT_LABEL));
        columns.add(new ColumnDescription(ColumnDescription.Type.METACLASS_NAME));
        columns.add(new ColumnDescription(ColumnDescription.Type.ECONTAINER));
        for (EAttribute attribute : this.tableEditorInput.getAttributes()) {
            if (hideEmptyColumns && this.isEmpty(attribute)) continue;
            columns.add(new ColumnDescription(attribute));
        }
        for (EReference reference : this.tableEditorInput.getReferences()) {
            if (reference.isDerived() || hideEmptyColumns && this.isEmpty(reference)) continue;
            columns.add(new ColumnDescription(reference));
        }
        for (EReference reference : this.tableEditorInput.getReferences()) {
            if (!reference.isDerived() || hideEmptyColumns && this.isEmpty(reference)) continue;
            columns.add(new ColumnDescription(reference));
        }
        return columns;
    }

    private boolean isEmpty(EReference reference) {
        Object[] elements;
        Object[] objectArray = elements = this.tableEditorContentProvider.getElements(this.tableEditorInput);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            EObject eObject;
            Object element = objectArray[n2];
            if (element instanceof EObject && (eObject = (EObject)element).eClass().getEAllReferences().contains((Object)reference)) {
                EList list;
                Object value = eObject.eGet((EStructuralFeature)reference);
                if (reference.isMany() ? !(list = (EList)value).isEmpty() : value != null) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private boolean isEmpty(EAttribute attribute) {
        Object[] elements;
        Object[] objectArray = elements = this.tableEditorContentProvider.getElements(this.tableEditorInput);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            EObject eObject;
            Object element = objectArray[n2];
            if (element instanceof EObject && (eObject = (EObject)element).eClass().getEAllAttributes().contains((Object)attribute)) {
                EList list;
                Object value = eObject.eGet((EStructuralFeature)attribute);
                if (attribute.isMany() ? !(list = (EList)value).isEmpty() : value != null) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private void createColumns(List<ColumnDescription> columns) {
        int columnIndex = 0;
        for (ColumnDescription columnDescription : columns) {
            TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
            TableColumn tableColumn = column.getColumn();
            tableColumn.setWidth(100);
            tableColumn.setResizable(true);
            tableColumn.setMoveable(true);
            column.getColumn().setData((Object)columnDescription);
            switch (columnDescription.getType()) {
                case DEFAULT_LABEL: {
                    tableColumn.setText("[Label]");
                    tableColumn.setWidth(125);
                    break;
                }
                case METACLASS_NAME: {
                    tableColumn.setText("[Metaclass]");
                    break;
                }
                case ECONTAINER: {
                    tableColumn.setText("/eContainer");
                    break;
                }
                case ATTRIBUTE: {
                    EAttribute attribute = columnDescription.getAttribute();
                    if (attribute.isDerived()) {
                        tableColumn.setText("/" + attribute.getName());
                    } else {
                        tableColumn.setText(attribute.getName());
                    }
                    tableColumn.setImage(ImageProvider.getInstance().getAttributeIcon());
                    break;
                }
                case REFERENCE: {
                    EReference reference = columnDescription.getReference();
                    String multiplicity = LinkItemProvider.getMultiplicity(reference);
                    if (reference.isDerived()) {
                        tableColumn.setText("/" + reference.getName() + multiplicity);
                    } else {
                        tableColumn.setText(String.valueOf(reference.getName()) + multiplicity);
                    }
                    tableColumn.setImage((Image)LinkItemProvider.getImageFor(reference));
                }
            }
            final int fColumnIndex = columnIndex++;
            new TableSorter(this.tableViewer, column){

                protected int doCompare(Viewer viewer, Object e1, Object e2) {
                    String label1 = TableEditor.this.tableEditorLabelProvider.getColumnText(e1, fColumnIndex);
                    String label2 = TableEditor.this.tableEditorLabelProvider.getColumnText(e2, fColumnIndex);
                    return label1.compareToIgnoreCase(label2);
                }
            };
        }
    }

    public void setFocus() {
        if (this.tableViewer != null) {
            this.tableViewer.getTable().setFocus();
        }
    }

    public static boolean canBeOpenedOnSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1 && structuredSelection.getFirstElement() instanceof LinkItemProvider) {
                LinkItemProvider linkItemProvider = (LinkItemProvider)((Object)structuredSelection.getFirstElement());
                return linkItemProvider.getChildren(null).size() > 0;
            }
            boolean empty = true;
            for (Object selectedElement : structuredSelection) {
                if (selectedElement instanceof EObject) {
                    empty = false;
                    continue;
                }
                return false;
            }
            return !empty;
        }
        return false;
    }

    public static void openOn(EditorConfiguration editorConfiguration, List<EObject> elements, String description) {
        TableEditorInput input = new TableEditorInput(editorConfiguration, elements, description);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)input, (String)EDITOR_ID, (boolean)true);
        }
        catch (PartInitException e) {
            MoDiscoEditorPlugin.INSTANCE.log((Object)e);
        }
    }

    private void openSelectionInMainEditor(int column) {
        EObject element = this.findElementToOpenInMainEditor(column);
        if (element != null) {
            this.openElementInMainEditor(element);
        }
    }

    private EObject getSelectedElement() {
        IStructuredSelection structuredSelection;
        Object firstElement;
        ISelection selection = this.tableViewer.getSelection();
        if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            return (EObject)firstElement;
        }
        return null;
    }

    private EObject findElementToOpenInMainEditor(int column) {
        EObject mainElement = this.getSelectedElement();
        if (mainElement == null) {
            return null;
        }
        EObject targetObject = null;
        if (column > 0) {
            EObject value;
            ColumnDescription columnDescription = this.columnsConfiguration.get(column);
            if (columnDescription.getType() == ColumnDescription.Type.ATTRIBUTE) {
                Object value2 = mainElement.eGet((EStructuralFeature)columnDescription.getAttribute());
                if (value2 instanceof EObject) {
                    targetObject = (EObject)value2;
                }
            } else if (columnDescription.getType() == ColumnDescription.Type.REFERENCE) {
                Object value3 = mainElement.eGet((EStructuralFeature)columnDescription.getReference());
                if (columnDescription.getReference().isMany()) {
                    EList list = (EList)value3;
                    if (list.size() == 1) {
                        targetObject = (EObject)list.get(0);
                    }
                } else {
                    targetObject = (EObject)value3;
                }
            } else if (columnDescription.getType() == ColumnDescription.Type.ECONTAINER && (value = mainElement.eContainer()) instanceof EObject) {
                targetObject = value;
            }
        }
        if (targetObject != null) {
            return targetObject;
        }
        return mainElement;
    }

    private void openElementInMainEditor(EObject element) {
        EcoreEditor editor = this.tableEditorInput.getEditorConfiguration().getEditor();
        if (editor != null) {
            editor.getSite().getPage().activate((IWorkbenchPart)editor);
            editor.browseTo(element);
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void setHideEmptyColumns(boolean hideEmptyColumns) {
        try {
            this.tableViewer.getControl().setRedraw(false);
            for (ColumnDescription columnDescription : this.columnsConfiguration) {
                boolean bEmpty = false;
                if (columnDescription.getType() == ColumnDescription.Type.ATTRIBUTE) {
                    bEmpty = this.isEmpty(columnDescription.getAttribute());
                } else if (columnDescription.getType() == ColumnDescription.Type.REFERENCE) {
                    bEmpty = this.isEmpty(columnDescription.getReference());
                }
                TableColumn column = this.findColumn(columnDescription);
                if (hideEmptyColumns && bEmpty) {
                    if (column == null) continue;
                    column.setData(KEY_EMPTY_HIDDEN, (Object)Boolean.TRUE);
                    this.hideColumn(column);
                    continue;
                }
                if (hideEmptyColumns || Boolean.TRUE != column.getData(KEY_EMPTY_HIDDEN)) continue;
                column.setData(KEY_EMPTY_HIDDEN, (Object)Boolean.FALSE);
                this.showColumn(column);
            }
        }
        finally {
            this.tableViewer.getControl().setRedraw(true);
        }
    }

    public void setOnlyShowCommonColumns(boolean onlyShowCommonColumns) {
        try {
            this.tableViewer.getControl().setRedraw(false);
            EClass[] metaclasses = this.tableEditorInput.getMetaclasses();
            for (ColumnDescription columnDescription : this.columnsConfiguration) {
                boolean common = true;
                if (columnDescription.getType() == ColumnDescription.Type.ATTRIBUTE) {
                    common = this.isCommon((EStructuralFeature)columnDescription.getAttribute(), metaclasses);
                } else if (columnDescription.getType() == ColumnDescription.Type.REFERENCE) {
                    common = this.isCommon((EStructuralFeature)columnDescription.getReference(), metaclasses);
                }
                TableColumn column = this.findColumn(columnDescription);
                if (onlyShowCommonColumns && !common) {
                    if (column == null) continue;
                    column.setData(KEY_NOT_COMMON_HIDDEN, (Object)Boolean.TRUE);
                    this.hideColumn(column);
                    continue;
                }
                if (onlyShowCommonColumns || Boolean.TRUE != column.getData(KEY_NOT_COMMON_HIDDEN)) continue;
                column.setData(KEY_NOT_COMMON_HIDDEN, (Object)Boolean.FALSE);
                this.showColumn(column);
            }
        }
        finally {
            this.tableViewer.getControl().setRedraw(true);
        }
    }

    private void hideColumn(TableColumn column) {
        column.setWidth(0);
        column.setResizable(false);
    }

    private void showColumn(TableColumn column) {
        if (Boolean.TRUE != column.getData(KEY_EMPTY_HIDDEN) && Boolean.TRUE != column.getData(KEY_NOT_COMMON_HIDDEN)) {
            column.pack();
            column.setResizable(true);
        }
    }

    private boolean isCommon(EStructuralFeature feature, EClass[] metaclasses) {
        EClass[] eClassArray = metaclasses;
        int n = metaclasses.length;
        int n2 = 0;
        while (n2 < n) {
            EClass metaclass = eClassArray[n2];
            if (!metaclass.getEAllStructuralFeatures().contains((Object)feature)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private TableColumn findColumn(ColumnDescription columnDescription) {
        TableColumn[] columns;
        TableColumn[] tableColumnArray = columns = this.tableViewer.getTable().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            if (tableColumn.getData() == columnDescription) {
                return tableColumn;
            }
            ++n2;
        }
        return null;
    }

    public static String getEditorDescriptionFor(EObject parent, EReference reference, EditorConfiguration editorConfiguration) {
        ComposedAdapterFactory adapterFactory = editorConfiguration.getAdapterFactory();
        IItemLabelProvider labelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)parent, IItemLabelProvider.class);
        String parentLabel = labelProvider.getText((Object)parent);
        return "\"" + parentLabel + "\" \u2014> " + reference.getName() + " contents";
    }
}

