/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.editors.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmt.modisco.common.editor.core.InstancesForMetaclass;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;
import org.eclipse.gmt.modisco.common.editor.util.EMFUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableEditorInput
implements IEditorInput {
    private List<EObject> elements;
    private List<EAttribute> attributes;
    private List<EReference> references;
    private final EditorConfiguration editorConfiguration;
    private final String description;
    private HashSet<EClass> metaclasses;

    public TableEditorInput(EditorConfiguration editorConfiguration, List<EObject> elements, String description) {
        this.editorConfiguration = editorConfiguration;
        this.elements = elements;
        this.description = description;
        this.metaclasses = new HashSet();
        for (EObject element : elements) {
            this.metaclasses.add(element.eClass());
        }
        HashSet attributeSet = new HashSet();
        for (EClass eClass : this.metaclasses) {
            attributeSet.addAll(eClass.getEAllAttributes());
        }
        HashSet referenceSet = new HashSet();
        for (EClass eClass : this.metaclasses) {
            referenceSet.addAll(eClass.getEAllReferences());
        }
        this.attributes = new ArrayList<EAttribute>(attributeSet);
        this.references = new ArrayList<EReference>(referenceSet);
    }

    public TableEditorInput(EditorConfiguration editorConfiguration, EClass eClass, String description) {
        this.editorConfiguration = editorConfiguration;
        this.description = description;
        InstancesForMetaclass instances = this.editorConfiguration.getInstancesForMetaclasses().getInstancesForMetaclass(EMFUtil.getMetaclassQualifiedName(eClass));
        this.elements = new ArrayList<EObject>(instances.getElements());
        this.attributes = new ArrayList<EAttribute>((Collection<EAttribute>)eClass.getEAllAttributes());
        this.references = new ArrayList<EReference>((Collection<EReference>)eClass.getEAllReferences());
    }

    public List<EObject> getElements() {
        return this.elements;
    }

    public List<EAttribute> getAttributes() {
        return this.attributes;
    }

    public List<EReference> getReferences() {
        return this.references;
    }

    public String getDescription() {
        return this.description;
    }

    public EditorConfiguration getEditorConfiguration() {
        return this.editorConfiguration;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return "Table Viewer";
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "Table Viewer";
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public EClass[] getMetaclasses() {
        return this.metaclasses.toArray(new EClass[this.metaclasses.size()]);
    }
}

