/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.editors.table;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;
import org.eclipse.gmt.modisco.common.editor.editors.table.ColumnDescription;
import org.eclipse.gmt.modisco.common.editor.util.Util;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableEditorLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final EditorConfiguration editorConfiguration;
    private final List<ColumnDescription> columns;

    public TableEditorLabelProvider(List<ColumnDescription> columns, EditorConfiguration editorConfiguration) {
        this.columns = columns;
        this.editorConfiguration = editorConfiguration;
    }

    public String getTextFor(Object element) {
        if (element == null) {
            return "null";
        }
        ComposedAdapterFactory adapterFactory = this.editorConfiguration.getAdapterFactory();
        IItemLabelProvider labelProvider = (IItemLabelProvider)adapterFactory.adapt(element, IItemLabelProvider.class);
        return labelProvider.getText(element);
    }

    public Image getImageFor(Object element) {
        if (element == null) {
            return null;
        }
        ComposedAdapterFactory adapterFactory = this.editorConfiguration.getAdapterFactory();
        IItemLabelProvider labelProvider = (IItemLabelProvider)adapterFactory.adapt(element, IItemLabelProvider.class);
        if (labelProvider != null) {
            return ExtendedImageRegistry.getInstance().getImage(labelProvider.getImage(element));
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex < this.columns.size()) {
            ColumnDescription columnDescription = this.columns.get(columnIndex);
            if (columnDescription.getType() == ColumnDescription.Type.DEFAULT_LABEL) {
                return this.getImageFor(element);
            }
            if (columnDescription.getType() == ColumnDescription.Type.REFERENCE) {
                EReference reference = columnDescription.getReference();
                EObject eObject = (EObject)element;
                if (!eObject.eClass().getEAllReferences().contains((Object)reference)) {
                    return null;
                }
                Object value = eObject.eGet((EStructuralFeature)reference);
                if (reference.isMany()) {
                    EList list = (EList)value;
                    if (list.size() == 1) {
                        return this.getImageFor(list.get(0));
                    }
                    return null;
                }
                if (value != null) {
                    return this.getImageFor(value);
                }
            } else if (columnDescription.getType() == ColumnDescription.Type.ECONTAINER) {
                return this.getImageFor(((EObject)element).eContainer());
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex >= this.columns.size()) {
            return "<index out of bounds>";
        }
        EObject eObject = (EObject)element;
        ColumnDescription columnDescription = this.columns.get(columnIndex);
        switch (columnDescription.getType()) {
            case DEFAULT_LABEL: {
                return this.getTextFor(element);
            }
            case METACLASS_NAME: {
                EClass eClass = eObject.eClass();
                if (eClass != null) {
                    return eClass.getName();
                }
                return "<none>";
            }
            case ATTRIBUTE: {
                EAttribute attribute = columnDescription.getAttribute();
                if (!eObject.eClass().getEAllAttributes().contains((Object)attribute)) {
                    return "N/A";
                }
                Object attrValue = eObject.eGet((EStructuralFeature)attribute);
                if (attrValue == null) {
                    return "null";
                }
                return Util.truncateBeforeNewline(attrValue.toString());
            }
            case REFERENCE: {
                EReference reference = columnDescription.getReference();
                if (!eObject.eClass().getEAllReferences().contains((Object)reference)) {
                    return "N/A";
                }
                Object refValue = eObject.eGet((EStructuralFeature)reference);
                if (refValue == null) {
                    return "null";
                }
                if (reference.isMany()) {
                    EList list = (EList)refValue;
                    if (list.size() == 1) {
                        return this.getTextFor(list.get(0));
                    }
                    return "(" + list.size() + ")";
                }
                return this.getTextFor(refValue);
            }
            case ECONTAINER: {
                return this.getTextFor(((EObject)element).eContainer());
            }
        }
        return "<unexpected column type>";
    }
}

