/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.editors.table;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;

public abstract class TableSorter
extends ViewerComparator {
    public static final int ASCENDING = -1;
    public static final int NONE = 0;
    public static final int DESCENDING = 1;
    private int direction = 0;
    private TableViewerColumn column;
    private TableViewer viewer;

    public TableSorter(TableViewer viewer, TableViewerColumn column) {
        this.column = column;
        this.viewer = viewer;
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableSorter.this.columnClicked();
            }
        });
    }

    private void columnClicked() {
        if (this.viewer.getComparator() == null || this.viewer.getComparator() != this) {
            this.setSorting(1);
            return;
        }
        switch (this.direction) {
            case 1: {
                this.setSorting(-1);
                break;
            }
            case -1: {
                this.setSorting(0);
                break;
            }
            case 0: {
                this.setSorting(1);
            }
        }
    }

    public void setSorting(int direction) {
        this.direction = direction;
        Table table = this.viewer.getTable();
        switch (direction) {
            case 1: {
                table.setSortColumn(this.column.getColumn());
                table.setSortDirection(128);
                this.viewer.setComparator((ViewerComparator)this);
                break;
            }
            case -1: {
                table.setSortColumn(this.column.getColumn());
                table.setSortDirection(1024);
                this.viewer.setComparator((ViewerComparator)this);
                this.viewer.refresh();
                break;
            }
            case 0: {
                table.setSortColumn(null);
                table.setSortDirection(0);
                this.viewer.setComparator(null);
            }
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.direction * this.doCompare(viewer, e1, e2);
    }

    protected abstract int doCompare(Viewer var1, Object var2, Object var3);
}

