/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.extensions.naming;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmt.modisco.common.editor.MoDiscoEditorPlugin;
import org.eclipse.gmt.modisco.common.editor.extensions.AbstractRegistry;
import org.eclipse.gmt.modisco.common.editor.extensions.naming.FilteredNameProvider;
import org.eclipse.gmt.modisco.common.editor.extensions.naming.NameProvider;
import org.eclipse.gmt.modisco.common.editor.util.EMFUtil;

public class NameProvidersRegistry
extends AbstractRegistry {
    private static final String METACLASS_ELEMENT = "metaclass";
    private static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.gmt.modisco.common.editor";
    private static final String EXTENSION_POINT_NAME = "naming";
    private static final String METAMODEL_ID_ATTRIBUTE = "id";
    private static final String METAMODEL_ELEMENT = "metamodel";
    private static final String NAME_PROVIDER_ELEMENT = "nameProvider";
    private static final String NAME_PROVIDER_CLASS = "class";
    private static final String FILTER_ELEMENT = "filter";
    private static final String METACLASS_NAME_ATTRIBUTE = "name";
    private static NameProvidersRegistry instance = null;
    private Map<String, List<FilteredNameProvider>> nameProviders = new HashMap<String, List<FilteredNameProvider>>();

    public static NameProvidersRegistry getInstance() {
        if (instance == null) {
            instance = new NameProvidersRegistry();
        }
        return instance;
    }

    public String getName(EObject eObject) {
        EClass eClass = eObject.eClass();
        if (eClass == null) {
            return null;
        }
        String metaclassQualifiedName = EMFUtil.getMetaclassQualifiedName(eClass);
        EPackage ePackage = eClass.getEPackage();
        if (ePackage == null) {
            return null;
        }
        String nsURI = ePackage.getNsURI();
        List<FilteredNameProvider> filteredNameProviders = this.nameProviders.get(nsURI);
        if (filteredNameProviders == null && (filteredNameProviders = this.nameProviders.get("*")) == null) {
            return null;
        }
        for (FilteredNameProvider filteredNameProvider : filteredNameProviders) {
            String name;
            if (!filteredNameProvider.filter(metaclassQualifiedName) || (name = filteredNameProvider.getName(eObject)) == null) continue;
            return name;
        }
        return null;
    }

    public NameProvidersRegistry() {
        IExtension[] extensions;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configurationElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configurationElements = extension.getConfigurationElements();
            int n3 = configurationElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                String name = configurationElement.getName();
                if (name.equalsIgnoreCase(METAMODEL_ELEMENT)) {
                    this.readMetamodelElement(configurationElement);
                } else {
                    NameProvidersRegistry.logUnknownElement(configurationElement);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void readMetamodelElement(IConfigurationElement configurationElement) {
        IConfigurationElement[] children;
        String metamodelId = configurationElement.getAttribute(METAMODEL_ID_ATTRIBUTE);
        if (metamodelId == null) {
            NameProvidersRegistry.logMissingAttribute(configurationElement, METAMODEL_ID_ATTRIBUTE);
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = children = configurationElement.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String name = child.getName();
            if (name.equalsIgnoreCase(NAME_PROVIDER_ELEMENT)) {
                this.readNameProviderElement(child, metamodelId);
            } else {
                NameProvidersRegistry.logUnknownElement(configurationElement);
            }
            ++n2;
        }
    }

    private void readNameProviderElement(IConfigurationElement configurationElement, String metamodelId) {
        Object nameProviderObject;
        HashSet<String> filteredMetaclasses = null;
        IConfigurationElement[] filterElements = configurationElement.getChildren(FILTER_ELEMENT);
        if (filterElements.length > 0) {
            IConfigurationElement[] metaclassElements;
            IConfigurationElement[] iConfigurationElementArray = metaclassElements = filterElements[0].getChildren(METACLASS_ELEMENT);
            int n = metaclassElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement metaclassElement = iConfigurationElementArray[n2];
                String metaclassName = metaclassElement.getAttribute(METACLASS_NAME_ATTRIBUTE);
                if (metaclassName != null) {
                    if (filteredMetaclasses == null) {
                        filteredMetaclasses = new HashSet<String>();
                    }
                    filteredMetaclasses.add(metaclassName);
                }
                ++n2;
            }
        }
        final HashSet<String> fFilteredMetaclasses = filteredMetaclasses;
        try {
            nameProviderObject = configurationElement.createExecutableExtension(NAME_PROVIDER_CLASS);
        }
        catch (CoreException e) {
            MoDiscoEditorPlugin.INSTANCE.log((Object)e);
            return;
        }
        if (nameProviderObject == null) {
            NameProvidersRegistry.logMissingAttribute(configurationElement, NAME_PROVIDER_CLASS);
            return;
        }
        List<FilteredNameProvider> filteredNameProviders = this.nameProviders.get(metamodelId);
        if (filteredNameProviders == null) {
            filteredNameProviders = new ArrayList<FilteredNameProvider>();
        }
        if (nameProviderObject instanceof FilteredNameProvider) {
            final FilteredNameProvider filteredNameProvider = (FilteredNameProvider)nameProviderObject;
            filteredNameProviders.add(new FilteredNameProvider(){

                public String getName(EObject eObject) {
                    return filteredNameProvider.getName(eObject);
                }

                public boolean filter(String metaclass) {
                    if (fFilteredMetaclasses != null && !fFilteredMetaclasses.contains(metaclass)) {
                        return false;
                    }
                    return filteredNameProvider.filter(metaclass);
                }
            });
        } else if (nameProviderObject instanceof NameProvider) {
            final NameProvider nameProvider = (NameProvider)nameProviderObject;
            FilteredNameProvider filteredNameProvider = new FilteredNameProvider(){

                public String getName(EObject eObject) {
                    return nameProvider.getName(eObject);
                }

                public boolean filter(String metaclass) {
                    if (fFilteredMetaclasses == null) {
                        return true;
                    }
                    return fFilteredMetaclasses.contains(metaclass);
                }
            };
            filteredNameProviders.add(filteredNameProvider);
        } else {
            NameProvidersRegistry.logError(configurationElement, "Given class is not a NameProvider");
        }
        this.nameProviders.put(metamodelId, filteredNameProviders);
    }
}

