/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.kdm.uml2converter.popup.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmt.modisco.common.core.logging.AtlLogHandler;
import org.eclipse.gmt.modisco.kdm.uml2converter.KDMtoUML2Converter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ConvertWithCustomTransformation
implements IObjectActionDelegate {
    protected final Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    protected IFile kdmFile;
    private Shell shell;
    private IWorkbenchPart workbench;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.workbench = targetPart;
    }

    public void run(IAction action) {
        final String kdmModelPath = this.kdmFile.getLocation().toString();
        final IPath umlModelPath = this.kdmFile.getLocation().removeFileExtension().addFileExtension("uml");
        String customTransformation = "";
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.shell, (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator(null);
        dialog.setAllowMultiple(false);
        dialog.setTitle("Transformation Selection");
        dialog.setMessage("Select transformation to use");
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return ((IFile)element).getFileExtension().equals("asm");
                }
                return true;
            }
        });
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            if (elements.length == 1) {
                customTransformation = ((IResource)elements[0]).getLocation().toString();
            }
        } else {
            return;
        }
        try {
            final URL customTransformationUrl = new URL("file:///" + customTransformation);
            Job job = new Job("transform into: " + umlModelPath.lastSegment()){

                /*
                 * Loose catch block
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    AtlLogHandler logHandler = new AtlLogHandler(String.valueOf(umlModelPath.toString()) + ".log");
                    ConvertWithCustomTransformation.this.logger.addHandler((Handler)logHandler);
                    KDMtoUML2Converter transfo = new KDMtoUML2Converter();
                    URI outputURI = URI.createFileURI((String)umlModelPath.toString());
                    transfo.getUML2ModelFromKDMModelWithCustomTransformation(URI.createFileURI((String)kdmModelPath), false, customTransformationUrl, outputURI);
                    IStatus iStatus = Status.OK_STATUS;
                    try {
                        ConvertWithCustomTransformation.this.logger.removeHandler((Handler)logHandler);
                        logHandler.close();
                        ConvertWithCustomTransformation.this.kdmFile.getParent().refreshLocal(1, null);
                    }
                    catch (Exception exception) {}
                    return iStatus;
                    catch (Exception exception) {
                        IStatus iStatus2;
                        try {
                            iStatus2 = Status.CANCEL_STATUS;
                        }
                        catch (Throwable throwable) {
                            try {
                                ConvertWithCustomTransformation.this.logger.removeHandler((Handler)logHandler);
                                logHandler.close();
                                ConvertWithCustomTransformation.this.kdmFile.getParent().refreshLocal(1, null);
                            }
                            catch (Exception exception2) {}
                            throw throwable;
                        }
                        try {
                            ConvertWithCustomTransformation.this.logger.removeHandler((Handler)logHandler);
                            logHandler.close();
                            ConvertWithCustomTransformation.this.kdmFile.getParent().refreshLocal(1, null);
                        }
                        catch (Exception exception3) {}
                        return iStatus2;
                    }
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            try {
                                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                                IFile ifile = root.getFileForLocation((this).ConvertWithCustomTransformation.this.kdmFile.getLocation().removeFileExtension().addFileExtension("uml"));
                                if (ifile.exists()) {
                                    IWorkbenchPage page = ConvertWithCustomTransformation.this.workbench.getSite().getPage();
                                    IDE.openEditor((IWorkbenchPage)page, (IFile)ifile);
                                }
                            }
                            catch (PartInitException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            });
            job.schedule();
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Problem with transformation file " + customTransformation);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.kdmFile = (IFile)((IStructuredSelection)selection).getFirstElement();
    }
}

