/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.gmt.modisco.workflow.MoDiscoWorkflowLaunchConstants;
import org.eclipse.gmt.modisco.workflow.WorkflowExecutionInterface;
import org.eclipse.gmt.modisco.workflow.WorkflowModelInterface;
import org.eclipse.gmt.modisco.workflow.actions.LaunchDriversWizard;
import org.eclipse.gmt.modisco.workflow.controller.ControllerDriverPage;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Element;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.ModiscoworkflowFactory;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.ModiscoworkflowPackage;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Work;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameter;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameterStringListValue;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameterStringValue;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameterValue;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Workflow;
import org.eclipse.gmt.modisco.workflow.ui.common.AdditionalButtonsComposite;
import org.eclipse.gmt.modisco.workflow.ui.common.CreatePluginProject;
import org.eclipse.jdt.core.JavaConventions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerWorkflowTransformation {
    private AdditionalButtonsComposite additionalButton;
    private Map<String, WorkflowModelInterface> workflowInterfaceMap;
    private Map<String, WorkflowExecutionInterface> workflowExecutionInterfaceMap;
    private LaunchDriversWizard wizardDrivers;
    private ControllerDriverPage controllerDriver;
    private int editionIndice;
    private LaunchGroupExtension group;
    private String currentIdWorkflow;
    private String nameRoot;

    public ControllerWorkflowTransformation(String idWorkflow, String nameRoot) {
        this.nameRoot = nameRoot;
        this.workflowExecutionInterfaceMap = new HashMap<String, WorkflowExecutionInterface>();
        this.workflowInterfaceMap = new HashMap<String, WorkflowModelInterface>();
        this.controllerDriver = new ControllerDriverPage();
        this.wizardDrivers = new LaunchDriversWizard(this, this.controllerDriver);
        this.currentIdWorkflow = idWorkflow;
        this.initializeWorkflow();
    }

    public void newElement() {
        this.wizardDrivers.run(null, Constants.addMode);
        this.refresh(-1);
    }

    public Constants editElement(int index) {
        Constants status = Constants.Ok;
        this.editionIndice = index;
        Element modiscoWork = this.getComponent(index);
        if (modiscoWork != null) {
            if (!modiscoWork.getType().equals(MoDiscoWorkflowLaunchConstants.launchTypeMoDiscoWorkflow)) {
                ILaunchConfiguration conf = this.getLaunchConfigurationFromName(modiscoWork.getName());
                ILaunchConfigurationWorkingCopy config = null;
                try {
                    config = conf.getWorkingCopy();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (config != null) {
                    this.controllerDriver.setConfigurationEdition(config);
                    this.controllerDriver.setTypeEdition(modiscoWork.getType());
                    this.wizardDrivers.run(null, Constants.editMode);
                } else {
                    status = Constants.LaunchConfigurationNotFound;
                }
            } else {
                status = Constants.MoDiscoWorkflowSelected;
            }
        }
        this.refresh(index);
        return status;
    }

    public void removeFromWorkflow(int tableIndex) {
        List<Element> modiscoWorkList = this.getAllMoDiscoElement();
        Element modisco = modiscoWorkList.get(tableIndex);
        this.workflowInterfaceMap.get(this.currentIdWorkflow).removeComponent(tableIndex);
        this.updateAllElementIndex(modisco.getIndex());
        this.refresh(-1);
    }

    private void updateAllElementIndex(int elementIndexDeleted) {
        int i = 0;
        for (Element component : this.getAllMoDiscoElement()) {
            if (component.getIndex() > elementIndexDeleted) {
                Element modisco = (Element)this.workflowInterfaceMap.get(this.currentIdWorkflow).getComponent(i);
                modisco.setIndex(modisco.getIndex() - 1);
                this.setComponent(i, modisco);
            }
            ++i;
        }
    }

    public void removeFromLauncher(List<Integer> indexList) {
        try {
            ILaunchConfigurationWorkingCopy wc;
            Element modiscoWork = this.getComponent(indexList.get(0));
            ILaunchConfiguration config = this.getLaunchConfigurationFromName(modiscoWork.getName());
            if (config.exists() && (wc = config.getWorkingCopy()) != null) {
                wc.getOriginal().delete();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        for (int index : indexList) {
            this.removeFromWorkflow(index);
        }
        this.refresh(-1);
    }

    public void upElement(int tableIndex) {
        this.workflowInterfaceMap.get(this.currentIdWorkflow).upMoDisoWork(tableIndex);
    }

    public void downElement(int tableIndex) {
        this.workflowInterfaceMap.get(this.currentIdWorkflow).downMoDiscoWork(tableIndex);
    }

    public void loadElement() {
        this.wizardDrivers.run(null, Constants.loadMode);
        this.refresh(-1);
    }

    public void addElement(String type, int index, String name, boolean refresh) {
        Element modisco;
        boolean loop = false;
        int indexLocal = index;
        if (indexLocal == -1) {
            indexLocal = this.getAllMoDiscoElement().size();
        }
        if (type.equals(MoDiscoWorkflowLaunchConstants.launchTypeMoDiscoWorkflow)) {
            modisco = ModiscoworkflowFactory.eINSTANCE.createWorkflow();
            modisco.getElements().addAll(this.createElementsOfWorkflow(name, type));
            loop = this.verifyLoops((List<Element>)((Workflow)modisco).getElements(), this.nameRoot);
        } else {
            modisco = ModiscoworkflowFactory.eINSTANCE.createWork();
            List<WorkParameter> parameters = this.controllerDriver.getDriverFromLaunchType(type).getParameters(this.getLaunchConfigurationFromName(name));
            if (parameters != null) {
                ((Work)modisco).getParameters().clear();
                ((Work)modisco).getParameters().addAll(parameters);
            }
        }
        modisco.setIndex(indexLocal);
        modisco.setName(name);
        modisco.setType(type);
        if (!loop && modisco.getName() != this.nameRoot) {
            this.workflowInterfaceMap.get(this.currentIdWorkflow).addComponentWorkflow(modisco);
            if (refresh) {
                this.refresh(-1);
            }
        } else {
            this.additionalButton.dialogLoop();
        }
    }

    private boolean verifyLoops(List<Element> elements, String name) {
        boolean loop = false;
        for (Element elmt : elements) {
            if (!(elmt instanceof Workflow)) continue;
            if (elmt.getName().equals(name)) {
                loop = true;
                break;
            }
            loop = this.verifyLoops((List<Element>)((Workflow)elmt).getElements(), name);
        }
        return loop;
    }

    private void initializeWorkflow() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.gmt.modisco.workflowtype");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals("workflowCore")) {
                    try {
                        this.workflowInterfaceMap.put(extension.getUniqueIdentifier(), (WorkflowModelInterface)element.createExecutableExtension("class"));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                if (element.getName().equals("workflowExecution")) {
                    try {
                        this.workflowExecutionInterfaceMap.put(extension.getUniqueIdentifier(), (WorkflowExecutionInterface)element.createExecutableExtension("class"));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void refresh(int index) {
        this.additionalButton.getTable().removeAll();
        List<Element> modiscoWorkList = this.getAllMoDiscoElement();
        for (Element component : modiscoWorkList) {
            this.additionalButton.createItemTable(component.getName(), component.getType());
        }
        if (index != -1) {
            this.additionalButton.getTable().select(index);
        } else {
            this.additionalButton.getTable().select(this.additionalButton.getTable().getItemCount() - 1);
        }
        this.additionalButton.refreshTable();
    }

    public Element getComponent(int tableIndex) {
        return (Element)this.workflowInterfaceMap.get(this.currentIdWorkflow).getComponent(tableIndex);
    }

    private void setComponent(int index, Element modiscoWork) {
        this.workflowInterfaceMap.get(this.currentIdWorkflow).setComponent(index, modiscoWork);
    }

    public List<Element> getAllMoDiscoElement() {
        List<EObject> listComponent;
        List<EObject> listTmp = listComponent = this.workflowInterfaceMap.get(this.currentIdWorkflow).getAllComponents();
        ArrayList<Element> modiscoList = new ArrayList<Element>();
        for (Element element : listTmp) {
            modiscoList.add(this.createElement(this.getLaunchConfigurationFromName(element.getName()), element.getName(), element.getIndex(), element.getType()));
        }
        return modiscoList;
    }

    public void performFinishEditTransformation(String transformationName) {
        Element modiscoElement = this.getComponent(this.editionIndice);
        modiscoElement.setName(transformationName);
        if (modiscoElement instanceof Work) {
            List<WorkParameter> parameters = this.controllerDriver.getDriverFromLaunchType(modiscoElement.getType()).getParameters(this.getLaunchConfigurationFromName(modiscoElement.getName()));
            if (parameters != null) {
                ((Work)modiscoElement).getParameters().clear();
                ((Work)modiscoElement).getParameters().addAll(parameters);
            }
        } else {
            this.updateElementsOfWorkflow(((Workflow)modiscoElement).getElements());
        }
        this.setComponent(modiscoElement.getIndex(), modiscoElement);
    }

    private void updateElementsOfWorkflow(EList<Element> elements) {
        for (Element elmt : elements) {
            if (elmt instanceof Work) {
                List<WorkParameter> parameters = this.controllerDriver.getDriverFromLaunchType(elmt.getType()).getParameters(this.getLaunchConfigurationFromName(elmt.getName()));
                if (parameters == null) continue;
                ((Work)elmt).getParameters().clear();
                ((Work)elmt).getParameters().addAll(parameters);
                continue;
            }
            this.updateElementsOfWorkflow(((Workflow)elmt).getElements());
        }
    }

    public String allComponentsHaveConfiguration() {
        String transformationName = null;
        for (Element modiscoWork : this.getAllMoDiscoElement()) {
            if (modiscoWork == null) continue;
            ILaunchConfiguration config = this.getLaunchConfigurationFromName(modiscoWork.getName());
            if (config == null) {
                transformationName = modiscoWork.getName();
                break;
            }
            if (config.exists()) continue;
            transformationName = modiscoWork.getName();
            break;
        }
        return transformationName;
    }

    public void saveWorkflowResource(ILaunchConfigurationWorkingCopy configuration, boolean onlyLaunch) {
        this.nameRoot = configuration.getName();
        this.workflowInterfaceMap.get(this.currentIdWorkflow).save(configuration, onlyLaunch);
    }

    public void moveWorkflowResource(String path) {
        this.workflowInterfaceMap.get(this.currentIdWorkflow).moveResource(path);
    }

    public void initializationWorkflowResource(ILaunchConfiguration configuration, String path) {
        WorkflowModelInterface model = this.workflowInterfaceMap.get(this.currentIdWorkflow);
        model.initialization(configuration, path);
        if (!this.currentIdWorkflow.equals(MoDiscoWorkflowLaunchConstants.idMinimaliste)) {
            this.workflowInterfaceMap.get(this.currentIdWorkflow).synchronization(this.getAllMoDiscoElement());
        }
    }

    public void removeResource(String resourcePath) {
        this.workflowInterfaceMap.get(this.currentIdWorkflow).removeResource(resourcePath);
    }

    public List<WorkParameter> getAllParameterOfDriver(int tableIndex) {
        List<WorkParameter> parameters = null;
        Element modisco = this.getComponent(tableIndex);
        ILaunchConfiguration config = this.getLaunchConfigurationFromName(modisco.getName());
        if (config != null) {
            ILaunchConfigurationWorkingCopy copy = null;
            try {
                copy = config.getWorkingCopy();
            }
            catch (CoreException e) {
                System.err.println("getAllParameterOfDriver: Not copy found for LaunchConfiguration");
                e.printStackTrace();
            }
            parameters = this.controllerDriver.getDriverFromLaunchType(modisco.getType()).getParameters((ILaunchConfiguration)copy);
        }
        return parameters;
    }

    private ILaunchConfiguration getLaunchConfigurationFromName(String configName) {
        ILaunchConfiguration configuration = null;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getName().equals(configName)) {
                    configuration = config;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return configuration;
    }

    public void changeWorkflowEngine(ILaunchConfigurationWorkingCopy configuration) {
        String newId = MoDiscoWorkflowLaunchConstants.idMinimaliste;
        try {
            newId = configuration.getAttribute(MoDiscoWorkflowLaunchConstants.idWorkflow, MoDiscoWorkflowLaunchConstants.idMinimaliste);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (!newId.equals(this.currentIdWorkflow)) {
            List<Element> listMoDisco = this.getAllMoDiscoElement();
            String resourcePath = null;
            if (!configuration.isLocal()) {
                IPath path = configuration.getFile().getLocation().removeLastSegments(1).append(configuration.getName()).addFileExtension("workflow");
                resourcePath = path.toString();
            } else {
                resourcePath = Activator.getDefault().getStateLocation().append(configuration.getName()).addFileExtension("workflow").toString();
            }
            if (newId.equals(MoDiscoWorkflowLaunchConstants.idMinimaliste)) {
                this.removeResource(resourcePath);
                configuration.removeAttribute(MoDiscoWorkflowLaunchConstants.moDiscoWorkNumber);
                configuration.removeAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListSerialize);
                configuration.removeAttribute(MoDiscoWorkflowLaunchConstants.resourcePath);
            } else {
                this.currentIdWorkflow = newId;
                configuration.removeAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist);
            }
            this.currentIdWorkflow = newId;
            this.initializationWorkflowResource(configuration.getOriginal(), resourcePath);
            for (Element modisco : listMoDisco) {
                this.addElement(modisco.getType(), modisco.getIndex(), modisco.getName(), false);
            }
            this.saveWorkflowResource(configuration, false);
        }
    }

    public void exportWorkflow(ILaunchConfiguration configuration, String outputPath) {
        this.workflowInterfaceMap.get(this.currentIdWorkflow).exportWorkflow(configuration, outputPath);
    }

    public void exportMoDiscoWorkflowToDiscovererProject(String projectName, String symbolicName, String basePackageName) {
        try {
            URI uri = URI.createFileURI((String)Activator.getDefault().getStateLocation().append("tmp").toString());
            Resource res = this.createResourceExport(projectName, symbolicName, basePackageName, uri);
            new CreatePluginProject(res);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void exportInternalModel(String outputPath) {
        Path p = new Path(outputPath);
        p = p.append(this.nameRoot).addFileExtension("modiscoworkflow");
        URI uri = URI.createFileURI((String)p.toString());
        this.createResourceExport(this.nameRoot, this.nameRoot, this.nameRoot, uri);
    }

    public IStatus verifyNameToExportDiscoverer() {
        IStatus status = null;
        for (Element modiscoWork : this.getAllMoDiscoElement()) {
            status = JavaConventions.validateIdentifier((String)modiscoWork.getName(), (String)"org.eclipse.jdt.core.compiler.source", (String)"org.eclipse.jdt.core.compiler.compliance");
            if (!status.isOK()) break;
        }
        return status;
    }

    private Resource createResourceExport(String name, String symbolicName, String basePackageName, URI uri) {
        Resource resource = null;
        ModiscoworkflowPackage.eINSTANCE.eClass();
        Workflow workflow = ModiscoworkflowFactory.eINSTANCE.createWorkflow();
        ResourceSetImpl resSet = new ResourceSetImpl();
        resource = resSet.createResource(uri);
        workflow.setName(this.nameRoot);
        workflow.setPackageBase(basePackageName);
        workflow.setSymbolicName(symbolicName);
        List<Element> elements = this.getAllMoDiscoElement();
        workflow.getElements().addAll(elements);
        resource.getContents().add((Object)workflow);
        try {
            resource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resource;
    }

    private Collection<? extends Element> createElementsOfWorkflow(String name, String type) {
        WorkParameterStringListValue elementList;
        ArrayList<Element> elements = new ArrayList<Element>();
        List<WorkParameter> parameters = this.controllerDriver.getDriverFromLaunchType(type).getParameters(this.getLaunchConfigurationFromName(name));
        HashMap<String, WorkParameterValue> mapParamters = new HashMap<String, WorkParameterValue>();
        for (WorkParameter parameter : parameters) {
            mapParamters.put(parameter.getName(), parameter.getValue());
        }
        WorkParameterStringValue idValue = (WorkParameterStringValue)mapParamters.get(MoDiscoWorkflowLaunchConstants.idWorkflow);
        if (idValue.getValue().equals(MoDiscoWorkflowLaunchConstants.idMinimaliste)) {
            elementList = (WorkParameterStringListValue)mapParamters.get(MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist);
            EList<String> stringList = elementList.getValue();
            int i = 0;
            while (i < stringList.size()) {
                ILaunchConfiguration configuration = this.getLaunchConfigurationFromName((String)stringList.get(i));
                elements.add(this.createElement(configuration, (String)stringList.get(i), Integer.valueOf((String)stringList.get(i + 1)), (String)stringList.get(i + 2)));
                i += 3;
            }
        } else {
            elementList = (WorkParameterStringListValue)mapParamters.get(MoDiscoWorkflowLaunchConstants.moDiscoListSerialize);
            EList<String> stringList = elementList.getValue();
            int index = 0;
            for (String elmt : stringList) {
                ILaunchConfiguration configuration = this.getLaunchConfigurationFromName(elmt.substring(0, elmt.indexOf(";")));
                elements.add(this.createElement(configuration, elmt.substring(0, elmt.indexOf(";")), index, elmt.substring(elmt.lastIndexOf(";"))));
                ++index;
            }
        }
        return elements;
    }

    private Element createElement(ILaunchConfiguration configuration, String name, int index, String type) {
        Element createdElement;
        block5: {
            createdElement = null;
            if (configuration != null) {
                try {
                    String configType = configuration.getType().getIdentifier();
                    if (configType.equals(MoDiscoWorkflowLaunchConstants.launchTypeMoDiscoWorkflow)) {
                        Workflow workflow = ModiscoworkflowFactory.eINSTANCE.createWorkflow();
                        workflow.setIndex(index);
                        workflow.setName(configuration.getName());
                        workflow.setType(configType);
                        workflow.getElements().addAll(this.createElementsOfWorkflow(configuration.getName(), configType));
                        createdElement = workflow;
                        break block5;
                    }
                    Work work = ModiscoworkflowFactory.eINSTANCE.createWork();
                    work.setIndex(index);
                    work.setName(configuration.getName());
                    work.setType(configType);
                    work.getParameters().addAll(this.controllerDriver.getDriverFromLaunchType(configType).getParameters(configuration));
                    createdElement = work;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                Work work = ModiscoworkflowFactory.eINSTANCE.createWork();
                work.setIndex(index);
                work.setName(name);
                work.setType(type);
                createdElement = work;
            }
        }
        return createdElement;
    }

    public void setAdditionnalButton(AdditionalButtonsComposite additionalButton) {
        this.additionalButton = additionalButton;
    }

    public LaunchGroupExtension getGroup() {
        return this.group;
    }

    public void setGroup(LaunchGroupExtension group) {
        this.group = group;
    }

    public WorkflowExecutionInterface getWorkflowExecutionInterface(String id) {
        return this.workflowExecutionInterfaceMap.get(id);
    }

    public String getIdWorkflowExecution() {
        return this.currentIdWorkflow;
    }
}

