/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.defaultengine;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.workflow.DriverExecutionInterface;
import org.eclipse.gmt.modisco.workflow.DriverInterface;
import org.eclipse.gmt.modisco.workflow.WorkflowExecutionInterface;
import org.eclipse.gmt.modisco.workflow.defaultengine.WorkflowModelImpl;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Element;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class WorkflowExecutionImpl
implements WorkflowExecutionInterface {
    public void launchWorkflow(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) {
        List<EObject> listComponent;
        WorkflowModelImpl workflowImpl = new WorkflowModelImpl();
        workflowImpl.initialization(configuration, null);
        List<EObject> listModiscoWork = listComponent = workflowImpl.getAllComponents();
        for (Element element : listModiscoWork) {
            DriverExecutionInterface driver = this.findPlugIn(element.getType());
            if (driver != null) {
                ILaunchConfiguration conf = this.getLaunchConfigurationFromName(element.getName());
                ILaunchConfigurationWorkingCopy config = null;
                try {
                    config = conf.getWorkingCopy();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                driver.launch(config, launch);
                continue;
            }
            MessageDialog.openError((Shell)new Shell(), (String)"Plug-in not found", (String)("The plug-in with the type " + element.getType() + " not found"));
        }
    }

    private DriverExecutionInterface findPlugIn(String type) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.gmt.modisco.driver");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals("driverUI")) {
                    try {
                        DriverInterface driver = (DriverInterface)element.createExecutableExtension("class");
                        if (driver.getTypeLaunchConfig().equals(type)) {
                            return this.findExecutionPlugIn(extension.getUniqueIdentifier());
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private DriverExecutionInterface findExecutionPlugIn(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.gmt.modisco.driver");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (extension.getUniqueIdentifier().equals(id)) {
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals("execution")) {
                        try {
                            return (DriverExecutionInterface)element.createExecutableExtension("class");
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private ILaunchConfiguration getLaunchConfigurationFromName(String configName) {
        ILaunchConfiguration configuration = null;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getName().equals(configName)) {
                    configuration = config;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return configuration;
    }
}

