/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.DriverInterface;
import org.eclipse.gmt.modisco.workflow.controller.ControllerDriverPage;
import org.eclipse.gmt.modisco.workflow.ui.common.Common;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadLauncherPage
extends WizardPage {
    private Table launchersTable;
    private ControllerDriverPage controller;
    private HashMap<TableItem, ILaunchConfiguration> launchConfigurationMap;
    private Composite container;
    private TableItem[] itemsSelected = new TableItem[0];

    public TableItem[] getItemsSelected() {
        return this.itemsSelected;
    }

    protected LoadLauncherPage(String pageName, ControllerDriverPage controller) {
        super(pageName, pageName, null);
        this.setImageDescriptor(Activator.getImageDescriptor("icon/bigModiscoWorkflow.png"));
        this.controller = controller;
        this.launchConfigurationMap = new HashMap();
        this.setDescription("This wizard represents the list of the launcher loaded.");
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.launchersTable = new Table(this.container, 2562);
        this.launchersTable.setLayoutData((Object)gridData);
        this.launchersTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                LoadLauncherPage.this.itemsSelected = LoadLauncherPage.this.launchersTable.getSelection();
                LoadLauncherPage.this.setPageComplete(true);
            }
        });
        this.launchersTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                LoadLauncherPage.this.getWizard().performFinish();
                LoadLauncherPage.this.getShell().close();
            }
        });
        this.loadLauncher();
        this.initializeDialogUnits((Control)this.container);
        this.setControl((Control)this.container);
    }

    private void loadLauncher() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        HashMap<String, DriverInterface> driverList = this.controller.getMapNameDriver();
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration launch = iLaunchConfigurationArray[n2];
                for (Map.Entry<String, DriverInterface> entry : driverList.entrySet()) {
                    if (!entry.getValue().getTypeLaunchConfig().equals(launch.getType().getIdentifier())) continue;
                    TableItem item = new TableItem(this.launchersTable, 0);
                    item.setText(launch.getName());
                    item.setImage(Common.getInstance().retrieveImageDriver(entry.getValue().getTypeLaunchConfig()));
                    this.launchConfigurationMap.put(item, launch);
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.setMessage("Select your launcher");
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.getShell().setSize(400, 400);
            this.getShell().setLocation(Common.getInstance().centerShell(Display.getDefault(), this.getShell()));
        }
        super.setVisible(visible);
    }

    public HashMap<TableItem, ILaunchConfiguration> getLaunchConfigurationMap() {
        return this.launchConfigurationMap;
    }
}

