/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.core.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import org.eclipse.gmt.modisco.common.core.utils.FolderUtils;

public class FolderUtilsImpl
implements FolderUtils {
    private static boolean debug = false;
    private ConfigurationManagementFilter configurationManagementFilter = new ConfigurationManagementFilter();

    FolderUtilsImpl() {
    }

    public final void clearFolder(File dirtyFolder) {
        File[] files;
        assert (dirtyFolder != null);
        assert (dirtyFolder.exists());
        assert (dirtyFolder.isDirectory());
        File[] fileArray = files = dirtyFolder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.clearFolder(file);
            }
            file.delete();
            ++n2;
        }
    }

    public final boolean compareFolders(File folderSource, File folderTarget) {
        return this.compareFolders(folderSource, folderTarget, this.configurationManagementFilter);
    }

    public final boolean compareFolders(File folderSource, File folderTarget, FilenameFilter filter) {
        assert (folderSource != null && folderTarget != null);
        assert (folderSource.isDirectory() && folderTarget.isDirectory());
        boolean result = false;
        if (folderSource.equals(folderTarget)) {
            result = true;
        } else {
            result = this.recursiveCompareFolders(folderSource, folderTarget, filter);
            if (debug && !result) {
                System.err.println("folders " + folderSource.getName() + " and " + folderTarget.getName() + " are not equals.");
            }
        }
        return result;
    }

    public final boolean compareFiles(File source, File target) {
        assert (source.isFile() && target.isFile());
        boolean result = true;
        if (!source.getName().equals(target.getName())) {
            result = false;
        } else {
            try {
                BufferedReader sourceReader = new BufferedReader(new FileReader(source));
                BufferedReader targetReader = new BufferedReader(new FileReader(target));
                String sourceLine = sourceReader.readLine();
                String targetLine = targetReader.readLine();
                while (sourceLine != null && targetLine != null) {
                    result = result && sourceLine.equals(targetLine);
                    sourceLine = sourceReader.readLine();
                    targetLine = targetReader.readLine();
                }
                if (sourceLine != null || targetLine != null) {
                    result = false;
                    System.err.println("These files have not the same number of lines.");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                result = false;
            }
            catch (IOException iOException) {
                result = false;
            }
        }
        if (debug && result) {
            System.out.println("files " + source.getName() + " and " + target.getName() + " are equals.");
        }
        return result;
    }

    public final String getFileContent(File source) {
        StringBuilder result = new StringBuilder();
        try {
            BufferedReader sourceReader = new BufferedReader(new FileReader(source));
            String sourceLine = sourceReader.readLine();
            while (sourceLine != null) {
                result.append(sourceLine);
                result.append("\n");
                sourceLine = sourceReader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    private final boolean recursiveCompareFolders(File folderSource, File folderTarget, FilenameFilter filter) {
        File[] targetContents;
        if (debug) {
            System.err.println("comparison of " + folderSource.getName() + " and " + folderTarget.getName());
        }
        boolean result = true;
        File[] sourceContents = folderSource.listFiles(filter);
        if (sourceContents.length != (targetContents = folderTarget.listFiles(filter)).length) {
            result = false;
            if (debug) {
                System.err.println("folders " + folderSource.getName() + " and " + folderTarget.getName() + " have not the same number of childrens (" + sourceContents.length + ", " + targetContents.length + ")");
            }
        } else {
            File[] fileArray = sourceContents;
            int n = sourceContents.length;
            int n2 = 0;
            while (n2 < n) {
                File sourceContent = fileArray[n2];
                File targetContent = this.getCorrespondingTargetContent(sourceContent, targetContents);
                if (targetContent == null) {
                    result = false;
                    if (debug) {
                        System.err.println("There is no corresponding element in target folder for " + sourceContent.getName());
                    }
                } else if (sourceContent.isDirectory()) {
                    boolean bl = result = result && this.recursiveCompareFolders(sourceContent, targetContent, filter);
                    if (debug && !result) {
                        System.err.println("folders " + sourceContent.getName() + " and " + targetContent.getName() + " are not equals.");
                    }
                } else {
                    boolean bl = result = result && this.compareFiles(sourceContent, targetContent);
                    if (debug && !result) {
                        System.err.println("files " + sourceContent.getName() + " and " + targetContent.getName() + " are not equals.");
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private final File getCorrespondingTargetContent(File sourceContent, File[] targetContents) {
        File targetContent = null;
        File[] fileArray = targetContents;
        int n = targetContents.length;
        int n2 = 0;
        while (n2 < n) {
            File temp = fileArray[n2];
            if (sourceContent.getName().equals(temp.getName())) {
                targetContent = temp;
            }
            ++n2;
        }
        return targetContent;
    }

    public final void copyDirectory(File srcDir, File destDir) throws IOException {
        File[] filesList;
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        File[] fileArray = filesList = srcDir.listFiles();
        int n = filesList.length;
        int n2 = 0;
        while (n2 < n) {
            File src = fileArray[n2];
            File dest = new File(String.valueOf(destDir.getPath()) + File.separator + src.getName());
            if (src.isDirectory()) {
                this.copyDirectory(src, dest);
            } else {
                this.copyFile(src, dest);
            }
            ++n2;
        }
    }

    public final boolean copyFile(File source, File destination) {
        boolean resultat;
        block23: {
            resultat = false;
            FileInputStream sourceFile = null;
            FileOutputStream destinationFile = null;
            try {
                int nbLecture;
                destination.createNewFile();
                sourceFile = new FileInputStream(source);
                destinationFile = new FileOutputStream(destination);
                byte[] buffer = new byte[524288];
                while ((nbLecture = sourceFile.read(buffer)) != -1) {
                    destinationFile.write(buffer, 0, nbLecture);
                }
                resultat = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    if (sourceFile != null) {
                        sourceFile.close();
                    }
                    if (destinationFile != null) {
                        destinationFile.close();
                    }
                    break block23;
                }
                catch (Exception exception) {}
                break block23;
            }
            catch (IOException iOException) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (sourceFile != null) {
                            sourceFile.close();
                        }
                        if (destinationFile != null) {
                            destinationFile.close();
                        }
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    if (sourceFile != null) {
                        sourceFile.close();
                    }
                    if (destinationFile != null) {
                        destinationFile.close();
                    }
                    break block23;
                }
                catch (Exception exception) {}
                break block23;
            }
            try {
                if (sourceFile != null) {
                    sourceFile.close();
                }
                if (destinationFile != null) {
                    destinationFile.close();
                }
            }
            catch (Exception exception) {}
        }
        return resultat;
    }

    public final void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        this.clearFolder(directory);
        if (directory.list().length == 0 && !directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    private static class ConfigurationManagementFilter
    implements FilenameFilter {
        private String filterName = "CVS";

        private ConfigurationManagementFilter() {
        }

        public boolean accept(File dir, String name) {
            boolean result = false;
            if (!name.equals(this.filterName)) {
                result = true;
            }
            return result;
        }
    }
}

