/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Sbastien Minguet (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.j2se5.popup.actions;

import java.util.logging.Logger;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmt.modisco.common.core.logging.AtlLogHandler;
import org.eclipse.gmt.modisco.common.core.utils.Tools;
import org.eclipse.gmt.modisco.j2se5.J2SE5Discoverer;
import org.eclipse.gmt.modisco.j2se5.J2se5DiscovererInterface;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class FromJ2se5ToKDM implements IObjectActionDelegate {

	protected final Logger logger = Logger.getLogger(ATLLogger.LOGGER_ID);
	private IFile j2se5File = null;
	protected IPath path;
	private IWorkbenchPart workbench;
	/**
	 * Constructor for Action1.
	 */
	public FromJ2se5ToKDM() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.workbench = targetPart;
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		final String sourcePath = this.j2se5File.getLocation().toString();
		this.path = this.j2se5File.getLocation().removeFileExtension().addFileExtension("kdm");
		Job job = new Job("Transforming to kdm model") {
			@Override
			protected IStatus run(IProgressMonitor monitor) {
				IStatus result = null;
				AtlLogHandler logHandler = new AtlLogHandler(FromJ2se5ToKDM.this.path.toString() + ".log");
				FromJ2se5ToKDM.this.logger.addHandler(logHandler);
				try{
					J2se5DiscovererInterface disco = new J2SE5Discoverer();
					Resource j2se5Model = new XMIResourceImpl();
					j2se5Model.setURI(URI.createFileURI(sourcePath));
					
					Resource output = disco.getKDMModelFromJ2SE5Model(j2se5Model);
									
					String outputLocation = FromJ2se5ToKDM.this.path.toString();
					Tools.saveModel(output, outputLocation);

					result = Status.OK_STATUS;
				}catch (Exception e) {
					result = Status.CANCEL_STATUS;
				} finally {
					FromJ2se5ToKDM.this.logger.removeHandler(logHandler);
					logHandler.close();
					try {
						FromJ2se5ToKDM.this.j2se5File.getParent().refreshLocal(1, monitor);
					} catch (Exception e1) {
						//give up
					}	
				}
				return result;		
			}		
		};	
		
		//triggers opening of the kdm model as soon as it is saved
		job.addJobChangeListener(new JobChangeAdapter() {
			public void done(IJobChangeEvent event) {
				//access UI resources so that we can obtain the current eclipse workbench activePage
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						try {
							IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
							IFile ifile = root.getFileForLocation(FromJ2se5ToKDM.this.path);
							if (ifile.exists()) {
								IWorkbenchPage page = FromJ2se5ToKDM.this.workbench.getSite().getPage();
								//programmatically opens the kdm model using default editor (kdm analytics editor if present)
								IDE.openEditor(page, ifile);
							}
						} catch (PartInitException e) {
							e.printStackTrace();
						}
					}
				});
			}
		});
		
		job.schedule();
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		//If a j2se5 model file is selected then set it as the file to use
		this.j2se5File = (IFile)((IStructuredSelection)selection).getFirstElement();
	}
}
