/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire DUPE (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.infra.role.tests.samples;

import java.util.List;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.runtime.ModelQueryParameterValue;

public class GetSubClasses implements IJavaModelQuery {

	public Object evaluate(final EObject context,
			final List<ModelQueryParameterValue> parameterValues)
			throws ModelQueryExecutionException {
		if (!(context instanceof EClass)) {
			throw new ModelQueryExecutionException("Unexpected context type: " //$NON-NLS-1$
					+ context);
		}
		EList<EClass> result = new BasicEList<EClass>();
		EClass contextEClass = (EClass) context;
		TreeIterator<EObject> content = context.eResource().getAllContents();
		while (content.hasNext()) {
			EObject eObject = content.next();
			if (eObject instanceof EClass) {
				EClass currentEClass = (EClass) eObject;
				if (contextEClass.isSuperTypeOf(currentEClass)) {
					result.add(currentEClass);
				}
			}
		}
		return result;
	}

}
