/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.custom.ui.wizards;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gmt.modisco.infra.browser.custom.MetamodelView;
import org.eclipse.gmt.modisco.infra.browser.custom.emf.UicustomFactory;
import org.eclipse.gmt.modisco.infra.browser.custom.ui.Activator;
import org.eclipse.gmt.modisco.infra.browser.custom.ui.Messages;
import org.eclipse.gmt.modisco.infra.browser.custom.ui.controls.QuerySetsSelectionControl;
import org.eclipse.gmt.modisco.infra.browser.custom.ui.wizards.NewCustomizationFilePage;
import org.eclipse.gmt.modisco.infra.browser.custom.ui.wizards.SelectMetamodelsPage;
import org.eclipse.gmt.modisco.infra.browser.custom.ui.wizards.SelectQuerySetsPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewCustomizationWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection fSelection;
    private NewCustomizationFilePage newCustomizationFilePage;
    private SelectMetamodelsPage selectMetamodelsFilePage;
    private SelectQuerySetsPage selectQuerySetsPage;

    public NewCustomizationWizard() {
        this.setWindowTitle(Messages.NewCustomizationWizard_newBrowserCustomization);
    }

    public void addPages() {
        this.newCustomizationFilePage = new NewCustomizationFilePage(this.fSelection);
        this.addPage((IWizardPage)this.newCustomizationFilePage);
        this.selectMetamodelsFilePage = new SelectMetamodelsPage();
        this.addPage((IWizardPage)this.selectMetamodelsFilePage);
        this.selectQuerySetsPage = new SelectQuerySetsPage();
        this.addPage((IWizardPage)this.selectQuerySetsPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelection = selection;
    }

    public boolean performFinish() {
        IFile file = this.newCustomizationFilePage.createNewFile();
        if (file != null) {
            this.createCustomization(file);
            return true;
        }
        return false;
    }

    private void createCustomization(IFile file) {
        String[] selectedQuerySets;
        MetamodelView metamodelView = UicustomFactory.eINSTANCE.createMetamodelView();
        String selectedMetamodel = this.selectMetamodelsFilePage.getSelectedMetamodel();
        metamodelView.setMetamodelURI(selectedMetamodel);
        QuerySetsSelectionControl querySetsSelectionControl = this.selectQuerySetsPage.getQuerySetsSelectionControl();
        metamodelView.setAllQuerySetsAvailable(querySetsSelectionControl.getAllQuerySetsAvailable());
        String[] stringArray = selectedQuerySets = querySetsSelectionControl.getSelectedQuerySets();
        int n = selectedQuerySets.length;
        int n2 = 0;
        while (n2 < n) {
            String selectedQuerySet = stringArray[n2];
            metamodelView.getAvailableQuerySets().add((Object)selectedQuerySet);
            ++n2;
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uiCustom", new XMIResourceFactoryImpl());
        Resource resource = resourceSet.createResource(URI.createURI((String)file.getLocationURI().toString()));
        resource.getContents().add((Object)metamodelView);
        try {
            resource.save(null);
        }
        catch (IOException e) {
            Activator.logException(e);
        }
        try {
            file.refreshLocal(0, null);
        }
        catch (CoreException e) {
            Activator.logException(e);
        }
        try {
            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file, (String)"org.eclipse.gmt.modisco.infra.browser.custom.editor");
        }
        catch (Exception e) {
            Activator.logException(e);
        }
    }
}

