/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors;

import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.NavigationLocation;

public class BrowserNavigationLocation
extends NavigationLocation {
    private final String title;
    private String selectedMetaclass;
    private ITreeSelection treeSelection;

    public BrowserNavigationLocation(IEditorPart editorPart) {
        super(editorPart);
        this.title = editorPart.getTitle();
        this.selectedMetaclass = null;
        this.treeSelection = null;
    }

    public BrowserNavigationLocation(IEditorPart editorPart, String selectedMetaclass, ITreeSelection treeSelection) {
        super(editorPart);
        this.title = editorPart.getTitle();
        this.selectedMetaclass = selectedMetaclass;
        this.treeSelection = treeSelection;
    }

    public String getText() {
        if (this.selectedMetaclass != null) {
            return String.valueOf(this.title) + " - " + this.selectedMetaclass;
        }
        return this.title;
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        if (currentLocation == null) {
            return false;
        }
        if (currentLocation instanceof BrowserNavigationLocation) {
            BrowserNavigationLocation location = (BrowserNavigationLocation)currentLocation;
            if (!this.title.equals(location.title)) {
                return false;
            }
            if (this.selectedMetaclass == location.selectedMetaclass) {
                location.treeSelection = this.treeSelection;
                return true;
            }
            if (location.selectedMetaclass == null || location.selectedMetaclass == "") {
                location.selectedMetaclass = this.selectedMetaclass;
                location.treeSelection = this.treeSelection;
                return true;
            }
        }
        return false;
    }

    public void restoreLocation() {
        if (this.selectedMetaclass == null) {
            return;
        }
        IEditorPart editorPart = this.getEditorPart();
        if (editorPart instanceof EcoreBrowser) {
            EcoreBrowser editor = (EcoreBrowser)editorPart;
            editor.restoreLocation(this.selectedMetaclass, this.treeSelection);
        }
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void update() {
    }

    public void releaseState() {
        super.releaseState();
        this.treeSelection = null;
    }
}

