/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.core.ModelElementItem;
import org.eclipse.gmt.modisco.infra.browser.editors.CustomTreePainter;
import org.eclipse.gmt.modisco.infra.role.Role;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RoleTooltip {
    private static final String TREEITEM_DATA_KEY = "_TREEITEM";
    private Shell fTip = null;
    private Label fLabel = null;

    public static RoleTooltip create(Tree tree, CustomTreePainter customTreePainter) {
        return new RoleTooltip(tree, customTreePainter);
    }

    private RoleTooltip(Tree tree, CustomTreePainter customTreePainter) {
        tree.setToolTipText("");
        this.addTooltip(tree, customTreePainter);
    }

    private void addTooltip(final Tree tree, final CustomTreePainter customTreePainter) {
        Listener treeListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (RoleTooltip.this.fTip == null) break;
                        RoleTooltip.this.fTip.dispose();
                        RoleTooltip.this.fTip = null;
                        RoleTooltip.this.fLabel = null;
                        break;
                    }
                    case 32: {
                        Object data;
                        Display display = Display.getCurrent();
                        TreeItem item = null;
                        item = tree.getItem(new Point(event.x, event.y));
                        if (item == null || !((data = item.getData()) instanceof ModelElementItem)) break;
                        ModelElementItem modelElementItem = (ModelElementItem)data;
                        EObject eObject = modelElementItem.getEObject();
                        Rectangle bounds = item.getBounds();
                        int maxX = tree.getClientArea().width + tree.getHorizontalBar().getSelection();
                        List<CustomTreePainter.RoleToPaint> rolesToPaint = customTreePainter.getRolesToPaintFor(eObject, bounds.x, bounds.width, bounds.y, bounds.height, maxX);
                        Role role = RoleTooltip.this.findRoleAt(event.x, event.y, rolesToPaint);
                        if (role == null) break;
                        RoleTooltip.this.createTooltip(display, role.getName());
                        RoleTooltip.this.fLabel.setData(RoleTooltip.TREEITEM_DATA_KEY, (Object)item);
                        break;
                    }
                    default: {
                        MoDiscoBrowserPlugin.logError("Unhandled event");
                    }
                }
            }
        };
        tree.addListener(12, treeListener);
        tree.addListener(1, treeListener);
        tree.addListener(5, treeListener);
        tree.addListener(32, treeListener);
    }

    private void addMouseExitListener(final Label label) {
        Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = label.getShell();
                shell.dispose();
            }
        };
        label.addListener(7, labelListener);
    }

    private Role findRoleAt(int x, int y, List<CustomTreePainter.RoleToPaint> rolesToPaint) {
        for (CustomTreePainter.RoleToPaint roleToPaint : rolesToPaint) {
            Rectangle bounds = roleToPaint.getBounds();
            if (x < bounds.x || x >= bounds.x + bounds.width || y < bounds.y || y >= bounds.y + bounds.height) continue;
            return roleToPaint.getRole();
        }
        return null;
    }

    private void createTooltip(Display display, String text) {
        if (this.fTip != null && !this.fTip.isDisposed()) {
            this.fTip.dispose();
        }
        this.fTip = new Shell(display.getActiveShell(), 540676);
        this.fTip.setBackground(display.getSystemColor(29));
        FillLayout layout = new FillLayout();
        layout.marginWidth = 2;
        this.fTip.setLayout((Layout)layout);
        this.fLabel = new Label((Composite)this.fTip, 0);
        this.fLabel.setForeground(display.getSystemColor(28));
        this.fLabel.setBackground(display.getSystemColor(29));
        this.fLabel.setText(text);
        this.addMouseExitListener(this.fLabel);
        Point size = this.fTip.computeSize(-1, -1);
        Point pt = display.getCursorLocation();
        pt.y -= size.y + 10;
        Rectangle clientArea = Display.getCurrent().getClientArea();
        if (pt.x + size.x > clientArea.width) {
            pt.x = clientArea.width - size.x;
        }
        if (pt.y + size.y > clientArea.height) {
            pt.y = clientArea.height - size.y;
        }
        this.fTip.setBounds(pt.x, pt.y, size.x, size.y);
        this.fTip.setVisible(true);
    }
}

