/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.actions.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.gmt.modisco.java.actions.DiscoveryParametersBean;
import org.eclipse.gmt.modisco.java.actions.ui.Messages;
import org.eclipse.gmt.modisco.java.io.library.LibraryReaderOptions;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaWizardFirstPage
extends WizardPage {
    private Button btnMemberAnalyseJavaFiles;
    private Button btnFullAnalyseJavaFiles;
    private CheckboxTreeViewer dependenciesTree;
    private IJavaProject javaProject;
    private Button btnUseSource;
    private Button btnIncrementalMode;
    private Label textNumberElementsSelected;
    private Collection<Object> discoverableElements;
    private DiscoveryParametersBean discoveryParameters;
    private Text entryFilter;

    public JavaWizardFirstPage(IJavaProject javaProject, String pageName, Collection<Object> discoverableElements, DiscoveryParametersBean discoveryParameters) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(Messages.JavaWizardFirstPage_settingsLabel);
        this.javaProject = javaProject;
        this.discoverableElements = discoverableElements;
        this.discoveryParameters = discoveryParameters;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout formLayout = new GridLayout();
        formLayout.marginHeight = 10;
        formLayout.marginWidth = 10;
        composite.setLayout((Layout)formLayout);
        this.createDependenciesPanel(composite);
        this.createIncrementalPanel(composite);
        this.createJavaAnalysisLevelPanel(composite);
        this.createJavaFilterPanel(composite);
        this.refreshInformationLabel();
        this.validatePage();
        this.setControl((Control)composite);
    }

    private void createDependenciesPanel(Composite composite) {
        Group dependencies = new Group(composite, 0);
        dependencies.setText(Messages.JavaWizardFirstPage_dependencies);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        dependencies.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        dependencies.setLayoutData((Object)gridData);
        Label l = new Label((Composite)dependencies, 0);
        l.setText(Messages.JavaWizardFirstPage_selectProjects);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        l.setLayoutData((Object)gridData);
        this.dependenciesTree = new CheckboxTreeViewer((Composite)dependencies, 68356);
        this.dependenciesTree.setContentProvider((IContentProvider)new MyTreeContentProvider());
        this.dependenciesTree.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider());
        this.dependenciesTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (JavaWizardFirstPage.this.discoveryParameters.getElementsToDiscover().contains(element)) {
                    JavaWizardFirstPage.this.discoveryParameters.removeElementToDiscover(element);
                } else {
                    JavaWizardFirstPage.this.discoveryParameters.addElementToDiscover(element);
                }
                JavaWizardFirstPage.this.dependenciesTree.update(event.getElement(), null);
                JavaWizardFirstPage.this.refreshBtnUseSources();
                JavaWizardFirstPage.this.refreshInformationLabel();
                JavaWizardFirstPage.this.validatePage();
            }
        });
        this.dependenciesTree.getTree().setLinesVisible(false);
        this.dependenciesTree.getTree().setHeaderVisible(true);
        this.dependenciesTree.setInput(new Object());
        TreeItem[] treeItemArray = this.dependenciesTree.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeitem = treeItemArray[n2];
            this.recursiveCheckItem(treeitem);
            ++n2;
        }
        TreeViewerColumn column1 = new TreeViewerColumn((TreeViewer)this.dependenciesTree, 0);
        column1.getColumn().setWidth(400);
        column1.getColumn().setText(Messages.JavaWizardFirstPage_name);
        column1.setLabelProvider((CellLabelProvider)new JDTDelegateCellLabelProvider());
        TreeViewerColumn column2 = new TreeViewerColumn((TreeViewer)this.dependenciesTree, 0);
        column2.getColumn().setWidth(70);
        column2.getColumn().setText(Messages.JavaWizardFirstPage_useSources);
        column2.getColumn().setAlignment(0x1000000);
        column2.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Map<String, Object> options;
                boolean useSources;
                if (cell.getElement() instanceof IPackageFragmentRoot && JavaWizardFirstPage.this.discoveryParameters.getElementsToDiscover().contains(cell.getElement()) && (useSources = Boolean.TRUE.equals((options = JavaWizardFirstPage.this.discoveryParameters.getDiscoveryOptions(cell.getElement())).get(LibraryReaderOptions.USE_SOURCES.toString())))) {
                    cell.setText(Messages.JavaWizardFirstPage_useSourceOn);
                    return;
                }
                cell.setText("");
            }
        });
        this.dependenciesTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                JavaWizardFirstPage.this.refreshBtnUseSources();
            }
        });
        gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.dependenciesTree.getTree().setLayoutData((Object)gridData);
        this.btnUseSource = new Button((Composite)dependencies, 32);
        this.btnUseSource.setText(Messages.JavaWizardFirstPage_useSources);
        this.btnUseSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object elt;
                if (JavaWizardFirstPage.this.dependenciesTree.getTree().getSelection().length == 1 && (elt = JavaWizardFirstPage.this.dependenciesTree.getTree().getSelection()[0].getData()) != null && elt instanceof IPackageFragmentRoot) {
                    Map<String, Object> options = JavaWizardFirstPage.this.discoveryParameters.getDiscoveryOptions(elt);
                    boolean useSource = Boolean.TRUE.equals(options.get(LibraryReaderOptions.USE_SOURCES.toString()));
                    options.put(LibraryReaderOptions.USE_SOURCES.toString(), new Boolean(!useSource));
                    JavaWizardFirstPage.this.dependenciesTree.update(elt, null);
                }
                JavaWizardFirstPage.this.refreshBtnUseSources();
            }
        });
        this.btnUseSource.setSelection(false);
        this.btnUseSource.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.btnUseSource.setLayoutData((Object)gridData);
        Composite cLabels = new Composite((Composite)dependencies, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        cLabels.setLayoutData((Object)gridData);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        cLabels.setLayout((Layout)rowLayout);
        Label imageInformationNumberElementsSelected = new Label(cLabels, 0);
        imageInformationNumberElementsSelected.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
        this.textNumberElementsSelected = new Label(cLabels, 0);
    }

    private void createIncrementalPanel(Composite composite) {
        Group mode = new Group(composite, 0);
        mode.setText(Messages.JavaWizardFirstPage_mode);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        mode.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        mode.setLayoutData((Object)gridData);
        this.btnIncrementalMode = new Button((Composite)mode, 32);
        this.btnIncrementalMode.setText(Messages.JavaWizardFirstPage_useIncremental);
        this.btnIncrementalMode.setSelection(this.discoveryParameters.isIncrementalMode());
        this.btnIncrementalMode.setEnabled(true);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.btnIncrementalMode.setLayoutData((Object)gridData);
        this.btnIncrementalMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaWizardFirstPage.this.discoveryParameters.setIncrementalMode(JavaWizardFirstPage.this.btnIncrementalMode.getSelection());
            }
        });
    }

    private void createJavaAnalysisLevelPanel(Composite composite) {
        Group analysisLevel = new Group(composite, 0);
        analysisLevel.setText(Messages.JavaWizardFirstPage_analysisLevel);
        GridLayout myLayout = new GridLayout();
        myLayout.numColumns = 1;
        analysisLevel.setLayout((Layout)myLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        analysisLevel.setLayoutData((Object)gridData);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaWizardFirstPage.this.discoveryParameters.setFullJavaLevel(JavaWizardFirstPage.this.btnFullAnalyseJavaFiles.getSelection());
            }
        };
        this.btnFullAnalyseJavaFiles = new Button((Composite)analysisLevel, 16);
        this.btnFullAnalyseJavaFiles.setText(Messages.JavaWizardFirstPage_fullAnalysis);
        this.btnFullAnalyseJavaFiles.setLayoutData((Object)new GridData());
        this.btnFullAnalyseJavaFiles.setSelection(this.discoveryParameters.isFullJavaLevel());
        this.btnFullAnalyseJavaFiles.addSelectionListener((SelectionListener)listener);
        this.btnMemberAnalyseJavaFiles = new Button((Composite)analysisLevel, 16);
        this.btnMemberAnalyseJavaFiles.setText(Messages.JavaWizardFirstPage_limitedAnalysis);
        this.btnMemberAnalyseJavaFiles.setLayoutData((Object)new GridData());
        this.btnMemberAnalyseJavaFiles.addSelectionListener((SelectionListener)listener);
        this.btnMemberAnalyseJavaFiles.setSelection(!this.discoveryParameters.isFullJavaLevel());
    }

    private void recursiveCheckItem(TreeItem treeitem) {
        if (this.discoveryParameters.getElementsToDiscover().contains(treeitem.getData())) {
            treeitem.setChecked(true);
            if (treeitem.getData() == this.javaProject) {
                treeitem.setExpanded(true);
            }
            this.dependenciesTree.refresh(treeitem.getData());
        }
        TreeItem[] treeItemArray = treeitem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            this.recursiveCheckItem(child);
            ++n2;
        }
    }

    private void createJavaFilterPanel(Composite composite) {
        Group filter = new Group(composite, 0);
        filter.setText(Messages.JavaWizardFirstPage_filter);
        GridLayout myLayout = new GridLayout();
        myLayout.numColumns = 1;
        filter.setLayout((Layout)myLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        filter.setLayoutData((Object)gridData);
        Label label = new Label((Composite)filter, 0);
        label.setText(Messages.JavaWizardFirstPage_excludedElements);
        label.setLayoutData((Object)new GridData());
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                JavaWizardFirstPage.this.validatePage();
            }
        };
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.entryFilter = new Text((Composite)filter, 4);
        this.entryFilter.setToolTipText(Messages.JavaWizardFirstPage_filterToolTip);
        this.entryFilter.setLayoutData((Object)gridData);
        this.entryFilter.addModifyListener(listener);
        if (this.discoveryParameters.getExcludedElements() != null && this.discoveryParameters.getExcludedElements().size() > 0) {
            String lastExcludedElements = new String();
            for (String excludedElt : this.discoveryParameters.getExcludedElements()) {
                lastExcludedElements = String.valueOf(lastExcludedElements) + excludedElt + ";";
            }
            this.entryFilter.setText(lastExcludedElements);
        }
    }

    void refreshBtnUseSources() {
        IStructuredSelection selection = (IStructuredSelection)this.dependenciesTree.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot lib = (IPackageFragmentRoot)element;
            if (this.discoveryParameters.getElementsToDiscover().contains(lib)) {
                Map<String, Object> options = this.discoveryParameters.getDiscoveryOptions(lib);
                boolean useSources = Boolean.TRUE.equals(options.get(LibraryReaderOptions.USE_SOURCES.toString()));
                if (useSources) {
                    this.btnUseSource.setEnabled(true);
                    this.btnUseSource.setSelection(true);
                    return;
                }
                boolean hasSourceAttached = false;
                try {
                    hasSourceAttached = lib.getSourceAttachmentPath() != null;
                }
                catch (JavaModelException javaModelException) {}
                this.btnUseSource.setSelection(false);
                this.btnUseSource.setEnabled(hasSourceAttached);
                return;
            }
        }
        this.btnUseSource.setEnabled(false);
        this.btnUseSource.setSelection(false);
    }

    void validatePage() {
        TreeItem[] treeItemArray = this.dependenciesTree.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeitem = treeItemArray[n2];
            if (treeitem.getData() == this.javaProject && !treeitem.getChecked()) {
                this.setErrorMessage(Messages.JavaWizardFirstPage_firstProjectSelection);
                this.setPageComplete(false);
                return;
            }
            ++n2;
        }
        ArrayList<String> excludedElements = new ArrayList<String>();
        String text = this.entryFilter.getText().trim();
        String[] elements = text.split(";");
        int i = 0;
        while (i < elements.length) {
            String elt = elements[i].trim();
            if (elt.length() != 0) {
                if (elt.contains(" ") || elt.startsWith(".") || elt.endsWith(".")) {
                    this.setErrorMessage(Messages.JavaWizardFirstPage_incorrectFiltered);
                    this.setPageComplete(false);
                    return;
                }
                if (elt.endsWith(".*")) {
                    elt = elt.substring(0, elt.length() - 2);
                }
                excludedElements.add(elt);
            }
            ++i;
        }
        this.discoveryParameters.setExcludedElements(excludedElements);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
    }

    void refreshInformationLabel() {
        int nbProjectsSelected = 0;
        int nbLibrariesSelected = 0;
        Object[] objectArray = this.dependenciesTree.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IJavaProject) {
                ++nbProjectsSelected;
            } else if (element instanceof IPackageFragmentRoot) {
                ++nbLibrariesSelected;
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(nbProjectsSelected);
        if (nbProjectsSelected > 1) {
            sb.append(Messages.JavaWizardFirstPage_projects);
        } else {
            sb.append(Messages.JavaWizardFirstPage_project);
        }
        sb.append(Messages.JavaWizardFirstPage_and);
        sb.append(nbLibrariesSelected);
        if (nbLibrariesSelected > 1) {
            sb.append(Messages.JavaWizardFirstPage_libraries);
        } else {
            sb.append(Messages.JavaWizardFirstPage_library);
        }
        sb.append(Messages.JavaWizardFirstPage_selected);
        this.textNumberElementsSelected.setText(sb.toString());
        this.textNumberElementsSelected.pack(true);
    }

    class JDTDelegateCellLabelProvider
    extends ColumnLabelProvider {
        private JavaElementLabelProvider delegate = new JavaElementLabelProvider();

        JDTDelegateCellLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
            this.delegate.addListener(listener);
        }

        public void dispose() {
            this.delegate.dispose();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public Image getImage(Object element) {
            return this.delegate.getImage(element);
        }

        public String getText(Object element) {
            return this.delegate.getText(element);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.delegate.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.delegate.removeListener(listener);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    class MyTreeContentProvider
    implements ITreeContentProvider {
        MyTreeContentProvider() {
        }

        public Object[] getChildren(Object element) {
            LinkedHashSet<IPackageFragmentRoot> libraries = new LinkedHashSet<IPackageFragmentRoot>();
            if (element instanceof IJavaProject) {
                for (Object tmp : JavaWizardFirstPage.this.discoverableElements) {
                    IPackageFragmentRoot lib;
                    if (!(tmp instanceof IPackageFragmentRoot) || !(lib = (IPackageFragmentRoot)tmp).getJavaProject().equals(element)) continue;
                    libraries.add(lib);
                }
            }
            return libraries.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof IPackageFragmentRoot) {
                return ((IPackageFragmentRoot)element).getJavaProject();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IJavaProject;
        }

        public Object[] getElements(Object inputElement) {
            LinkedHashSet<IJavaProject> projects = new LinkedHashSet<IJavaProject>();
            projects.add(JavaWizardFirstPage.this.javaProject);
            for (Object element : JavaWizardFirstPage.this.discoverableElements) {
                if (!(element instanceof IJavaProject)) continue;
                projects.add((IJavaProject)element);
            }
            return projects.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

