/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.io.library;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.java.Archive;
import org.eclipse.gmt.modisco.java.IModelReader;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.emf.JavaFactory;
import org.eclipse.gmt.modisco.java.io.java.JavaReader;
import org.eclipse.gmt.modisco.java.io.java.MethodRedefinitionManager;
import org.eclipse.gmt.modisco.java.io.java.binding.BindingManager;
import org.eclipse.gmt.modisco.java.io.library.ClassFileParser;
import org.eclipse.gmt.modisco.java.io.library.ClassFileParserUtils;
import org.eclipse.gmt.modisco.java.io.library.LibraryReaderOptions;
import org.eclipse.gmt.modisco.java.io.library.ManifestReader;
import org.eclipse.gmt.modisco.java.io.library.Messages;
import org.eclipse.gmt.modisco.java.io.library.TypeFinder;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryReader
implements IModelReader {
    protected JavaFactory factory;
    protected Model resultModel;
    protected BindingManager globalBindings;
    protected Map<String, Object> options;
    protected TypeFinder typeFinder;
    private boolean useSources;

    public LibraryReader(JavaFactory factory) {
        this(factory, new HashMap<String, Object>());
    }

    public LibraryReader(JavaFactory factory, Map<String, Object> options) {
        this.factory = factory;
        this.options = options;
        this.useSources = Boolean.TRUE.equals(options.get(LibraryReaderOptions.USE_SOURCES.toString()));
    }

    @Override
    public void readModel(Object source, Model resultModel, IProgressMonitor monitor) {
        this.readModel(source, resultModel, this.getBindingManager(), monitor);
    }

    @Override
    public void readModel(Object source, Model resultModel, BindingManager globalBindings, IProgressMonitor monitor) {
        block9: {
            if (source == null) {
                return;
            }
            this.resultModel = resultModel;
            this.globalBindings = globalBindings;
            ClassFileParserUtils.initializePrimitiveTypes(this.factory, resultModel, this.globalBindings);
            try {
                if (source instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot library = (IPackageFragmentRoot)source;
                    if (resultModel.getName() == null || resultModel.getName().length() == 0) {
                        resultModel.setName(library.getElementName());
                    }
                    this.typeFinder = new TypeFinder(library.getJavaProject());
                    IJavaElement[] children = library.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        IPackageFragment packageFolder = (IPackageFragment)children[i];
                        if (packageFolder.getClassFiles().length > 0) {
                            monitor.subTask(String.valueOf(Messages.LibraryReader_DiscoveringTask) + packageFolder.getElementName());
                            this.parsePackage(library, resultModel, packageFolder, monitor);
                            if (monitor.isCanceled()) {
                                return;
                            }
                        }
                        ++i;
                    }
                    break block9;
                }
                if (source instanceof IClassFile) {
                    IClassFile cf = (IClassFile)source;
                    this.typeFinder = new TypeFinder(cf.getJavaProject());
                    this.parseClassFile(cf);
                    break block9;
                }
                throw new IllegalArgumentException("Library reader can not handle source object : " + source.toString());
            }
            catch (Exception e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            }
        }
    }

    protected void parsePackage(IPackageFragmentRoot library, Model resultModel, IPackageFragment parent, IProgressMonitor monitor) throws JavaModelException {
        IClassFile[] children;
        IClassFile[] iClassFileArray = children = parent.getClassFiles();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IClassFile cf = iClassFileArray[n2];
            this.parseClassFile(cf);
            if (monitor.isCanceled()) {
                return;
            }
            ++n2;
        }
    }

    protected void parseClassFile(IClassFile classFile) {
        try {
            IType type = classFile.getType();
            if (type != null && type.exists() && !type.isAnonymous() && !type.isLocal() && !type.isMember()) {
                String filePath = LibraryReader.getPath(classFile);
                this.visitClassFile(classFile, filePath);
            }
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
        }
    }

    protected void visitClassFile(IClassFile classFile, String filePath) throws JavaModelException {
        boolean classFileHasSource = false;
        String fileContent = null;
        if (this.useSources && (fileContent = classFile.getSource()) != null) {
            classFileHasSource = true;
        }
        if (classFileHasSource) {
            JavaReader javaReader = new JavaReader(this.factory);
            javaReader.readModel(classFile, this.resultModel, this.globalBindings, (IProgressMonitor)new NullProgressMonitor());
        } else {
            ClassFileParser jdtVisitor = new ClassFileParser(this.factory, this.resultModel, this.globalBindings, this.typeFinder, filePath);
            jdtVisitor.parse(classFile);
        }
    }

    protected void resolveMethodRedefinition(Model resultModel) {
        MethodRedefinitionManager.resolveMethodRedefinitions(resultModel, this.factory);
    }

    protected void finalResolveBindings(Model resultModel) {
        this.globalBindings.resolveBindings(resultModel);
    }

    protected BindingManager getBindingManager() {
        BindingManager bindingManager = new BindingManager(this.factory);
        return bindingManager;
    }

    @Override
    public void terminate(IProgressMonitor monitor) {
        monitor.subTask(Messages.LibraryReader_BindingTask);
        this.finalResolveBindings(this.resultModel);
        monitor.subTask(Messages.LibraryReader_RedefinitionsTask);
        this.resolveMethodRedefinition(this.resultModel);
    }

    public static Archive getArchive(IClassFile classFile, JavaFactory factory, Model model) {
        Archive archive = null;
        IPackageFragmentRoot root = (IPackageFragmentRoot)classFile.getAncestor(3);
        if (root != null && root.isArchive()) {
            String libraryPath = LibraryReader.getPath(root);
            for (Archive itElement : model.getArchives()) {
                if (!itElement.getOriginalFilePath().equals(libraryPath)) continue;
                return itElement;
            }
            archive = factory.createArchive();
            archive.setName(root.getElementName());
            archive.setOriginalFilePath(libraryPath);
            ManifestReader.completeArchiveWithManifest(root, archive, factory);
            model.getArchives().add((Object)archive);
        }
        return archive;
    }

    public static String getPath(IClassFile classFile) {
        IPackageFragmentRoot library = (IPackageFragmentRoot)classFile.getAncestor(3);
        String filePath = null;
        if (library.isArchive()) {
            IPackageFragment parent = (IPackageFragment)classFile.getParent();
            String packagePath = parent.getElementName().replace('.', '/');
            filePath = String.valueOf('/') + packagePath + '/' + classFile.getElementName();
        } else if (library.isExternal()) {
            filePath = classFile.getPath().toOSString();
        } else {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(classFile.getPath());
            filePath = file.getLocation().toOSString();
        }
        return filePath;
    }

    public static String getPath(IPackageFragmentRoot library) {
        String filePath = library.getPath().toOSString();
        if (!library.isExternal()) {
            Object resource = null;
            resource = library.isArchive() ? ResourcesPlugin.getWorkspace().getRoot().getFile(library.getPath()) : ResourcesPlugin.getWorkspace().getRoot().getFolder(library.getPath());
            filePath = resource.getLocation().toOSString();
        }
        return filePath;
    }

    public static String getFileContent(IClassFile classFile) {
        String source = null;
        try {
            source = classFile.getSource();
        }
        catch (JavaModelException javaModelException) {}
        return source;
    }
}

