/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.core.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gmt.modisco.common.core.utils.FolderUtils;
import org.osgi.framework.Bundle;

public final class FileUtils {
    private FileUtils() {
    }

    public static String getContents(File file) throws IOException {
        StringBuilder contents = new StringBuilder(1024);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        char[] buffer = new char[1024];
        int read = 0;
        while ((read = reader.read(buffer)) != -1) {
            contents.append(buffer, 0, read);
        }
        reader.close();
        return contents.toString();
    }

    public static void copyFileFormBundle(String sourcePath, IProject project, String destinationPath, Bundle bundleContainingResources) throws IOException, CoreException {
        InputStream source;
        URL url;
        try {
            url = bundleContainingResources.getResource(sourcePath);
            source = url.openStream();
        }
        catch (NullPointerException nullPointerException) {
            url = bundleContainingResources.getEntry(sourcePath);
            source = url.openStream();
        }
        IFile javaFile = project.getFile(destinationPath);
        if (javaFile.exists()) {
            javaFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!javaFile.getParent().exists()) {
            FolderUtils.createFolder((IFolder)javaFile.getParent());
        }
        javaFile.create(source, true, (IProgressMonitor)new NullProgressMonitor());
    }
}

