/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.role.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.AbstractModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.Activator;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryException;
import org.eclipse.gmt.modisco.infra.role.Role;
import org.eclipse.gmt.modisco.infra.role.RoleAttribute;
import org.eclipse.gmt.modisco.infra.role.RoleReference;
import org.eclipse.gmt.modisco.infra.role.RoleSet;
import org.eclipse.gmt.modisco.infra.role.RoleStructuralFeature;
import org.eclipse.gmt.modisco.infra.role.Shortcut;
import org.eclipse.gmt.modisco.infra.role.core.exception.ModiscoRoleException;
import org.eclipse.gmt.modisco.infra.role.core.exception.StructuralConstraintViolationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleContext {
    private HashSet<Role> appliedRoles = new HashSet();
    private List<EStructuralFeature> appliedFeatures = new ArrayList<EStructuralFeature>();
    private HashSet<Resource> resources = new HashSet();

    public void addComposedResource(Resource resource) {
        this.resources.add(resource);
        TreeIterator allContents = EcoreUtil.getAllContents((Resource)resource, (boolean)false);
        while (allContents.hasNext()) {
            EObject element = (EObject)allContents.next();
            if (element.eResource() == resource) continue;
            this.resources.add(element.eResource());
        }
    }

    public void addRoleSet(RoleSet roleSet) {
        for (Role role : roleSet.getRoles()) {
            this.addRole(role);
        }
    }

    public void addRole(Role role) {
        if (!this.appliedRoles.contains(role)) {
            this.appliedRoles.add(role);
            for (EStructuralFeature feature : role.getEStructuralFeatures()) {
                if (!(feature instanceof RoleStructuralFeature) && !(feature instanceof Shortcut)) continue;
                this.appliedFeatures.add(feature);
            }
        }
    }

    public boolean isInstance(EObject eObject, Role role) throws ModelQueryException {
        ModelQuery modelQuery = role.getConditionQuery();
        boolean result = false;
        boolean isSuperType = false;
        for (EClass superType : role.getESuperTypes()) {
            if (!superType.isSuperTypeOf(eObject.eClass())) continue;
            isSuperType = true;
            break;
        }
        if (isSuperType) {
            if (modelQuery == null) {
                result = true;
            } else {
                AbstractModelQuery abstractModelQuery = ModelQuerySetCatalog.getSingleton().getModelQueryImpl(modelQuery);
                result = (Boolean)abstractModelQuery.basicEvaluate(eObject);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(EObject eObject, EStructuralFeature structuralFeature) throws ModelQueryException, ModiscoRoleException {
        if (structuralFeature == null) {
            throw new ModiscoRoleException("The parameter named structuralFeature is null");
        }
        Object result = null;
        if (!this.appliedFeatures.contains(structuralFeature)) throw new ModiscoRoleException("The structuralFeature must be registered into the context, please use the " + RoleContext.class.getSimpleName() + ".add(RoleSet) method.");
        Role role = (Role)structuralFeature.eContainer();
        if (!this.isInstance(eObject, role)) throw new ModiscoRoleException("The eObject parameter must be a instance of : " + role.getName());
        if (structuralFeature instanceof RoleStructuralFeature) {
            RoleStructuralFeature roleStructuralFeature = (RoleStructuralFeature)structuralFeature;
            ModelQuery modelQuery = roleStructuralFeature.getValueQuery();
            AbstractModelQuery abstractModelQuery = ModelQuerySetCatalog.getSingleton().getModelQueryImpl(modelQuery);
            return abstractModelQuery.basicEvaluate(eObject);
        }
        if (!(structuralFeature instanceof Shortcut)) throw new ModiscoRoleException("The structuralFeature parameter must be a RoleStructuralFeature: " + structuralFeature.toString());
        Shortcut shortcut = (Shortcut)structuralFeature;
        BasicEList resultList = new BasicEList();
        EReference oppositeRef = shortcut.getOppositeReference();
        EClass eClass = oppositeRef.getEContainingClass();
        List<EObject> list = this.allInstances(eClass);
        for (EObject modelElement : list) {
            EObject referedByModelElement = (EObject)modelElement.eGet((EStructuralFeature)oppositeRef);
            if (referedByModelElement != eObject) continue;
            EObject element = modelElement;
            for (EReference eReference : shortcut.getPath()) {
                element = (EObject)element.eGet((EStructuralFeature)eReference);
            }
            resultList.add(element);
        }
        if (shortcut.getUpperBound() > 1) {
            return resultList;
        }
        if (resultList.size() > 1) {
            throw new StructuralConstraintViolationException();
        }
        if (resultList.size() != 1) return result;
        return resultList.get(0);
    }

    protected List<EObject> allInstances(EClass eClass) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (Resource resource : this.resources) {
            TreeIterator treeIterator = resource.getAllContents();
            while (treeIterator.hasNext()) {
                EObject eObject = (EObject)treeIterator.next();
                if (!eClass.isInstance((Object)eObject)) continue;
                result.add(eObject);
            }
        }
        return result;
    }

    public List<EStructuralFeature> getRoleFeatures(EObject eObject) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        for (Role role : this.appliedRoles) {
            try {
                if (!this.isInstance(eObject, role)) continue;
                result.addAll((Collection<EStructuralFeature>)role.getEStructuralFeatures());
            }
            catch (ModelQueryException e) {
                Status status = new Status(4, "org.eclipse.gmt.modisco.infra.query.core", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return result;
    }

    public void addAll(Collection<RoleSet> allRoleSets) {
        for (RoleSet roleSet : allRoleSets) {
            this.addRoleSet(roleSet);
        }
    }

    public EList<EAttribute> getAttributes(EObject eObject) throws ModelQueryException {
        BasicEList result = new BasicEList();
        for (Role role : this.appliedRoles) {
            if (!this.isInstance(eObject, role)) continue;
            for (EStructuralFeature structuralFeature : role.getEStructuralFeatures()) {
                if (!(structuralFeature instanceof RoleAttribute)) continue;
                RoleAttribute roleAttribute = (RoleAttribute)structuralFeature;
                result.add((Object)roleAttribute);
            }
        }
        return result;
    }

    public EList<EReference> getReferences(EObject eObject) throws ModelQueryException {
        BasicEList result = new BasicEList();
        for (Role role : this.appliedRoles) {
            if (!this.isInstance(eObject, role)) continue;
            for (EStructuralFeature structuralFeature : role.getEStructuralFeatures()) {
                if (!(structuralFeature instanceof RoleReference) && !(structuralFeature instanceof Shortcut)) continue;
                EReference roleAttribute = (EReference)structuralFeature;
                result.add((Object)roleAttribute);
            }
        }
        return result;
    }

    public List<EClass> getMetaClasses() {
        ArrayList<EClass> metaClasses = new ArrayList<EClass>();
        metaClasses.addAll(this.appliedRoles);
        return metaClasses;
    }

    public List<Role> getRoles(EObject eObject) throws ModelQueryException {
        ArrayList<Role> result = new ArrayList<Role>();
        for (Role role : this.appliedRoles) {
            try {
                if (!this.isInstance(eObject, role)) continue;
                result.add(role);
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.gmt.modisco.infra.query.core", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return result;
    }

    public HashSet<Role> getAppliedRoles() {
        return this.appliedRoles;
    }

    public void clean() {
        this.appliedFeatures.clear();
        this.appliedRoles.clear();
    }

    protected List<EStructuralFeature> getAppliedFeatures() {
        return this.appliedFeatures;
    }
}

