/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gmt.modisco.common.ui.MoDiscoCommonUIPlugin;
import org.eclipse.gmt.modisco.common.ui.wizards.NewProjectCreationOperation;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NewProjectWizard
extends Wizard
implements INewWizard {
    private static final String NEW_PROJECT_CREATION_PAGE_NAME = "NewProjectCreationPage";
    private IWorkbench theWorkbench;
    private IProject project;
    private String projectName;
    private IPath projectLocation;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.theWorkbench = workbench;
        this.setWindowTitle(MoDiscoCommonUIPlugin.getDefault().getString("new.moDiscoProject.wizard.title"));
    }

    public void addPages() {
        WizardNewProjectCreationPage newProjectCreationPage = new WizardNewProjectCreationPage(NEW_PROJECT_CREATION_PAGE_NAME){

            protected boolean validatePage() {
                NewProjectWizard.this.projectLocation = this.getLocationPath();
                NewProjectWizard.this.projectName = this.getProjectName();
                if (this.getProjectName() != null && this.getProjectName().length() > 0) {
                    NewProjectWizard.this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
                }
                return super.validatePage() && NewProjectWizard.this.canFinish();
            }
        };
        newProjectCreationPage.setInitialProjectName(this.projectName);
        newProjectCreationPage.setTitle(MoDiscoCommonUIPlugin.getDefault().getString("new.moDiscoProject.wizard.title"));
        newProjectCreationPage.setDescription(MoDiscoCommonUIPlugin.getDefault().getString("new.moDiscoProject.wizard.description"));
        this.addPage((IWizardPage)newProjectCreationPage);
    }

    public boolean performFinish() {
        IWorkbenchPage page;
        IWorkbenchPart activePart;
        NewProjectCreationOperation operation = new NewProjectCreationOperation(this.projectLocation, this.project);
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception exception) {
            return false;
        }
        if (this.project != null && (activePart = (page = this.theWorkbench.getActiveWorkbenchWindow().getActivePage()).getActivePart()) instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)this.project);
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
        return true;
    }

    public boolean canFinish() {
        return this.projectName != null && this.projectName.length() > 0 && this.project != null && !this.project.exists();
    }
}

