/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.omg.kdm.code;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MethodKind implements Enumerator
{
    METHOD(0, "method", "method"),
    CONSTRUCTOR(1, "constructor", "constructor"),
    DESTRUCTOR(2, "destructor", "destructor"),
    OPERATOR(3, "operator", "operator"),
    VIRTUAL(4, "virtual", "virtual"),
    ABSTRACT(5, "abstract", "abstract"),
    UNKNOWN(6, "unknown", "unknown");

    public static final int METHOD_VALUE = 0;
    public static final int CONSTRUCTOR_VALUE = 1;
    public static final int DESTRUCTOR_VALUE = 2;
    public static final int OPERATOR_VALUE = 3;
    public static final int VIRTUAL_VALUE = 4;
    public static final int ABSTRACT_VALUE = 5;
    public static final int UNKNOWN_VALUE = 6;
    private static final MethodKind[] VALUES_ARRAY;
    public static final List<MethodKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MethodKind[]{METHOD, CONSTRUCTOR, DESTRUCTOR, OPERATOR, VIRTUAL, ABSTRACT, UNKNOWN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MethodKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MethodKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MethodKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MethodKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MethodKind get(int value) {
        switch (value) {
            case 0: {
                return METHOD;
            }
            case 1: {
                return CONSTRUCTOR;
            }
            case 2: {
                return DESTRUCTOR;
            }
            case 3: {
                return OPERATOR;
            }
            case 4: {
                return VIRTUAL;
            }
            case 5: {
                return ABSTRACT;
            }
            case 6: {
                return UNKNOWN;
            }
        }
        return null;
    }

    private MethodKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

