/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.ui.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.common.core.builder.AbstractMoDiscoCatalog;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.common.core.utils.ImageUtils;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.ModelQuerySet;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.gmt.modisco.infra.query.ui.Activator;
import org.eclipse.gmt.modisco.infra.query.ui.Messages;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class ModelQueryView
extends ViewPart
implements AbstractMoDiscoCatalog.ModiscoCatalogChangeListener {
    private static final int JOB_SCHEDULE_DELAY = 500;
    private static final int COLUMN_WIDTH = 200;
    private TreeViewer modelQuerySetViewer;
    private TreeViewerColumn nameColumn;
    private TreeViewerColumn locationColumn;
    private Job refreshJob = null;

    public TreeViewer getModelQuerySetViewer() {
        return this.modelQuerySetViewer;
    }

    public TreeViewerColumn getNameColumn() {
        return this.nameColumn;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.modelQuerySetViewer = new TreeViewer(parent, 66308);
        this.modelQuerySetViewer.getTree().setLinesVisible(true);
        this.modelQuerySetViewer.getTree().setHeaderVisible(true);
        this.modelQuerySetViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ModelQueryView.this.getModelQuerySetViewer().getSelection();
                EObject modelElement = (EObject)selection.getFirstElement();
                ModelQuerySet modelQuerySet = null;
                if (modelElement instanceof ModelQuerySet) {
                    modelQuerySet = (ModelQuerySet)modelElement;
                } else if (modelElement instanceof ModelQuery) {
                    ModelQuery modelQuery = (ModelQuery)modelElement;
                    modelQuerySet = modelQuery.getModelQuerySet();
                }
                if (modelQuerySet != null) {
                    java.net.URI uri = null;
                    try {
                        String uriString = ModelQuerySetCatalog.getSingleton().getURI(modelQuerySet.getName()).toString();
                        uri = java.net.URI.create(uriString);
                        if ("file".equals(uri.getScheme())) {
                            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (java.net.URI)new java.net.URI(modelQuerySet.eResource().getURI().toString()), (String)"org.eclipse.gmt.modisco.infra.query.emf.presentation.queryEditorID", (boolean)true);
                        } else {
                            URIEditorInput uriEditorInput = new URIEditorInput(URI.createURI((String)uri.toString()));
                            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)uriEditorInput, (String)"org.eclipse.gmt.modisco.infra.query.emf.presentation.queryEditorID", (boolean)true);
                        }
                    }
                    catch (Exception e) {
                        MoDiscoLogger.logError((Throwable)e, (String)("Failed to open: " + uri), (Plugin)Activator.getDefault());
                    }
                }
            }
        });
        this.createNameColumn();
        this.createLocationColumn();
        this.modelQuerySetViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (!(inputElement instanceof Object[])) {
                    throw new RuntimeException("Unexpected inputElement type: " + inputElement.getClass().getName());
                }
                return (Object[])inputElement;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                if (!(parentElement instanceof ModelQuerySet)) {
                    throw new RuntimeException("Unexpected inputElement type: " + parentElement.getClass().getName());
                }
                ModelQuerySet modelQuerySet = (ModelQuerySet)parentElement;
                return modelQuerySet.getQueries().toArray();
            }

            public Object getParent(Object element) {
                if (element instanceof ModelQuerySet) {
                    return null;
                }
                if (element instanceof ModelQuery) {
                    ModelQuery modelQuery = (ModelQuery)element;
                    return modelQuery.getModelQuerySet();
                }
                throw new RuntimeException("Unexpected inputElement type: " + element.getClass().getName());
            }

            public boolean hasChildren(Object element) {
                return element instanceof ModelQuerySet;
            }

            public void dispose() {
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.modelQuerySetViewer);
        this.refresh(false);
        ModelQuerySetCatalog.getSingleton().addChangeListener((AbstractMoDiscoCatalog.ModiscoCatalogChangeListener)this);
    }

    private void createLocationColumn() {
        this.locationColumn = new TreeViewerColumn(this.modelQuerySetViewer, 0);
        this.locationColumn.getColumn().setText(Messages.ModelQueryView_location);
        this.locationColumn.getColumn().setWidth(400);
        this.locationColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof ModelQuerySet)) {
                    return "";
                }
                ModelQuerySet modelQuerySet = (ModelQuerySet)element;
                return ModelQuerySetCatalog.getSingleton().getURI(modelQuerySet.getName()).toString();
            }
        });
        this.addSorter(this.locationColumn, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TreeViewer structuredViewer;
                ModelQuerySet modelQuerySet1 = (ModelQuerySet)e1;
                ModelQuerySet modelQuerySet2 = (ModelQuerySet)e2;
                String uri1 = ModelQuerySetCatalog.getSingleton().getURI(modelQuerySet1.getName()).toString();
                String uri2 = ModelQuerySetCatalog.getSingleton().getURI(modelQuerySet2.getName()).toString();
                int compare = uri1.compareTo(uri2);
                if (viewer instanceof TreeViewer && (structuredViewer = (TreeViewer)viewer).getTree().getSortDirection() == 1024) {
                    compare *= -1;
                }
                return compare;
            }
        });
    }

    private void createNameColumn() {
        this.nameColumn = new TreeViewerColumn(this.modelQuerySetViewer, 0);
        this.nameColumn.getColumn().setText(Messages.ModelQueryView_name);
        this.nameColumn.getColumn().setWidth(200);
        this.nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ModelQuerySet) {
                    ModelQuerySet modelQuerySet = (ModelQuerySet)element;
                    return modelQuerySet.getName();
                }
                if (element instanceof ModelQuery) {
                    ModelQuery modelQuery = (ModelQuery)element;
                    return modelQuery.getName();
                }
                return "";
            }

            public Image getImage(Object element) {
                return ImageUtils.getImage((Object)element);
            }
        });
        this.addSorter(this.nameColumn, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TreeViewer structuredViewer;
                ModelQuerySet modelQuerySet1 = (ModelQuerySet)e1;
                ModelQuerySet modelQuerySet2 = (ModelQuerySet)e2;
                int compare = modelQuerySet1.getName().compareTo(modelQuerySet2.getName());
                if (viewer instanceof TreeViewer && (structuredViewer = (TreeViewer)viewer).getTree().getSortDirection() == 1024) {
                    compare *= -1;
                }
                return compare;
            }
        });
    }

    private void addSorter(final TreeViewerColumn column, final ViewerSorter viewerSorter) {
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeViewer treeView = ModelQueryView.this.getModelQuerySetViewer();
                treeView.setSorter(viewerSorter);
                treeView.getTree().setSortColumn(column.getColumn());
                if (treeView.getTree().getSortDirection() == 128) {
                    treeView.getTree().setSortDirection(1024);
                } else if (treeView.getTree().getSortDirection() == 1024) {
                    treeView.getTree().setSortDirection(128);
                } else {
                    treeView.getTree().setSortDirection(128);
                }
                treeView.refresh();
            }
        });
    }

    public void setFocus() {
        this.modelQuerySetViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        ModelQuerySetCatalog.getSingleton().removeChangeListener((AbstractMoDiscoCatalog.ModiscoCatalogChangeListener)this);
    }

    public void changed(EObject changedQuerySet, IFile file) {
        this.refresh(true);
    }

    public void added(EObject addedQuerySet, IFile file) {
        this.refresh(true);
    }

    public void removed(IFile querySetFile) {
        this.refresh(true);
    }

    private void refresh(boolean delayed) {
        if (this.refreshJob == null) {
            this.refreshJob = new Job(Messages.refreshingQuerySetsView){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            ModelQueryView.this.getModelQuerySetViewer().setInput((Object)ModelQuerySetCatalog.getSingleton().getAllModelQuerySets().toArray());
                            ModelQueryView.this.getNameColumn().getColumn().pack();
                            ModelQueryView.this.getModelQuerySetViewer().refresh();
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
        }
        if (delayed) {
            this.refreshJob.cancel();
            this.refreshJob.setPriority(50);
            this.refreshJob.schedule(500L);
        } else {
            this.refreshJob.schedule();
            try {
                this.refreshJob.join();
            }
            catch (InterruptedException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
    }
}

