/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.ui.views.queryExecution;

import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.query.ui.ImageProvider;
import org.eclipse.gmt.modisco.infra.query.ui.views.queryExecution.QueryExecutionView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextPaneMenuManager
extends MenuManager
implements IMenuListener {
    private final Set<EObject> context;
    private final TreeViewer fTreeViewer;
    private final QueryExecutionView queryExecutionView;
    private final IAction removeAllAction = new Action("Remove All"){
        {
            this.setImageDescriptor(ImageProvider.getInstance().getRemoveAllImageDescriptor());
        }

        public void run() {
            ContextPaneMenuManager.this.context.clear();
            ContextPaneMenuManager.this.fTreeViewer.refresh();
        }
    };
    private final IAction removeSelectedElementsAction = new Action("Remove"){
        {
            this.setImageDescriptor(ImageProvider.getInstance().getRemoveImageDescriptor());
        }

        public void run() {
            QueryExecutionView.ContextInfo contextInfo = ContextPaneMenuManager.this.queryExecutionView.getContextInfo();
            for (EObject eObject : contextInfo.getSelectedEObjects()) {
                ContextPaneMenuManager.this.context.remove(eObject);
            }
            ContextPaneMenuManager.this.fTreeViewer.refresh();
        }
    };

    public ContextPaneMenuManager(QueryExecutionView queryExecutionView, Set<EObject> context, TreeViewer treeViewer) {
        this.queryExecutionView = queryExecutionView;
        this.context = context;
        this.fTreeViewer = treeViewer;
        this.addMenuActions();
        this.addMenuListener(this);
        this.addKeyShortcuts(treeViewer);
    }

    private void addKeyShortcuts(TreeViewer treeViewer) {
        treeViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    ContextPaneMenuManager.this.removeSelectedElementsAction.run();
                }
            }
        });
    }

    private void addMenuActions() {
        this.add(this.removeSelectedElementsAction);
        this.add(this.removeAllAction);
    }

    public void menuAboutToShow(IMenuManager manager) {
        QueryExecutionView.ContextInfo contextInfo = this.queryExecutionView.getContextInfo();
        this.removeAllAction.setEnabled(contextInfo.getEObjects().size() > 0);
        this.removeSelectedElementsAction.setEnabled(contextInfo.getSelectedEObjects().size() > 0);
    }
}

