/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.discoverer.benchmark.cdo.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.revision.cache.CDORevisionCache;
import org.eclipse.emf.cdo.common.revision.cache.CDORevisionCacheUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.net4j.CDOSession;
import org.eclipse.emf.cdo.net4j.CDOSessionConfiguration;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.java.cdo.impl.JavaPackageImpl;
import org.eclipse.gmt.modisco.java.cdo.meta.JavaFactory;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.Activator;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.cdo.client.Messages;
import org.eclipse.gmt.modisco.java.discoverer.tests.emfstat.DiscoverJavaModelFromJavaProjectEMFStat;
import org.eclipse.gmt.modisco.java.discoverer.tests.emfstat.JavaReaderEMFStat;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.tcp.ITCPConnector;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.PrintLogHandler;
import org.eclipse.net4j.util.om.trace.OMTraceHandler;
import org.eclipse.net4j.util.om.trace.PrintTraceHandler;
import org.eclipse.net4j.util.transaction.TransactionException;

public class JavaDiscovererCDO
extends DiscoverJavaModelFromJavaProjectEMFStat {
    private String cacheType = LRU_CACHE;
    private Object serverDescription = Messages.JavaDiscovererCDO_0;
    private int port = 2036;
    public static final int DEFAULT_LRU_CAPACITY = 1000;
    public static final int DEFAULT_PORT_VALUE = 2036;
    public static final String LRU_CACHE = Messages.JavaDiscovererCDO_1;
    public static final String DEFAULT_CACHE = Messages.JavaDiscovererCDO_2;
    public static final String MEM_CACHE = Messages.JavaDiscovererCDO_3;
    public static final String TWO_LEVEL_CACHE = Messages.JavaDiscovererCDO_4;
    public static final String CDO_CACHE_TYPE = Messages.JavaDiscovererCDO_5;
    public static final String CURRENT_LRU_CAPACITY = Messages.JavaDiscovererCDO_6;
    public static final String REVISED_LRU_CAPACITY = Messages.JavaDiscovererCDO_7;
    public static final String CDO_VERSION = Messages.JavaDiscovererCDO_8;
    public static final String CDO_SERVER_DESCRIPTION = Messages.JavaDiscovererCDO_9;
    public static final int LRU_CAPACITY_CURRENT = 100000;
    public static final int LRU_CAPACITY_REVISED = 100;
    private static Map<CDOView, ITCPConnector> connectors = new HashMap<CDOView, ITCPConnector>();

    protected void terminate(Resource r) {
        JavaDiscovererCDO.close(r, true);
    }

    private static void close(Resource r, boolean commit) {
        if (r instanceof CDOResource) {
            CDOResource cdoRessource = (CDOResource)r;
            CDOView cdoView = cdoRessource.cdoView();
            if (commit && cdoView instanceof CDOTransaction) {
                CDOTransaction cdoTransaction = (CDOTransaction)cdoView;
                try {
                    cdoTransaction.commit();
                }
                catch (TransactionException e) {
                    e.printStackTrace();
                }
            }
            org.eclipse.emf.cdo.session.CDOSession cdoSession = cdoView.getSession();
            ITCPConnector connector = connectors.get(cdoView);
            cdoView.close();
            if (cdoSession != null) {
                cdoSession.close();
            }
            if (connector != null) {
                connector.close();
            }
            connectors.remove(cdoView);
        }
    }

    protected Resource getResource(String resourceName, IJavaProject javaProject) {
        String resourceName2 = String.valueOf(resourceName) + System.currentTimeMillis();
        Status status = new Status(1, "org.eclipse.gmt.modisco.java.discoverer.benchmark", String.valueOf(Messages.JavaDiscovererCDO_10) + resourceName2);
        Activator.getDefault().getLog().log((IStatus)status);
        EPackage ePackage = this.getEFactory().getEPackage();
        if (ePackage == null) {
            throw new RuntimeException(String.valueOf(Messages.JavaDiscovererCDO_11) + this.getEFactory());
        }
        CDOResource result = this.getOrCreateCDOResource(resourceName2, ePackage);
        result.getContents().add((Object)this.getEFactory().createModel());
        this.dbInit(result);
        return result;
    }

    private CDOResource getOrCreateCDOResource(String resourceName, EPackage ePackage) {
        CDOResource resource = null;
        OMPlatform.INSTANCE.setDebugging(true);
        OMPlatform.INSTANCE.addLogHandler((OMLogHandler)PrintLogHandler.CONSOLE);
        OMPlatform.INSTANCE.addTraceHandler((OMTraceHandler)PrintTraceHandler.CONSOLE);
        IManagedContainer container = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)container);
        TCPUtil.prepareContainer((IManagedContainer)container);
        CDONet4jUtil.prepareContainer((IManagedContainer)container);
        container.activate();
        ITCPConnector connector = TCPUtil.getConnector((IManagedContainer)container, (String)("localhost" + Messages.JavaDiscovererCDO_12 + this.port));
        CDORevisionCache revisionCache = null;
        if (this.cacheType.equals(MEM_CACHE)) {
            revisionCache = CDORevisionCacheUtil.createMEMCache();
        } else if (this.cacheType.equals(LRU_CACHE)) {
            revisionCache = CDORevisionCacheUtil.createLRUCache((int)1000, (int)1000);
        } else if (this.cacheType.equals(TWO_LEVEL_CACHE)) {
            revisionCache = CDORevisionCacheUtil.createTwoLevelCache((CDORevisionCache)CDORevisionCacheUtil.createLRUCache((int)100000, (int)100), (CDORevisionCache)CDORevisionCacheUtil.createMEMCache());
        }
        CDOSessionConfiguration configuration = CDONet4jUtil.createSessionConfiguration();
        configuration.setConnector((IConnector)connector);
        configuration.setRepositoryName("repo1");
        if (revisionCache != null) {
            configuration.setRevisionCache(revisionCache);
        }
        CDOSession session = configuration.openSession();
        session.getPackageRegistry().putEPackage(ePackage);
        CDOTransaction transaction = session.openTransaction();
        connectors.put((CDOView)transaction, connector);
        String resourcePath = String.valueOf(Messages.JavaDiscovererCDO_13) + resourceName;
        Status status = new Status(1, "org.eclipse.gmt.modisco.java.discoverer.benchmark", resourcePath);
        Activator.getDefault().getLog().log((IStatus)status);
        resource = transaction.getOrCreateResource(resourcePath);
        return resource;
    }

    protected Properties getProperties() {
        Properties properties = super.getProperties();
        properties.put("STORAGE_KIND", "CDO");
        properties.put(CDO_VERSION, Platform.getBundle((String)"org.eclipse.emf.cdo").getVersion().toString());
        if (LRU_CACHE.equals(this.cacheType)) {
            properties.put(CDO_CACHE_TYPE, LRU_CACHE);
            properties.put(CURRENT_LRU_CAPACITY, new Integer(1000).toString());
            properties.put(REVISED_LRU_CAPACITY, new Integer(1000).toString());
        } else if (DEFAULT_CACHE.equals(this.cacheType)) {
            properties.put(CDO_CACHE_TYPE, DEFAULT_CACHE);
        } else if (MEM_CACHE.equals(this.cacheType)) {
            properties.put(CDO_CACHE_TYPE, MEM_CACHE);
        } else {
            properties.put(CDO_CACHE_TYPE, "Wrong revision cache type");
            Status status = new Status(4, "org.eclipse.gmt.modisco.java.discoverer.benchmark", "Wrong revision cache type", (Throwable)new Exception());
            Activator.getDefault().getLog().log((IStatus)status);
        }
        properties.put(CDO_SERVER_DESCRIPTION, this.serverDescription);
        properties.put("ALGO_VARIANTE", Messages.JavaDiscovererCDO_18);
        return properties;
    }

    protected org.eclipse.gmt.modisco.java.emf.JavaFactory getEFactory() {
        JavaPackageImpl.init();
        return JavaFactory.eINSTANCE;
    }

    private void dbInit(CDOResource resource) {
        CDOView cdoView;
        if (this.statistics != null) {
            this.statistics.beginInit();
        }
        if ((cdoView = resource.cdoView()) instanceof CDOTransaction) {
            CDOTransaction cdoTransaction = (CDOTransaction)cdoView;
            cdoTransaction.commit();
        }
        if (this.statistics != null) {
            this.statistics.endInit();
        }
    }

    protected JavaReaderEMFStat getJavaReader(boolean isIncremental) {
        JavaReaderEMFStat javaReader = new JavaReaderEMFStat(this.getEFactory(), true){

            protected void reset() {
                CDOObject cdoObject;
                CDOView cdoView;
                if (this.statistics != null) {
                    this.statistics.tabValueReport("Begin reset");
                }
                this.globalBindings.resolveBindings(this.resultModel);
                if (this.statistics != null) {
                    this.statistics.tabValueReport("globalBindings resolved");
                }
                if (this.statistics != null) {
                    this.statistics.beginSave();
                }
                if (this.resultModel instanceof CDOObject && (cdoView = (cdoObject = (CDOObject)this.resultModel).cdoView()) instanceof CDOTransaction) {
                    CDOTransaction cdoTransaction = (CDOTransaction)cdoView;
                    cdoTransaction.commit();
                }
                this.globalBindings = this.getBindingManager();
                if (this.statistics != null) {
                    this.statistics.endSave();
                }
                if (this.statistics != null) {
                    this.statistics.tabValueReport("End reset");
                }
            }
        };
        javaReader.setStatistics(this.statistics);
        return javaReader;
    }

    protected void saveResource(URI target, IPath path, Resource resource, IProgressMonitor monitor) throws IOException {
        monitor.subTask(Messages.JavaDiscovererCDO_22);
        resource.save(new HashMap());
    }

    public void setServerDescription(String serverDescription) {
        this.serverDescription = serverDescription;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }
}

