/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.modiscoworkflow.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Element;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.ExportInfos;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.ModiscoworkflowPackage;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Work;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Workflow;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Workflow</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.workflow.modiscoworkflow.impl.WorkflowImpl#getPackageBase <em>Package Base</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.workflow.modiscoworkflow.impl.WorkflowImpl#getSymbolicName <em>Symbolic Name</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.workflow.modiscoworkflow.impl.WorkflowImpl#getElements <em>Elements</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class WorkflowImpl extends ElementImpl implements Workflow {
	/**
	 * The default value of the '{@link #getPackageBase() <em>Package Base</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPackageBase()
	 * @generated
	 * @ordered
	 */
	protected static final String PACKAGE_BASE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPackageBase() <em>Package Base</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPackageBase()
	 * @generated
	 * @ordered
	 */
	protected String packageBase = PACKAGE_BASE_EDEFAULT;

	/**
	 * The default value of the '{@link #getSymbolicName() <em>Symbolic Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSymbolicName()
	 * @generated
	 * @ordered
	 */
	protected static final String SYMBOLIC_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSymbolicName() <em>Symbolic Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSymbolicName()
	 * @generated
	 * @ordered
	 */
	protected String symbolicName = SYMBOLIC_NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getElements() <em>Elements</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getElements()
	 * @generated
	 * @ordered
	 */
	protected EList<Element> elements;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WorkflowImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ModiscoworkflowPackage.Literals.WORKFLOW;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getPackageBase() {
		return packageBase;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPackageBase(String newPackageBase) {
		String oldPackageBase = packageBase;
		packageBase = newPackageBase;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModiscoworkflowPackage.WORKFLOW__PACKAGE_BASE, oldPackageBase, packageBase));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getSymbolicName() {
		return symbolicName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSymbolicName(String newSymbolicName) {
		String oldSymbolicName = symbolicName;
		symbolicName = newSymbolicName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModiscoworkflowPackage.WORKFLOW__SYMBOLIC_NAME, oldSymbolicName, symbolicName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Element> getElements() {
		if (elements == null) {
			elements = new EObjectContainmentEList<Element>(Element.class, this, ModiscoworkflowPackage.WORKFLOW__ELEMENTS);
		}
		return elements;
	}

	/**
	 * <!-- begin-user-doc -->
	 * Allows to retrieve all unit of work without double
	 * <!-- end-user-doc -->
	 * 
	 */
	public EList<Element> getAllUnitsOfWork() {
		EList<Element> listWork = new BasicEList<Element>();
		getAllUnitsOfWork(this,listWork);
		return listWork;
	}

	private void getAllUnitsOfWork(Workflow workflow, EList<Element> list){
		for(Element elmt : workflow.getElements()){
			if(elmt instanceof Work){
				if(findElement(list,elmt)==false){
					list.add(elmt); 
				}
			}else{
				getAllUnitsOfWork((Workflow)elmt,list);
			}
		}
	}
	
	private boolean findElement(EList<Element> list, Element elmt) {
		boolean result = false;
		for(Element element: list){
			if(element.getName().equals(elmt.getName())){
				result=true;
				break;
			}
		}
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ModiscoworkflowPackage.WORKFLOW__ELEMENTS:
				return ((InternalEList<?>)getElements()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ModiscoworkflowPackage.WORKFLOW__PACKAGE_BASE:
				return getPackageBase();
			case ModiscoworkflowPackage.WORKFLOW__SYMBOLIC_NAME:
				return getSymbolicName();
			case ModiscoworkflowPackage.WORKFLOW__ELEMENTS:
				return getElements();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ModiscoworkflowPackage.WORKFLOW__PACKAGE_BASE:
				setPackageBase((String)newValue);
				return;
			case ModiscoworkflowPackage.WORKFLOW__SYMBOLIC_NAME:
				setSymbolicName((String)newValue);
				return;
			case ModiscoworkflowPackage.WORKFLOW__ELEMENTS:
				getElements().clear();
				getElements().addAll((Collection<? extends Element>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ModiscoworkflowPackage.WORKFLOW__PACKAGE_BASE:
				setPackageBase(PACKAGE_BASE_EDEFAULT);
				return;
			case ModiscoworkflowPackage.WORKFLOW__SYMBOLIC_NAME:
				setSymbolicName(SYMBOLIC_NAME_EDEFAULT);
				return;
			case ModiscoworkflowPackage.WORKFLOW__ELEMENTS:
				getElements().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ModiscoworkflowPackage.WORKFLOW__PACKAGE_BASE:
				return PACKAGE_BASE_EDEFAULT == null ? packageBase != null : !PACKAGE_BASE_EDEFAULT.equals(packageBase);
			case ModiscoworkflowPackage.WORKFLOW__SYMBOLIC_NAME:
				return SYMBOLIC_NAME_EDEFAULT == null ? symbolicName != null : !SYMBOLIC_NAME_EDEFAULT.equals(symbolicName);
			case ModiscoworkflowPackage.WORKFLOW__ELEMENTS:
				return elements != null && !elements.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == ExportInfos.class) {
			switch (derivedFeatureID) {
				case ModiscoworkflowPackage.WORKFLOW__PACKAGE_BASE: return ModiscoworkflowPackage.EXPORT_INFOS__PACKAGE_BASE;
				case ModiscoworkflowPackage.WORKFLOW__SYMBOLIC_NAME: return ModiscoworkflowPackage.EXPORT_INFOS__SYMBOLIC_NAME;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == ExportInfos.class) {
			switch (baseFeatureID) {
				case ModiscoworkflowPackage.EXPORT_INFOS__PACKAGE_BASE: return ModiscoworkflowPackage.WORKFLOW__PACKAGE_BASE;
				case ModiscoworkflowPackage.EXPORT_INFOS__SYMBOLIC_NAME: return ModiscoworkflowPackage.WORKFLOW__SYMBOLIC_NAME;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (packageBase: "); //$NON-NLS-1$
		result.append(packageBase);
		result.append(", symbolicName: "); //$NON-NLS-1$
		result.append(symbolicName);
		result.append(')');
		return result.toString();
	}

} //WorkflowImpl
