/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.ui;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.gmt.modisco.workflow.MoDiscoWorkflowLaunchConstants;
import org.eclipse.gmt.modisco.workflow.controller.ControllerWorkflowTransformation;
import org.eclipse.gmt.modisco.workflow.ui.common.Common;
import org.eclipse.gmt.modisco.workflow.ui.common.ExportDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

/**
 * This class defines the export tab
 * @author Nicolas Payneau
 */
@SuppressWarnings("restriction")
public class MoDiscoExportTab extends AbstractLaunchConfigurationTab{

	private ScrolledComposite scrollContainer;
	private Composite rootContainer;
	private String idWorkflow;
	private Combo comboEngine;
	private List<String> idEngineList;
	private Button buttonExportDiscoverer;
	private Button buttonExportWorkflow;
	private Button buttonExportModelInternal;
	private ILaunchConfiguration currentConfiguration;
	
	/**
	 * Constructor
	 */
	public MoDiscoExportTab() {
		this.idEngineList = new ArrayList<String>();
	}

	public void createControl(Composite parent) {
		this.scrollContainer = new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);
		this.scrollContainer.setExpandHorizontal(true);
		this.scrollContainer.setExpandVertical(true);
		
		this.rootContainer = new Composite(this.scrollContainer, SWT.NULL);
		GridLayout layoutRoot = new GridLayout();
		this.rootContainer.setLayout(layoutRoot);
		layoutRoot.numColumns = 1;
		layoutRoot.verticalSpacing = 9;
		this.scrollContainer.setContent(this.rootContainer);
		
		createGroupWorkflowType();
		createGroupExport();
	    
	    this.initializeCombo();
	    setControl(this.rootContainer);
		setControl(this.scrollContainer);
	}

	/**
	 * Allows to create the group to select an engine type.
	 */
	private void createGroupWorkflowType() {
	    Group groupWorkflow = new Group(this.rootContainer, SWT.NULL);
	    groupWorkflow.setText(Messages.MoDiscoExportTab_0);
	    GridLayout layoutGroup = new GridLayout();
		groupWorkflow.setLayout(layoutGroup);
		layoutGroup.numColumns = 3;
		layoutGroup.verticalSpacing = 9;
		GridData gdHoriz = new GridData(GridData.FILL_HORIZONTAL);
		groupWorkflow.setLayoutData(gdHoriz);

	    Label labelWorkflow = new Label(groupWorkflow, SWT.NONE);
	    labelWorkflow.setText(Messages.MoDiscoExportTab_1);
	    labelWorkflow.pack();
	    
	    this.comboEngine = new Combo(groupWorkflow, SWT.READ_ONLY);
	    this.comboEngine.setLayoutData(gdHoriz);
	    this.comboEngine.pack();
	    this.comboEngine.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				MoDiscoExportTab.this.idWorkflow = 	MoDiscoExportTab.this.idEngineList.get(MoDiscoExportTab.this.comboEngine.getSelectionIndex());		
				updateLaunchConfigurationDialog();
			}
		});
	}
	
	/**
	 * Allows to create a group to export our engine (As a discoverer or as a file)
	 */
	private void createGroupExport() {
		GridData gdText = new GridData();
		gdText.horizontalAlignment = SWT.END;
		GridData gdLabel = new GridData();
		gdLabel.horizontalSpan = 2;
		gdLabel.grabExcessHorizontalSpace = true;
		Group groupExport = SWTFactory.createGroup(this.rootContainer, Messages.MoDiscoExportTab_2, 3, 2, GridData.FILL_HORIZONTAL);
	    Label nameDiscoverer = new Label(groupExport,SWT.NULL);
	    nameDiscoverer.setText(Messages.MoDiscoExportTab_3);
		this.buttonExportDiscoverer = SWTFactory.createPushButton(groupExport, Messages.MoDiscoExportTab_4, Activator.getImageDescriptor("icon/buttonExport.png").createImage()); //$NON-NLS-2$
		this.buttonExportDiscoverer.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				MoDiscoExportTab.this.exportDiscoverer();
			}
		});
		nameDiscoverer.setLayoutData(gdLabel);
		this.buttonExportDiscoverer.setLayoutData(gdText);
		Label outputPath = new Label(groupExport,SWT.NULL);
	    outputPath.setText(Messages.MoDiscoExportTab_6);
		outputPath.setLayoutData(gdLabel);
	    this.buttonExportWorkflow = SWTFactory.createPushButton(groupExport, Messages.MoDiscoExportTab_7, Activator.getImageDescriptor("icon/buttonExport.png").createImage()); //$NON-NLS-2$
		this.buttonExportWorkflow.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				MoDiscoExportTab.this.handleExportLocationButtonSelected(false);
				Common.getInstance().refreshPackageExplorer();
			}
		});
		this.buttonExportWorkflow.setLayoutData(gdText);
		GridData gdLabel2 = new GridData();
		gdLabel2.horizontalSpan = 2;
		Label modelInternalLabel = new Label(groupExport,SWT.NULL);
		modelInternalLabel.setText(Messages.MoDiscoExportTab_9);
		modelInternalLabel.setLayoutData(gdLabel2);
	    this.buttonExportModelInternal = SWTFactory.createPushButton(groupExport, Messages.MoDiscoExportTab_10, Activator.getImageDescriptor("icon/buttonExport.png").createImage()); //$NON-NLS-2$
		this.buttonExportModelInternal.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				MoDiscoExportTab.this.handleExportLocationButtonSelected(true);
				Common.getInstance().refreshPackageExplorer();
			}
		});
		this.buttonExportModelInternal.setLayoutData(gdText);
	}	

	/**
	 * Allows to export the MoDiscoWorkflow in discoverer plug-in project
	 */
	private void exportDiscoverer() {
		IStatus status = getController().verifyNameToExportDiscoverer();
		if(status.isOK()){
			ExportDialog dialog = new ExportDialog(this.currentConfiguration.getName(),getShell());
			dialog.open();
			if(dialog.isExport()){
				getController().exportMoDiscoWorkflowToDiscovererProject(dialog.getProjectName(),dialog.getSymbolicName(),dialog.getBaseName());
			}
		}else{
			MessageDialog.openError(getShell(), Messages.MoDiscoExportTab_12, status.getMessage()+Messages.MoDiscoExportTab_13);
		}
	}

	public String getName() {
		return Messages.MoDiscoExportTab_14;
	}

	public void initializeFrom(ILaunchConfiguration configuration) {
		this.currentConfiguration = configuration;
		try {
			this.comboEngine.select(this.idEngineList.indexOf(configuration.getAttribute(MoDiscoWorkflowLaunchConstants.idWorkflow, MoDiscoWorkflowLaunchConstants.idMinimaliste)));
			this.idWorkflow = configuration.getAttribute(MoDiscoWorkflowLaunchConstants.idWorkflow, MoDiscoWorkflowLaunchConstants.idMinimaliste);
		}catch (CoreException e) {
			e.printStackTrace();
		}
	}

	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute(MoDiscoWorkflowLaunchConstants.idWorkflow, this.idWorkflow);
	}

	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {}
	
	public Image getImage() {
		return Activator.getImageDescriptor(Constants.pathExportImage).createImage();
	}
		
	/**
	 * Allows to initialize the combo engine type
	 */
	private void initializeCombo() {
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint point = registry.getExtensionPoint(Constants.nameExtensionPointWorkflow); 

		for (IExtension extension : point.getExtensions()) {
			for (IConfigurationElement element : extension.getConfigurationElements()) {
				if(element.getName().equals(Constants.workflowCoreExtensionPointWorkflow)){
					this.comboEngine.add(element.getAttribute("name")); //$NON-NLS-1$
					this.idEngineList.add(extension.getUniqueIdentifier());
				}
			}
		}	
	}
	
	/**
	 * Handles the shared location button being selected
	 */
	private void handleExportLocationButtonSelected(boolean exportModelinternal) { 
		IContainer currentContainer = ResourcesPlugin.getWorkspace().getRoot();
		ContainerSelectionDialog dialog = new ContainerSelectionDialog(getShell(),
				   currentContainer,false,Messages.MoDiscoExportTab_16);
		dialog.showClosedProjects(false);
		dialog.open();
		Object[] results = dialog.getResult();	
		if ((results != null) && (results.length > 0) && (results[0] instanceof IPath)) {
			IPath path = (IPath)results[0];
			String fullPath = ResourcesPlugin.getWorkspace().getRoot().findMember(path).getLocation().makeAbsolute().toString();
			if(exportModelinternal){
				MoDiscoExportTab.this.getController().exportInternalModel(fullPath);				
			}else{
				MoDiscoExportTab.this.getController().exportWorkflow(this.currentConfiguration,fullPath);
			}
		}		
	}
	
	/**
	 * Allows to retrieve the controller of MoDiscoWorkflow
	 * @return The controller of MoDIscoWorkflow
	 */
	private ControllerWorkflowTransformation getController(){
		ControllerWorkflowTransformation controller = null;
		for(ILaunchConfigurationTab tab : getLaunchConfigurationDialog().getTabs()){
			if(tab instanceof WorkflowTransformationTab){
				controller = ((WorkflowTransformationTab)tab).getController();
				break;
			}
		}
		return controller;
	}
}
