/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grgoire Dup (Mia-Software)
 *******************************************************************************/
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryException;
import org.eclipse.gmt.modisco.infra.role.Role;
import org.eclipse.gmt.modisco.infra.role.RoleSet;
import org.eclipse.gmt.modisco.infra.role.core.RoleContext;
import org.eclipse.gmt.modisco.infra.role.core.RoleSetCatalog;
import org.eclipse.gmt.modisco.infra.role.core.exception.ModiscoRoleException;

public class Example {

	public Integer getNbAbstractMethod(EObject eObject)
			throws ModelQueryException, ModiscoRoleException {
		RoleSet roleSet = RoleSetCatalog.getSingleton().getRoleSet(Messages.Example_0);
		RoleContext context = new RoleContext();
		context.addRoleSet(roleSet);
		Role role = roleSet.getRole("AbstractClassDeclaration"); //$NON-NLS-1$
		if (context.isInstance(eObject, role)) {
			Object object = context.get(eObject, role
					.getEStructuralFeature("nbAbstractMethod")); //$NON-NLS-1$
			if (object instanceof Integer) {
				Integer nbAbstractMethod = (Integer) object;
				return nbAbstractMethod;
			}
		}
		return null;
	}
}
