/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grgoire Dup (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.role.ui;

import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * @author Grgoire Dup (Mia-Software)
 * 
 */
public class ImageProvider {
	private static final String MODEL_QUERY_SET = "icons/roleSet.png"; //$NON-NLS-1$
	private static final String MODEL_QUERY = "icons/role.png"; //$NON-NLS-1$

	private static ImageProvider singleton = new ImageProvider();
	private Image roleSet;
	private Image role;

	public static ImageProvider getSingleton() {
		return ImageProvider.singleton;
	}

	public Image getRoleSet() {
		if (this.roleSet == null) {
			this.roleSet = AbstractUIPlugin.imageDescriptorFromPlugin(Activator.PLUGIN_ID,
					ImageProvider.MODEL_QUERY_SET).createImage();
		}
		return this.roleSet;
	}

	public Image getRole() {
		if (this.role == null) {
			this.role = AbstractUIPlugin.imageDescriptorFromPlugin(Activator.PLUGIN_ID,
					ImageProvider.MODEL_QUERY).createImage();
		}
		return this.role;
	}

}
