/**
 * *******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * 
 *     Fabien Giquel (Mia-Software) - initial API and implementation
 * *******************************************************************************
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.xml.emf.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.gmt.modisco.xml.Attribute;
import org.eclipse.gmt.modisco.xml.CDATA;
import org.eclipse.gmt.modisco.xml.Comment;
import org.eclipse.gmt.modisco.xml.DocumentTypeDeclaration;
import org.eclipse.gmt.modisco.xml.Element;
import org.eclipse.gmt.modisco.xml.Namespace;
import org.eclipse.gmt.modisco.xml.ProcessingInstruction;
import org.eclipse.gmt.modisco.xml.Root;
import org.eclipse.gmt.modisco.xml.Text;
import org.eclipse.gmt.modisco.xml.emf.moDiscoXMLFactory;
import org.eclipse.gmt.modisco.xml.emf.moDiscoXMLPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class moDiscoXMLFactoryImpl extends EFactoryImpl implements moDiscoXMLFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static moDiscoXMLFactory init() {
		try {
			moDiscoXMLFactory themoDiscoXMLFactory = (moDiscoXMLFactory) EPackage.Registry.INSTANCE
					.getEFactory("http://www.eclipse.org/MoDisco/Xml/0.1.incubation/XML"); //$NON-NLS-1$
			if (themoDiscoXMLFactory != null) {
				return themoDiscoXMLFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new moDiscoXMLFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public moDiscoXMLFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case moDiscoXMLPackage.ATTRIBUTE: return createAttribute();
			case moDiscoXMLPackage.TEXT: return createText();
			case moDiscoXMLPackage.ELEMENT: return createElement();
			case moDiscoXMLPackage.ROOT: return createRoot();
			case moDiscoXMLPackage.NAMESPACE: return createNamespace();
			case moDiscoXMLPackage.COMMENT: return createComment();
			case moDiscoXMLPackage.DOCUMENT_TYPE_DECLARATION: return createDocumentTypeDeclaration();
			case moDiscoXMLPackage.CDATA: return createCDATA();
			case moDiscoXMLPackage.PROCESSING_INSTRUCTION: return createProcessingInstruction();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier"); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Attribute createAttribute() {
		AttributeImpl attribute = new AttributeImpl();
		return attribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Text createText() {
		TextImpl text = new TextImpl();
		return text;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Element createElement() {
		ElementImpl element = new ElementImpl();
		return element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Root createRoot() {
		RootImpl root = new RootImpl();
		return root;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Namespace createNamespace() {
		NamespaceImpl namespace = new NamespaceImpl();
		return namespace;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Comment createComment() {
		CommentImpl comment = new CommentImpl();
		return comment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DocumentTypeDeclaration createDocumentTypeDeclaration() {
		DocumentTypeDeclarationImpl documentTypeDeclaration = new DocumentTypeDeclarationImpl();
		return documentTypeDeclaration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CDATA createCDATA() {
		CDATAImpl cdata = new CDATAImpl();
		return cdata;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessingInstruction createProcessingInstruction() {
		ProcessingInstructionImpl processingInstruction = new ProcessingInstructionImpl();
		return processingInstruction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public moDiscoXMLPackage getmoDiscoXMLPackage() {
		return (moDiscoXMLPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static moDiscoXMLPackage getPackage() {
		return moDiscoXMLPackage.eINSTANCE;
	}

} //moDiscoXMLFactoryImpl
