/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Grgoire Dup (Mia-Software)
 *     Nicolas Bros (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.query.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.query.core.Activator;
import org.eclipse.gmt.modisco.infra.query.ui.views.queryExecution.QueryExecutionView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/**
 * Opens the "Query Execution" view, and sets its context to the list of
 * currently selected {@link EObject}s in the browser.
 */
public class ExecuteQueryAction implements IActionDelegate {

	private IViewPart openQueryExecutionView() {
		try {
			IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
			if (window != null) {
				IWorkbenchPage activePage = window.getActivePage();
				if (activePage != null) {
					return activePage.showView(QueryExecutionView.ID);
				}
			}
		} catch (final PartInitException e) {
			MoDiscoLogger.logError(e, Activator.getDefault());
		}
		return null;
	}

	private ISelection selection2 = null;

	public void run(IAction action) {
		List<EObject> selectedEObjects = new ArrayList<EObject>();
		if (this.selection2 instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection) this.selection2;
			Iterator<?> iterator = structuredSelection.iterator();
			while (iterator.hasNext()) {
				Object selectedElement = iterator.next();
				if (selectedElement instanceof EObject) {
					EObject element = (EObject) selectedElement;
					selectedEObjects.add(element);
				}
			}
		}
		IViewPart view = openQueryExecutionView();
		if (selectedEObjects.size() > 0) {
			if (view instanceof QueryExecutionView) {
				QueryExecutionView queryExecutionView = (QueryExecutionView) view;
				queryExecutionView.setContext(selectedEObjects);
			}
		}

	}

	public void selectionChanged(IAction action, ISelection selection) {
		this.selection2 = selection;
	}
}
