/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Fabien Giquel (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.common.ui;

import java.util.ResourceBundle;

import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class MoDiscoCommonUIPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipse.gmt.modisco.common.ui"; //$NON-NLS-1$

	// The shared instance
	private static MoDiscoCommonUIPlugin plugin;

	private ResourceBundle resourceBundle;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext
	 * )
	 */
	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		MoDiscoCommonUIPlugin.plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext
	 * )
	 */
	@Override
	public void stop(final BundleContext context) throws Exception {
		MoDiscoCommonUIPlugin.plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 * 
	 * @return the shared instance
	 */
	public static MoDiscoCommonUIPlugin getDefault() {
		return MoDiscoCommonUIPlugin.plugin;
	}

	/**
	 * Locate and search a value in a plugin.properties file.
	 * 
	 * @param key
	 *            the key
	 * @return the corresponding value
	 */
	public String getString(final String key) {
		if (this.resourceBundle == null) {
			this.resourceBundle = Platform.getResourceBundle(getBundle());
		}
		if (this.resourceBundle != null) {
			return this.resourceBundle.getString(key);
		} else {
			return '%' + key;
		}
	}

}
