/*******************************************************************************
 * Copyright (c) 2008, 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.common.core.amwpropparser;

import java.util.ArrayList;
import java.util.List;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/**
 * @author Gabriel Barbier
 * 
 */
public class AmwPropContentHandler implements ContentHandler {

	public void characters(final char[] value, final int offset, final int count)
			throws SAXException {
		if (this.startModelPath) {
			String path = new String(value, offset, count);
			this.weavedModelsPaths.add(path);
		}
	}

	public void endDocument() throws SAXException {
	}

	public void endElement(final String uri, final String localName, final String qName)
			throws SAXException {
		if (localName.equals(this.modelPath)) {
			this.startModelPath = false;
		}
	}

	public void endPrefixMapping(final String arg0) throws SAXException {
	}

	public void ignorableWhitespace(final char[] arg0, final int arg1, final int arg2)
			throws SAXException {
	}

	public void processingInstruction(final String arg0, final String arg1) throws SAXException {
	}

	public void setDocumentLocator(final Locator arg0) {
	}

	public void skippedEntity(final String arg0) throws SAXException {
	}

	public void startDocument() throws SAXException {
	}

	public void startElement(final String uri, final String localName, final String qName,
			final Attributes attributes) throws SAXException {
		if (localName.equals(this.modelPath)) {
			this.startModelPath = true;
		}
	}

	public void startPrefixMapping(final String arg0, final String arg1) {
	}

	private boolean startModelPath = false;
	private final String modelPath = "model-relative-path"; //$NON-NLS-1$
	private final List<String> weavedModelsPaths = new ArrayList<String>();

	public List<String> getWeavedModelsPaths() {
		return this.weavedModelsPaths;
	}
}
