/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.browser.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

import org.eclipse.gmt.modisco.common.core.utils.ImageUtils;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.gmt.modisco.infra.browser.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.role.Role;
import org.eclipse.gmt.modisco.infra.role.RolePackage;
import org.eclipse.gmt.modisco.infra.role.RoleSet;
import org.eclipse.gmt.modisco.infra.role.core.RoleSetCatalog;
import org.eclipse.gmt.modisco.infra.role.ui.views.RoleSetContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class LoadRolesAction extends Action {

	private final IBrowserActionBarContributor browserActionBarContributor;

	public LoadRolesAction(final IBrowserActionBarContributor browserActionBarContributor) {
		super();
		this.browserActionBarContributor = browserActionBarContributor;
		setToolTipText(Messages.BrowserActionBarContributor_loadRole);
		setImageDescriptor(ImageProvider.getInstance().getRoleIconDescriptor());
	}

	@Override
	public void run() {
		final EcoreBrowser browser = this.browserActionBarContributor.getBrowser();
		if (browser != null) {

			final ITreeContentProvider treeContentProvider = new RoleSetContentProvider(
					RolePackage.eINSTANCE.getRole());

			final CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(null,
					this.labelProvider, treeContentProvider);
			dialog.setTitle(Messages.BrowserActionBarContributor_dialogTitle_LoadRoles);
			dialog.setMessage(Messages.BrowserActionBarContributor_chooseRoleToLoad);
			final Collection<RoleSet> roleSets = RoleSetCatalog.getSingleton().getAllRoleSets();
			// dialog.setElements(roleSets.toArray());
			dialog.setInput(roleSets.toArray());

			dialog.setInitialElementSelections(new ArrayList<Role>(browser
					.getBrowserConfiguration().getLoadedRoles()));

			if (dialog.open() == Window.OK) {
				final Object[] result = dialog.getResult();
				browser.getBrowserConfiguration().cleanRoles();
				HashSet<Role> rolesToLoad = new HashSet<Role>();
				for (final Object resultElement : result) {
					if (resultElement instanceof Role) {
						final Role role = (Role) resultElement;
						rolesToLoad.add(role);
					} else if (resultElement instanceof RoleSet) {
						final RoleSet roleSet = (RoleSet) resultElement;
						rolesToLoad.addAll(roleSet.getRoles());
					} else {
						throw new RuntimeException("Unexpected element type"); //$NON-NLS-1$
					}
				}
				for (Role roleToLoad : rolesToLoad) {
					browser.getBrowserConfiguration().loadRole(roleToLoad);
				}
				if (rolesToLoad.size() > 0) {
					// since customizations can apply to roles, reload
					// customizations
					browser.getBrowserConfiguration().getCustomizationEngine().loadCustomizations();
				}
				browser.reloadModel();
			}
		}
	}

	private final LabelProvider labelProvider = new LabelProvider() {
		@Override
		public String getText(final Object element) {
			String label;
			if (element instanceof RoleSet) {
				final RoleSet roleSet = (RoleSet) element;
				label = roleSet.getName();
			} else if (element instanceof Role) {
				final Role role = (Role) element;
				label = role.getName();
			} else if (element == null) {
				label = "null"; //$NON-NLS-1$
			} else {
				label = element.getClass().getName();
			}
			return label;
		}

		@Override
		public org.eclipse.swt.graphics.Image getImage(final Object element) {
			return ImageUtils.getImage(element);
		}
	};
}
