/*******************************************************************************
 * Copyright (c) 2008, 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *    Nicolas Bros (Mia-Software)
 *******************************************************************************/

package org.eclipse.gmt.modisco.infra.browser.actions;

import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.gmt.modisco.infra.browser.ui.UriSelectionDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenModelFromEmfRegistryAction implements IWorkbenchWindowActionDelegate {

	private IWorkbenchWindow fWorkbenchWindow;

	public void dispose() {
	}

	public void init(final IWorkbenchWindow window) {
		this.fWorkbenchWindow = window;
	}

	public void run(final IAction action) {
		final IWorkbenchPage activePage = this.fWorkbenchWindow.getActivePage();
		if (activePage != null) {
			final UriSelectionDialog launcher = new UriSelectionDialog(this.fWorkbenchWindow
					.getShell());
			if (launcher.open() == Window.OK) {
				final String metamodelLocation = launcher.getUriSelected();
				try {
					final IEditorInput input = new URIEditorInput(URI.createURI(metamodelLocation));

					IDE.openEditor(activePage, input, EcoreBrowser.EDITOR_ID, true);
				} catch (final PartInitException e) {
					e.printStackTrace();
					MoDiscoBrowserPlugin.logException(e);
				}
			}
		}
	}

	public void selectionChanged(final IAction action, final ISelection selection) {
	}
}
