/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.browser.adapters;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.ui.views.properties.IPropertySource;

public class PropertySourceAdapterFactory extends AdapterFactoryImpl {

	private final BrowserConfiguration fBrowserConfiguration;

	public PropertySourceAdapterFactory(final BrowserConfiguration browserConfiguration) {
		this.fBrowserConfiguration = browserConfiguration;
	}

	@Override
	protected Adapter createAdapter(final Notifier target) {
		PropertySourceAdapter propertySourceAdapter = new PropertySourceAdapter(target,
				this.fBrowserConfiguration);
		return propertySourceAdapter;
	}

	@Override
	public boolean isFactoryForType(final Object type) {
		return type == IPropertySource.class;
	}
}
