/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.gmt.modisco.infra.browser.editors;

import org.eclipse.gmt.modisco.infra.browser.core.ITreeElement;
import org.eclipse.gmt.modisco.infra.browser.core.MetaclassList;
import org.eclipse.gmt.modisco.infra.browser.core.SearchResults;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class BrowserContentProvider implements ITreeContentProvider {

	public Object[] getElements(final Object inputElement) {
		if (inputElement instanceof MetaclassList) {
			final MetaclassList metaclassList = (MetaclassList) inputElement;
			return metaclassList.getElements().toArray();
		} else if (inputElement instanceof SearchResults) {
			final SearchResults searchResults = (SearchResults) inputElement;
			return searchResults.getElements().toArray();
		}
		return null;
	}

	public Object[] getChildren(final Object parentElement) {
		if (parentElement instanceof ITreeElement) {
			final ITreeElement treeElement = (ITreeElement) parentElement;
			return treeElement.getChildren().toArray();
		}
		return null;
	}

	public Object getParent(final Object element) {
		if (element instanceof ITreeElement) {
			final ITreeElement treeElement = (ITreeElement) element;
			return treeElement.getTreeParent();
		}
		return null;
	}

	public boolean hasChildren(final Object element) {
		if (element instanceof ITreeElement) {
			final ITreeElement treeElement = (ITreeElement) element;
			return treeElement.hasChildren();
		}
		return false;
	}

	public void dispose() {
	}

	public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
	}
}
