/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.gmt.modisco.infra.browser.editors;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

/**
 * The left pane in the model editor, containing the list (tree) of metaclasses
 * and the list of model services
 */
public class LeftPane {

	/** The viewer where a list of metaclasses is shown */
	private final MetaclassViewer metaclassViewer;
	private final BrowserConfiguration editorConfiguration;
	private MetaclassViewToolBar toolbar;
	private Composite toolBarComposite;

	public LeftPane(final Composite toolbarParent, final Composite parent,
			final BrowserConfiguration editorConfiguration, final FormToolkit formToolkit) {
		this.editorConfiguration = editorConfiguration;

		// GridLayout gridLayout = new GridLayout(1, false);
		// gridLayout.marginBottom = 5;
		// gridLayout.marginHeight = 0;
		// gridLayout.marginWidth = 0;
		// parent.setLayout(gridLayout);

		createToolBar(toolbarParent);

		this.metaclassViewer = new MetaclassViewer(parent, editorConfiguration, formToolkit);

		// GridData metaclassViewerGridData = new GridData();
		// metaclassViewerGridData.grabExcessHorizontalSpace = true;
		// metaclassViewerGridData.grabExcessVerticalSpace = true;
		// metaclassViewerGridData.horizontalAlignment = SWT.FILL;
		// metaclassViewerGridData.verticalAlignment = SWT.FILL;
		// this.metaclassViewer.getViewer().getControl().setLayoutData(metaclassViewerGridData);

		this.toolbar.setMetaclassViewer(this.metaclassViewer);
	}

	public Composite getToolBarComposite() {
		return this.toolBarComposite;
	}

	public MetaclassViewToolBar getToolbar() {
		return this.toolbar;
	}

	private void createToolBar(final Composite parent) {
		this.toolBarComposite = new Composite(parent, SWT.WRAP);
		// GridData toolBarGridData = new GridData();
		// toolBarGridData.grabExcessHorizontalSpace = true;
		// toolBarGridData.horizontalAlignment = SWT.FILL;
		// toolBarComposite.setLayoutData(toolBarGridData);

		this.toolbar = new MetaclassViewToolBar(this.toolBarComposite, this.editorConfiguration);
	}

	public MetaclassViewer getMetaclassViewer() {
		return this.metaclassViewer;
	}
}
