/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.gmt.modisco.infra.browser.editors;

import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.util.ImageProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public final class TreeToolBar {

	private final ToolBar toolBar;
	private ToolItem btnShowMenu;
	private final EcoreBrowser browser;
	private final Composite fParentComposite;

	public static TreeToolBar create(final Composite parent, final EcoreBrowser browser) {
		return new TreeToolBar(parent, browser);
	}

	private TreeToolBar(final Composite parent, final EcoreBrowser browser) {
		this.fParentComposite = parent;
		this.browser = browser;

		final RowLayout layout = new RowLayout(SWT.HORIZONTAL);
		layout.wrap = true;
		parent.setLayout(layout);

		ToolBarManager toolBarManager = new ToolBarManager(SWT.FLAT);
		toolBarManager.add(this.actionSortInstances);
		toolBarManager.add(this.actionShowEmptyLinks);
		toolBarManager.add(this.actionShowDerivedLinks);
		this.toolBar = toolBarManager.createControl(parent);

		initialize();
		createShowMenuAction();
	}

	private void createShowMenuAction() {
		this.btnShowMenu = new ToolItem(this.toolBar, SWT.PUSH);
		this.btnShowMenu.setToolTipText(Messages.MetaclassViewToolBar_showViewMenu);
		this.btnShowMenu.setImage(ImageProvider.getInstance().getViewMenuIcon());
		// listen on the toolbar so that the menu can appear on MouseDown
		this.toolBar.addListener(SWT.MouseDown, new Listener() {
			public void handleEvent(final Event event) {
				if (TreeToolBar.this.toolBar.getItem(new Point(event.x, event.y)) == TreeToolBar.this.btnShowMenu) {
					MenuManager menuManager = new MenuManager();
					menuManager.add(TreeToolBar.this.actionSortLinks);
					menuManager.add(TreeToolBar.this.actionSortLinksByType);
					menuManager.add(TreeToolBar.this.actionShowFullQualifiedNames);
					menuManager.add(TreeToolBar.this.actionShowMultiplicity);
					menuManager.add(TreeToolBar.this.actionShowOrdering);
					menuManager.add(TreeToolBar.this.actionShowOppositeLinks);
					menuManager.add(TreeToolBar.this.actionShowContainer);
					menuManager.add(TreeToolBar.this.actionShowAttributes);
					menuManager.add(TreeToolBar.this.actionShowEmptyAttributes);
					menuManager.add(TreeToolBar.this.actionShowTypeOfLinks);
					Menu contextMenu = menuManager
							.createContextMenu(TreeToolBar.this.fParentComposite);
					Rectangle bounds = Display.getCurrent().map(TreeToolBar.this.toolBar, null,
							TreeToolBar.this.btnShowMenu.getBounds());
					contextMenu.setLocation(bounds.x, bounds.y + bounds.height);
					contextMenu.setVisible(true);
				}
			}
		});
	}

	private final Action actionShowTypeOfLinks = new Action(Messages.TreeToolBar_showTypeOfLinks,
			IAction.AS_CHECK_BOX) {
		{
			setToolTipText(Messages.TreeToolBar_showTypeOfLinks);
			setImageDescriptor(ImageProvider.getInstance().getLinkTypeIconDescriptor());
		}

		@Override
		public void run() {
			TreeToolBar.this.browser.setShowTypeOfLinks(isChecked());
		};
	};

	private final Action actionShowEmptyLinks = new Action(Messages.TreeToolBar_showEmptyLinks,
			IAction.AS_CHECK_BOX) {
		{
			setToolTipText(Messages.TreeToolBar_showEmptyLinks);
			setImageDescriptor(ImageProvider.getInstance().getEmptyLinksImageDescriptor());
		}

		@Override
		public void run() {
			TreeToolBar.this.browser.setShowEmptyLinks(isChecked());
		};
	};

	private final Action actionShowDerivedLinks = new Action(Messages.TreeToolBar_showDerivedLinks,
			IAction.AS_CHECK_BOX) {
		{
			setToolTipText(Messages.TreeToolBar_showDerivedLinks);
			setImageDescriptor(ImageProvider.getInstance().getShowDerivedLinksImageDescriptor());
		}

		@Override
		public void run() {
			TreeToolBar.this.browser.setShowDerivedLinks(isChecked());
		};
	};

	private final Action actionSortInstances = new Action(Messages.TreeToolBar_sortInstances,
			IAction.AS_CHECK_BOX) {
		{
			setToolTipText(Messages.TreeToolBar_sortInstances);
			setImageDescriptor(ImageProvider.getInstance().getSortInstancesIcon());
		}

		@Override
		public void run() {
			TreeToolBar.this.browser.setSortInstances(isChecked());
		};
	};

	private final Action actionSortLinks = new Action(Messages.TreeToolBar_sortLinks,
			IAction.AS_CHECK_BOX) {
		{
			setToolTipText(Messages.TreeToolBar_sortLinks);
			setImageDescriptor(ImageProvider.getInstance().getSortLinksImageDescriptor());
		}

		@Override
		public void run() {
			TreeToolBar.this.browser.setSortLinks(isChecked());
		};
	};

	private final Action actionSortLinksByType = new Action(Messages.TreeToolBar_sortLinksByType,
			IAction.AS_CHECK_BOX) {
		{
			setToolTipText(Messages.TreeToolBar_sortLinksByType);
			setImageDescriptor(ImageProvider.getInstance().getSortLinksByTypeImageDescriptor());
		}

		@Override
		public void run() {
			TreeToolBar.this.browser.setSortLinksByType(isChecked());
		};
	};

	private final Action actionShowFullQualifiedNames = new Action(
			Messages.TreeToolBar_showFullQualifiedNames, IAction.AS_CHECK_BOX) {
		{
			setToolTipText(Messages.TreeToolBar_showFullQualifiedNames);
			setImageDescriptor(ImageProvider.getInstance()
					.getShowFullQualifiedNamesImageDescriptor());
		}

		@Override
		public void run() {
			TreeToolBar.this.browser.setShowFullQualifiedNames(isChecked());
		};
	};

	private final Action actionShowMultiplicity = new Action(Messages.TreeToolBar_showMultiplicity,
			IAction.AS_CHECK_BOX) {
		{
			setToolTipText(Messages.TreeToolBar_showMultiplicity);
			setImageDescriptor(ImageProvider.getInstance().getShowMultiplicityImageDescriptor());

		}

		@Override
		public void run() {
			TreeToolBar.this.browser.setShowMultiplicity(isChecked());
		};
	};

	private final Action actionShowOppositeLinks = new Action(
			Messages.TreeToolBar_showOppositeLinks, IAction.AS_CHECK_BOX) {
		{
			setToolTipText(Messages.TreeToolBar_showOppositeLinks);
			setImageDescriptor(ImageProvider.getInstance().getShowOppositeLinksImageDescriptor());
		}

		@Override
		public void run() {
			TreeToolBar.this.browser.setShowOppositeLinks(isChecked());
		};
	};

	private final Action actionShowContainer = new Action(Messages.TreeToolBar_showContainer,
			IAction.AS_CHECK_BOX) {
		{
			setToolTipText(Messages.TreeToolBar_showContainer);
			setImageDescriptor(ImageProvider.getInstance().getContainerImageDescriptor());
		}

		@Override
		public void run() {
			TreeToolBar.this.browser.setShowContainer(isChecked());
		};
	};

	private final Action actionShowAttributes = new Action(Messages.TreeToolBar_showAttributes,
			IAction.AS_CHECK_BOX) {
		{
			setToolTipText(Messages.TreeToolBar_showAttributes);
			setImageDescriptor(ImageProvider.getInstance().getAttributeImageDescriptor());
		}

		@Override
		public void run() {
			TreeToolBar.this.browser.setShowAttributes(isChecked());
			TreeToolBar.this.actionShowEmptyAttributes.setEnabled(isChecked());
		};
	};

	private final Action actionShowEmptyAttributes = new Action(
			Messages.TreeToolBar_showEmptyAttributes, IAction.AS_CHECK_BOX) {
		{
			setToolTipText(Messages.TreeToolBar_showEmptyAttributes);
			setImageDescriptor(ImageProvider.getInstance().getEmptyAttributeImageDescriptor());
		}

		@Override
		public void run() {
			TreeToolBar.this.browser.setShowEmptyAttributes(isChecked());
		};
	};

	private final Action actionShowOrdering = new Action(Messages.TreeToolBar_showOrdering,
			IAction.AS_CHECK_BOX) {
		{
			setToolTipText(Messages.TreeToolBar_showOrdering);
			setImageDescriptor(ImageProvider.getInstance().getOrderingImageDescriptor());
		}

		@Override
		public void run() {
			TreeToolBar.this.browser.setShowOrdering(isChecked());
		};
	};

	private void initialize() {
		this.actionShowEmptyLinks.setChecked(this.browser.isShowEmptyLinks());
		this.actionSortInstances.setChecked(this.browser.isSortInstances());
		this.actionSortLinks.setChecked(this.browser.isSortLinks());
		this.actionSortLinksByType.setChecked(this.browser.isSortLinksByType());
		this.actionShowDerivedLinks.setChecked(this.browser.isShowDerivedLinks());
		this.actionShowFullQualifiedNames.setChecked(this.browser.isShowFullQualifiedNames());
		this.actionShowMultiplicity.setChecked(this.browser.isShowMultiplicity());
		this.actionShowOppositeLinks.setChecked(this.browser.isShowOppositeLinks());
		this.actionShowContainer.setChecked(this.browser.isShowContainer());
		this.actionShowAttributes.setChecked(this.browser.isShowAttributes());
		this.actionShowEmptyAttributes.setChecked(this.browser.isShowEmptyAttributes());
		this.actionShowOrdering.setChecked(this.browser.isShowOrdering());
		this.actionShowTypeOfLinks.setChecked(this.browser.isShowTypeOfLinks());

		this.actionShowEmptyAttributes.setEnabled(this.browser.isShowAttributes());
	}
}
