/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.gmt.modisco.infra.browser.editors.table;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;

/** A description of what to show in a column */
public class ColumnDescription {
	/** The possible column types */
	public enum Type {
		DEFAULT_LABEL, METACLASS_NAME, ATTRIBUTE, REFERENCE, ECONTAINER, CONTEXT
	};

	/** The type of this column */
	private final Type type;
	/**
	 * The attribute displayed in the column, when <code>type</code> is
	 * {@link Type#ATTRIBUTE}
	 */
	private EAttribute attribute = null;
	/**
	 * The reference displayed in the column, when <code>type</code> is
	 * {@link Type#REFERENCE}
	 */
	private EReference reference = null;

	public ColumnDescription(final Type type) {
		this.type = type;
	}

	public ColumnDescription(final EAttribute attribute) {
		this.type = ColumnDescription.Type.ATTRIBUTE;
		this.attribute = attribute;
	}

	public ColumnDescription(final EReference reference) {
		this.reference = reference;
		this.type = ColumnDescription.Type.REFERENCE;
	}

	public Type getType() {
		return this.type;
	}

	public EAttribute getAttribute() {
		if (this.type != ColumnDescription.Type.ATTRIBUTE) {
			throw new IllegalStateException();
		}

		return this.attribute;
	}

	public EReference getReference() {
		if (this.type != ColumnDescription.Type.REFERENCE) {
			throw new IllegalStateException();
		}

		return this.reference;
	}
}
