/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Sbastien Minguet (Mia-Software) - initial API and implementation
 *    Frdric Madiot (Mia-Software) - initial API and implementation
 *    Fabien Giquel (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *    Erwan Breton (Sodifrance) - initial API and implementation
 *    Romain Dervaux (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.java.io.java;


import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.Comment;
import org.eclipse.gmt.modisco.java.Package;
import org.eclipse.gmt.modisco.java.io.java.binding.PendingElement;

/**
 * The aim of this class is to link comments to the nodes retlated to
 * JDT does not attach comments (line  and block comments) to model nodes.
 * 
 */
public final class CommentsManager {

	private CommentsManager() {

	}

	public static void resolveCommentPositions(final JDTVisitor visitor) {
		org.eclipse.jdt.core.dom.CompilationUnit cuNode = visitor.getCuNode();
		org.eclipse.gmt.modisco.java.CompilationUnit moDiscoCuNode =
			(org.eclipse.gmt.modisco.java.CompilationUnit) visitor.getBijectiveMap().getValue(cuNode);
		List<Comment> commentsList = new ArrayList<Comment>(visitor.getCommentsBinding().getValues());
		/*
		 * Algorithme de positionnement des commentaires
		 * 
		 * Il faut tout d'abord une liste ordonne de commentaires,
		 * cette liste est fournie par l'objet CompilationUnit (cuNode.getCommentList())
		 * 
		 * Ensuite, il faut faire une passe pour ordonner les noeuds
		 * portant des commentaires. En effet, comme seul les index 
		 * de dbut et de fin sont donns, il y a des recouvrements
		 * puisque les noeuds sont emboits.
		 * Par exemple, pour la classe racine, l'index de dbut sera 2
		 * et l'index de fin sera 11. Pour une mthode dfinie dans cette
		 * classe racine, l'index de dbut sera 4 et l'index de fin sera 6.
		 * Le tri se fera de manire  obtenir en tte de liste 
		 * le noeud dont l'index de dbut de commentaires est 
		 * le plus grand. Et en fin de liste, le noeud dont l'index
		 * de dbut de commentaires est le plus petit.
		 */
		SortedMap<Integer, org.eclipse.jdt.core.dom.ASTNode> nodesMap =
			new TreeMap<Integer, org.eclipse.jdt.core.dom.ASTNode>(new Comparator<Integer>() {
					public int compare(final Integer o1, final Integer o2) {
					return -o1.compareTo(o2);
				}				
			});
		for (org.eclipse.jdt.core.dom.ASTNode node : visitor.getBijectiveMap().getKeys()) {
			int index = cuNode.firstLeadingCommentIndex(node);
			if (index != -1) {
				nodesMap.put(index, node);
			}
		}
		for (Integer indexMap : nodesMap.keySet()) {
			int index = indexMap;
			org.eclipse.jdt.core.dom.ASTNode node = nodesMap.get(indexMap);
			int lastIndex = cuNode.lastTrailingCommentIndex(node);
			if (lastIndex == -1) { // occurs if only one comment associated
				lastIndex = indexMap + 1;
			}
			ASTNode element = visitor.getBijectiveMap().getValue(node);
			if (element instanceof PendingElement) {
				if (((PendingElement) element).getClientNode() != null) {
					element = ((PendingElement) element).getClientNode();
				} else { // should never happen
					element = visitor.getBijectiveMap().getValue(node.getParent());
				}
			}
			
			while (index != -1 && index < cuNode.getCommentList().size()) {
				org.eclipse.jdt.core.dom.ASTNode commentNode = (org.eclipse.jdt.core.dom.ASTNode) cuNode.getCommentList().get(index);
				Comment comment = visitor.getCommentsBinding().get(commentNode);
				if ((comment != null) && (commentsList.contains(comment))) {
					if (index < lastIndex) {
						index++;
						if (!(element instanceof Package)) {
							element.getComments().add(comment);
						} else {
							// misc case : one Package for many CompilationUnit
							moDiscoCuNode.getComments().add(comment);
						}
						// remove from temporary list
						commentsList.remove(comment);
					} else {
						index = -1;
					}
				} else {
					index = -1;
				}
			}
		}
		
		/*
		 *  We assure that all comments are processed, in linking remaining comments to toot type.
		 */
		for (Comment comment : commentsList) {
			if (visitor.getRootTypeOrEnum() != null) {
				visitor.getRootTypeOrEnum().getComments().add(comment);
			} else { // misc case of java file whithout type declaration
				EcoreUtil.delete(comment);
			}
		}
	}

	/**
	 * @param comment
	 * @param originalFileContent
	 * @return content of comment
	 */
	public static String extractCommentContent(
			final org.eclipse.jdt.core.dom.Comment comment,
			final String originalFileContent) {
		String result = originalFileContent.substring(comment.getStartPosition(), 
				comment.getStartPosition() + comment.getLength());
		return result;
	}

}