/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire Dupe (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.java.discoverer.benchmark;

import java.util.Map;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.discoverersmanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.cdo.client.JavaDiscovererCDO;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.cdo.client.nousage.JavaDiscovererCDONoUsages;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.cdo.server.DerbyCDOServerNoAudits;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererClassicalEMF;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererEMFMinimalEObject;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererEMFNoUsages;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererIncrementalClassicalEMF;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererIncrementalEMF;
import org.eclipse.gmt.modisco.java.discoverer.tests.cdo.server.DerbyCDOServer;
import org.eclipse.jdt.core.IJavaProject;

public class RunBenchmark extends AbstractRunBenchmark {


	@Override
	public void discoverElement(final Object source,
			final Map<DiscoveryParameter, Object> parameters) {
		initStatProject((IJavaProject) source);
		benchmark(source);
		copyLog();
		new Report(this.getStatProject()).generate();
		try {
			this.getStatProject().refreshLocal(IResource.DEPTH_INFINITE,
					new NullProgressMonitor());
		} catch (CoreException e) {
			MoDiscoLogger.logWarning(e, Activator.getDefault());
		}
	}

	protected void benchmark(final Object source) {
		// CDO+Derby, No audits, With usages
		serverAndDisco(source, DerbyCDOServerNoAudits.class,
				JavaDiscovererCDO.class);
		// CDO+Derby, No audits, Without usages
		serverAndDisco(source, DerbyCDOServerNoAudits.class,
				JavaDiscovererCDONoUsages.class);
		// CDO+Derby, with audits, With usages
		serverAndDisco(source, DerbyCDOServer.class, JavaDiscovererCDO.class);
		// XMI, incremental
		disco(source, JavaDiscovererIncrementalEMF.class);
		// XMI, MinimalEObject
		disco(source, JavaDiscovererEMFMinimalEObject.class);
		// XMI, Without usages
		disco(source, JavaDiscovererEMFNoUsages.class);
		// Reference discoverer
		disco(source, JavaDiscovererClassicalEMF.class);
		// Incremental and classical EMF
		disco(source, JavaDiscovererIncrementalClassicalEMF.class);
	}
}
